/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIResourceWithTemplateTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME_DEFAULT = "APIResourceWithTemplateDef";
    private final String API_CONTEXT_DEFAULT = "APIResourceWithTemplateDef";
    private final String API_NAME = "APIResourceWithTemplate";
    private final String API_CONTEXT = "APIResourceWithTemplate";
    private final String TEMPLATE_API_NAME = "urlTemplateAPIName";
    private final String TEMPLATE_API_CONTEXT = "urlTemplateContext";
    private final String TEMPLATE_APP_NAME = "urlTemplateApp";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String apiId1;
    private String apiId2;
    private String apiId3;
    private String appId;

    @Factory(dataProvider="userModeDataProvider")
    public APIResourceWithTemplateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            // empty if block
        }
    }

    @Test(groups={"wso2.am"}, description="Test API with resouce containing url template for default api")
    public void testAPIwithResourceTemplateForDefaultAPI() throws Exception {
        this.apiCreationRequestBean = new APICreationRequestBean("APIResourceWithTemplateDef", "APIResourceWithTemplateDef", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDefaultVersionChecked("default_version");
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/resource/{param}");
        resourceBeanList.add(res);
        this.apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        this.apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        this.apiCreationRequestBean.setDefaultVersion("default_version");
        APIDTO apiCreationResponse = this.restAPIPublisher.addAPI(this.apiCreationRequestBean);
        this.apiId1 = apiCreationResponse.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId1);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"APIResourceWithTemplateDef API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.apiId1, this.restAPIPublisher);
        HttpResponse publishAPIResponse = this.publishAPI(apiCreationResponse.getId(), this.restAPIPublisher, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef publish failed");
    }

    @Test(groups={"wso2.am"}, description="Test API with resource containing url template")
    public void testAPIwithResourceTemplateForAPI() throws Exception {
        this.apiCreationRequestBean = new APICreationRequestBean("APIResourceWithTemplate", "APIResourceWithTemplate", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/resource/{param}");
        resourceBeanList.add(res);
        this.apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        APIDTO createAPIResponse = this.restAPIPublisher.addAPI(this.apiCreationRequestBean);
        this.apiId2 = createAPIResponse.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId2);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"APIResourceWithTemplateDef API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.apiId2, this.restAPIPublisher);
        HttpResponse publishAPIResponse = this.publishAPI(this.apiId2, this.restAPIPublisher, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef publish failed");
    }

    @Test(groups={"wso2.am"}, description="Test API uri template default/encode behavior")
    public void testUriEncodingInTemplate() throws Exception {
        String uriTemplate = "/S2222-0496%2815%2927436-0";
        String context = "customcontextendpoint";
        String endpointUrl = this.getGatewayURLNhttp() + context + "/sub{uri.var.urlcontext}";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("urlTemplateAPIName", "urlTemplateContext", API_VERSION_1_0_0, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection("Unlimited");
        ArrayList<APIResourceBean> resList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Unlimited", "/{urlcontext}");
        resList.add(res);
        apiCreationRequestBean.setResourceBeanList(resList);
        APIDTO createAPIResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.apiId3 = createAPIResponse.getId();
        ApplicationDTO createApplication = this.restAPIStore.addApplication("urlTemplateApp", "Unlimited", "", "this-is-test");
        this.appId = createApplication.getApplicationId();
        this.createAPIRevisionAndDeployUsingRest(this.apiId3, this.restAPIPublisher);
        HttpResponse publishAPIResponse = this.publishAPI(this.apiId3, this.restAPIPublisher, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API urlTemplateAPIName publish failed");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "urlTemplateAPIName", API_VERSION_1_0_0, "\"isApiExists\":true");
        this.restAPIStore.subscribeToAPI(this.apiId3, this.appId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("urlTemplateContext", API_VERSION_1_0_0) + uriTemplate;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)invokeURL, requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        URL endpoint = new URL(endpointUrl);
        JSONParser parser = new JSONParser();
        String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + endpointUrl + "\"\n  \"legacy-encoding\": \"" + endpoint + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + endpointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  \"legacy-encoding\": \"" + endpoint + "\"\n  },\n  \"endpoint_type\": \"http\"\n}";
        Object jsonObject = parser.parse(endPointString);
        createAPIResponse.setEndpointConfig(jsonObject);
        this.restAPIPublisher.updateAPI(createAPIResponse);
        this.createAPIRevisionAndDeployUsingRest(this.apiId3, this.restAPIPublisher);
        this.waitForAPIDeployment();
        serviceResponse = HTTPSClientUtils.doGet((String)invokeURL, requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.appId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId1, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId2, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId3, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId1);
        this.restAPIPublisher.deleteAPI(this.apiId2);
        this.restAPIPublisher.deleteAPI(this.apiId3);
        super.cleanUp();
    }
}

