/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class CheckEmptyCORSConfigurationsTestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "CORSPublisherTest";
    private final String apiVersion = "1.0.0";
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public CheckEmptyCORSConfigurationsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API though the publisher rest API and check empty CORS configs ")
    public void testCheckEmptyCORSConfigurations() throws Exception {
        String apiContext = "CORSPublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tagCORS-1, tagCORS-2, tagCORS-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("CORSPublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("apiCORSb");
        apiCreationRequestBean.setBizOwnerMail("apiCORSb@ee.com");
        apiCreationRequestBean.setTechOwner("apiCORSt");
        apiCreationRequestBean.setTechOwnerMail("apiCORSt@ww.com");
        JSONObject testCORSConfiguratoins = new JSONObject();
        testCORSConfiguratoins.put("corsConfigurationEnabled", (Object)"false");
        testCORSConfiguratoins.put("accessControlAllowOrigins", (Object)"null");
        testCORSConfiguratoins.put("accessControlAllowCredentials", (Object)"false");
        testCORSConfiguratoins.put("accessControlAllowHeaders", (Object)"null");
        testCORSConfiguratoins.put("accessControlAllowMethods", (Object)"null");
        apiCreationRequestBean.setCorsConfiguration(testCORSConfiguratoins);
        APIDTO apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        String status = apiCreationResponse.getLifeCycleStatus();
        this.apiId = apiCreationResponse.getId();
        HttpResponse apiResponsePublisher = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)apiResponsePublisher.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"CORSPublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)"CORSPublisherTest".equals(apiCreationResponse.getName()), (String)"CORSPublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(status), (String)"Status of the CORSPublisherTestis not a valid status");
        JSONObject apiDetails = new JSONObject(apiResponsePublisher.getData());
        JSONObject corsConfigs = apiDetails.getJSONObject("corsConfiguration");
        Assert.assertEquals((String)corsConfigs.getString("accessControlAllowOrigins"), (String)"[]");
        Assert.assertEquals((String)corsConfigs.getString("accessControlAllowHeaders"), (String)"[]");
        Assert.assertEquals((String)corsConfigs.getString("accessControlAllowMethods"), (String)"[]");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

