/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APITiersDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class DeleteTierAlreadyAttachedToAPITestCase
extends APIMIntegrationBaseTest {
    private String apiId;
    SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO;

    @Factory(dataProvider="userModeDataProvider")
    public DeleteTierAlreadyAttachedToAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Update API after deleting attached subscription tier")
    public void testUpdateAPIAfterDeletingAttachedSubscriptionTier() throws Exception {
        String displayName = "NewSubscriptionPolicy";
        String description = "This is a new subscription throttle policy";
        String timeUnit = "min";
        Integer unitTime = 1;
        int graphQLMaxComplexity = 400;
        int graphQLMaxDepth = 10;
        int rateLimitCount = -1;
        String rateLimitTimeUnit = "NA";
        boolean stopQuotaOnReach = false;
        String billingPlan = "FREE";
        int subscriberCount = 0;
        String policyName = "NewSubscriptionPolicy";
        Long requestCount = 50L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)timeUnit, (Integer)unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        String INTERNAL_EVERYONE = "Internal/everyone";
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add(INTERNAL_EVERYONE);
        SubscriptionThrottlePolicyPermissionDTO permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, roleList);
        this.subscriptionThrottlePolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)displayName, (String)description, (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)graphQLMaxComplexity, (int)graphQLMaxDepth, (int)rateLimitCount, (String)rateLimitTimeUnit, null, (boolean)stopQuotaOnReach, (String)billingPlan, (int)subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse addedPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedPolicyDTO = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        ApiResponse returnedPolicy = this.restAPIAdmin.getSubscriptionThrottlingPolicy(policyId);
        Assert.assertNotNull((Object)returnedPolicy);
        this.subscriptionThrottlePolicyDTO.setPolicyId(policyId);
        String backendEndPoint = this.getBackendEndServiceEndPointHttp("jaxrs_basic/services/customers/customerservice");
        APIRequest apiRequest = new APIRequest("APIForTestingUpdateAfterTierDelete", "/updateAfterTierDelete", new URL(backendEndPoint));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Bronze," + displayName);
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)201, (String)("Create API Response Code is invalid." + this.apiId));
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        HttpResponse response = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)("API publish Response code is invalid " + this.apiId));
        APIDTO apiDtoFromStore = this.restAPIStore.getAPI(this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDtoFromStore.getId()), (String)("Api with API ID " + this.apiId + " is not visible in API Store"));
        List tiersDTOList = apiDtoFromStore.getTiers();
        Assert.assertNotNull((Object)tiersDTOList);
        ArrayList<String> tierNameList = new ArrayList<String>();
        for (APITiersDTO tiersDTO : tiersDTOList) {
            tierNameList.add(tiersDTO.getTierName());
        }
        Assert.assertTrue((boolean)tierNameList.contains(displayName), (String)("API with API ID " + this.apiId + " does not contain the new tier " + displayName));
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO.getPolicyId());
        HttpResponse retrievedAPI = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(retrievedAPI.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getId()), (String)"Error updating API after attached tier deletion");
        APIDTO apiDtoFromStore2 = this.restAPIStore.getAPI(this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDtoFromStore2.getId()), (String)("Api with API ID " + this.apiId + " is not visible in API Store"));
        List tiersDTOList2 = apiDtoFromStore2.getTiers();
        Assert.assertNotNull((Object)tiersDTOList2);
        ArrayList<String> tierNameList2 = new ArrayList<String>();
        for (APITiersDTO tiersDTO : tiersDTOList2) {
            tierNameList2.add(tiersDTO.getTierName());
        }
        Assert.assertFalse((boolean)tierNameList2.contains(displayName), (String)("API with API ID " + this.apiId + " contains the already deleted tier " + displayName));
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

