/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class GetLinterCustomRulesThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(GetLinterCustomRulesThroughThePublisherRestAPITestCase.class);
    private JSONObject tenantConfig;
    JSONParser jsonParser = new JSONParser();
    String linterCustomRulesKey = "LinterCustomRules";

    @Factory(dataProvider="userModeDataProvider")
    public GetLinterCustomRulesThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String tenantConfContent = FileUtils.readFileToString((File)new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "linterCustomRulesTest" + File.separator + "tenant-conf.json"), (String)"UTF-8");
        this.tenantConfig = (JSONObject)this.jsonParser.parse(tenantConfContent);
        this.restAPIAdmin.updateTenantConfig((Object)this.tenantConfig);
    }

    @Test(description="Test get linter rules through publisher REST API")
    public void testGetLinterCustomRulesThroughThePublisherRestAPI() throws Exception {
        String linterCustomRulesActual = this.restAPIPublisher.getLinterCustomRules();
        String linterCustomRulesExpected = this.tenantConfig.get((Object)this.linterCustomRulesKey).toString();
        Assert.assertEquals((String)linterCustomRulesActual, (String)linterCustomRulesExpected);
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        super.cleanUp();
    }
}

