/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi;

import java.io.File;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIBusinessInformationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIServiceInfoDTO;
import org.wso2.am.integration.clients.service.catalog.api.ApiException;
import org.wso2.am.integration.clients.service.catalog.api.ApiResponse;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceInfoDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceInfoListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ServiceCatalogRestAPITestCase
extends APIMIntegrationBaseTest {
    private File definitionFileSampleOne;
    private String serviceIdOne = "";
    private String serviceIdTwo = "";
    private String importedServiceId = "";
    private final String invalidServiceId = "01234567-0123-0123-0123";
    private final String emptyServiceId;
    private String apiId = "";

    @Factory(dataProvider="userModeDataProvider")
    public ServiceCatalogRestAPITestCase(TestUserMode userMode) {
        this.emptyServiceId = null;
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Create a Service through the Service Catalog Rest API")
    public void testCreateAService() throws Exception {
        ServiceDTO serviceMetadataSampleOne = new ServiceDTO();
        serviceMetadataSampleOne.setName("Pizzashack-Endpoint");
        serviceMetadataSampleOne.setDescription("A Catalog Entry that exposes a Pizza REST endpoint");
        serviceMetadataSampleOne.setVersion("v1");
        serviceMetadataSampleOne.serviceKey("Pizzashack-Endpoint-1.0.0");
        serviceMetadataSampleOne.serviceUrl("http://localhost/pizzashack");
        serviceMetadataSampleOne.definitionType(ServiceDTO.DefinitionTypeEnum.OAS3);
        serviceMetadataSampleOne.setSecurityType(ServiceDTO.SecurityTypeEnum.BASIC);
        serviceMetadataSampleOne.setMutualSSLEnabled(Boolean.valueOf(false));
        serviceMetadataSampleOne.setDefinitionUrl("https://petstore.swagger.io/v2/swagger.json");
        String filePath = TestConfigurationProvider.getResourceLocation() + File.separator + "service-catalog" + File.separator + "definition1.yaml";
        this.definitionFileSampleOne = new File(filePath);
        ServiceDTO createServiceResOne = this.restAPIServiceCatalog.createService(serviceMetadataSampleOne, this.definitionFileSampleOne, null);
        this.serviceIdOne = this.validateCreateServiceRes(createServiceResOne, "Pizzashack-Endpoint", "v1", "Pizzashack-Endpoint-1.0.0");
        ServiceDTO serviceMetadataSampleTwo = new ServiceDTO();
        serviceMetadataSampleTwo.setName("Petstore-Endpoint-1");
        serviceMetadataSampleTwo.setDescription("This is a sample server Petstore server");
        serviceMetadataSampleTwo.setVersion("1.0.0");
        serviceMetadataSampleTwo.serviceKey("Petstore-Endpoint-1");
        serviceMetadataSampleTwo.serviceUrl("https://localhost/api/am/service/catalog/services");
        serviceMetadataSampleTwo.definitionType(ServiceDTO.DefinitionTypeEnum.OAS3);
        serviceMetadataSampleTwo.setSecurityType(ServiceDTO.SecurityTypeEnum.BASIC);
        serviceMetadataSampleTwo.setMutualSSLEnabled(Boolean.valueOf(false));
        String filePath1 = TestConfigurationProvider.getResourceLocation() + File.separator + "service-catalog" + File.separator + "definition2.yaml";
        File definitionFileSampleTwo = new File(filePath1);
        try {
            this.restAPIServiceCatalog.createService(serviceMetadataSampleTwo, null, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
        ServiceDTO createServiceResTwo = this.restAPIServiceCatalog.createService(serviceMetadataSampleTwo, definitionFileSampleTwo, null);
        this.serviceIdTwo = this.validateCreateServiceRes(createServiceResTwo, "Petstore-Endpoint-1", "1.0.0", "Petstore-Endpoint-1");
        try {
            this.restAPIServiceCatalog.createService(null, this.definitionFileSampleOne, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((String)"Missing the required parameter 'serviceMetadata' when calling addService(Async)", (String)e.getMessage());
        }
        try {
            this.restAPIServiceCatalog.createService(serviceMetadataSampleOne, this.definitionFileSampleOne, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)409, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Get Service by UUID through the Service Catalog Rest API", dependsOnMethods={"testCreateAService"})
    public void testGetServiceByUUID() throws Exception {
        if (!this.serviceIdOne.equals("")) {
            ServiceDTO getServiceByIDRes = this.restAPIServiceCatalog.retrieveServiceById(this.serviceIdOne);
            Assert.assertNotNull((Object)getServiceByIDRes);
            Assert.assertEquals((String)getServiceByIDRes.getName(), (String)"Pizzashack-Endpoint");
            Assert.assertEquals((String)getServiceByIDRes.getVersion(), (String)"v1");
        }
        try {
            this.restAPIServiceCatalog.retrieveServiceById("01234567-0123-0123-0123");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
        try {
            this.restAPIServiceCatalog.retrieveServiceById(this.emptyServiceId);
        }
        catch (ApiException e) {
            Assert.assertEquals((String)"Missing the required parameter 'serviceId' when calling getServiceById(Async)", (String)e.getMessage());
        }
    }

    @Test(groups={"wso2.am"}, description="Search Services through the Service Catalog Rest API", dependsOnMethods={"testGetServiceByUUID"})
    public void testSearchService() throws Exception {
        ServiceListDTO getServiceByNameRes = this.restAPIServiceCatalog.retrieveServices("Pizzashack-Endpoint", null, null, null, null, null, null, Integer.valueOf(25), Integer.valueOf(0));
        this.validateSearchRes(getServiceByNameRes, "name", "Pizzashack-Endpoint");
        ServiceListDTO getServiceByVersionRes = this.restAPIServiceCatalog.retrieveServices(null, "v1", null, null, null, null, null, Integer.valueOf(25), Integer.valueOf(0));
        this.validateSearchRes(getServiceByVersionRes, "version", "v1");
        ServiceListDTO getServiceByDefTypeRes = this.restAPIServiceCatalog.retrieveServices(null, null, "OAS3", null, null, null, null, Integer.valueOf(25), Integer.valueOf(0));
        this.validateSearchRes(getServiceByDefTypeRes, "definitionType", ServiceDTO.DefinitionTypeEnum.OAS3.getValue());
        ServiceListDTO getServiceByKeyRes = this.restAPIServiceCatalog.retrieveServices(null, null, null, "Pizzashack-Endpoint-1.0.0", null, null, null, Integer.valueOf(25), Integer.valueOf(0));
        this.validateSearchRes(getServiceByKeyRes, "serviceKey", "Pizzashack-Endpoint-1.0.0");
        ServiceListDTO getServiceAscOrderRes = this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "name", "asc", Integer.valueOf(25), Integer.valueOf(0));
        this.validateSortedListRes(getServiceAscOrderRes, "Petstore-Endpoint-1", "Pizzashack-Endpoint");
        ServiceListDTO getServiceDescOrderRes = this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "name", "desc", Integer.valueOf(25), Integer.valueOf(0));
        this.validateSortedListRes(getServiceDescOrderRes, "Pizzashack-Endpoint", "Petstore-Endpoint-1");
        ServiceListDTO getServiceByLimitRes = this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "name", null, Integer.valueOf(1), Integer.valueOf(0));
        this.validateLimitAndOffsetRes(getServiceByLimitRes, 1, "Petstore-Endpoint-1");
        ServiceListDTO getServiceByOffsetRes = this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "name", null, Integer.valueOf(1), Integer.valueOf(1));
        this.validateLimitAndOffsetRes(getServiceByOffsetRes, 1, "Pizzashack-Endpoint");
        try {
            this.restAPIServiceCatalog.retrieveServices(null, null, "OS3", null, null, null, null, Integer.valueOf(25), Integer.valueOf(0));
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
        try {
            this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "defType", "asc", Integer.valueOf(25), Integer.valueOf(0));
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
        try {
            this.restAPIServiceCatalog.retrieveServices(null, null, null, null, null, "name", "acs", Integer.valueOf(25), Integer.valueOf(0));
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Get Service Definition by UUID through the Service Catalog Rest API", dependsOnMethods={"testSearchService"})
    public void testGetServiceDefinition() throws Exception {
        if (!this.serviceIdOne.equals("")) {
            String serviceDefinitionRes = this.restAPIServiceCatalog.retrieveServiceDefinition(this.serviceIdOne);
            Assert.assertNotNull((Object)serviceDefinitionRes);
        }
        try {
            this.restAPIServiceCatalog.retrieveServiceDefinition("01234567-0123-0123-0123");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Update Service through the Service Catalog Rest API", dependsOnMethods={"testGetServiceDefinition"})
    public void testUpdateService() throws Exception {
        ServiceDTO serviceMetadataSampleThree = new ServiceDTO();
        serviceMetadataSampleThree.setName("Pizzashack-Endpoint");
        serviceMetadataSampleThree.setDescription("Updated Catalog Entry that exposes a Pizza REST endpoint");
        serviceMetadataSampleThree.setVersion("v1");
        serviceMetadataSampleThree.serviceKey("Pizzashack-Endpoint-1.0.0");
        serviceMetadataSampleThree.serviceUrl("http://localhost/pizzashack");
        serviceMetadataSampleThree.definitionType(ServiceDTO.DefinitionTypeEnum.OAS3);
        serviceMetadataSampleThree.setSecurityType(ServiceDTO.SecurityTypeEnum.BASIC);
        serviceMetadataSampleThree.setMutualSSLEnabled(Boolean.valueOf(false));
        serviceMetadataSampleThree.setDefinitionUrl("https://petstore.swagger.io/v2/swagger.json");
        if (!this.serviceIdOne.equals("")) {
            ServiceDTO updateServiceRes = this.restAPIServiceCatalog.updateService(this.serviceIdOne, serviceMetadataSampleThree, this.definitionFileSampleOne, null);
            Assert.assertNotNull((Object)updateServiceRes);
            Assert.assertEquals((String)updateServiceRes.getId(), (String)this.serviceIdOne);
            Assert.assertEquals((String)updateServiceRes.getName(), (String)"Pizzashack-Endpoint");
            Assert.assertEquals((String)updateServiceRes.getVersion(), (String)"v1");
            Assert.assertEquals((String)updateServiceRes.getServiceKey(), (String)"Pizzashack-Endpoint-1.0.0");
            Assert.assertEquals((String)updateServiceRes.getDescription(), (String)"Updated Catalog Entry that exposes a Pizza REST endpoint");
        }
        try {
            this.restAPIServiceCatalog.updateService("01234567-0123-0123-0123", serviceMetadataSampleThree, this.definitionFileSampleOne, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
        try {
            this.restAPIServiceCatalog.updateService(this.serviceIdOne, serviceMetadataSampleThree, null, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
        try {
            this.restAPIServiceCatalog.updateService(this.serviceIdOne, null, this.definitionFileSampleOne, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((String)"Missing the required parameter 'serviceMetadata' when calling updateService(Async)", (String)e.getMessage());
        }
    }

    @Test(groups={"wso2.am"}, description="Import Service through the Service Catalog Rest API", dependsOnMethods={"testUpdateService"})
    public void testImportService() throws Exception {
        String zipFilePathOne = TestConfigurationProvider.getResourceLocation() + File.separator + "service-catalog" + File.separator + "service1.zip";
        File servicesFileOne = new File(zipFilePathOne);
        ServiceInfoListDTO importServiceInfoListRes = this.restAPIServiceCatalog.importService(servicesFileOne, Boolean.valueOf(true), null);
        Assert.assertNotNull((Object)importServiceInfoListRes);
        Assert.assertNotNull((Object)importServiceInfoListRes.getList());
        Assert.assertNotNull((Object)((ServiceInfoDTO)importServiceInfoListRes.getList().get(0)).getName());
        Assert.assertEquals((String)((ServiceInfoDTO)importServiceInfoListRes.getList().get(0)).getName(), (String)"Pizzashack-Endpoint-v2");
        this.importedServiceId = ((ServiceInfoDTO)importServiceInfoListRes.getList().get(0)).getId();
        try {
            this.restAPIServiceCatalog.importService(null, Boolean.valueOf(true), null);
        }
        catch (ApiException e) {
            Assert.assertEquals((String)"Missing the required parameter 'file' when calling importService(Async)", (String)e.getMessage());
        }
        String zipFilePathTwo = TestConfigurationProvider.getResourceLocation() + File.separator + "service-catalog" + File.separator + "service2.zip";
        File servicesFileTwo = new File(zipFilePathTwo);
        try {
            this.restAPIServiceCatalog.importService(servicesFileTwo, Boolean.valueOf(false), null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)400, (int)e.getCode());
        }
        ServiceInfoListDTO importServiceOverwriteRes = this.restAPIServiceCatalog.importService(servicesFileTwo, Boolean.valueOf(true), null);
        Assert.assertNotNull((Object)importServiceOverwriteRes);
        Assert.assertNotNull((Object)importServiceOverwriteRes.getList());
        Assert.assertEquals((String)((ServiceInfoDTO)importServiceOverwriteRes.getList().get(0)).getName(), (String)"Pizzashack-Endpoint");
        Assert.assertEquals((String)((ServiceInfoDTO)importServiceOverwriteRes.getList().get(0)).getKey(), (String)"Pizzashack-Endpoint-1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Export Service through the Service Catalog Rest API", dependsOnMethods={"testImportService"})
    public void testExportService() throws Exception {
        File exportServiceRes = this.restAPIServiceCatalog.exportService("Pizzashack-Endpoint", "v1");
        Assert.assertNotNull((Object)exportServiceRes);
        try {
            this.restAPIServiceCatalog.exportService("Pizzashack", "v1");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API", dependsOnMethods={"testExportService"})
    public void testCreateAnAPIThroughPublisher() throws Exception {
        APIDTO apiCreationDTO = new APIDTO();
        apiCreationDTO.setName("PizzaShackAPI");
        apiCreationDTO.setDescription("This is a simple API for Pizza Shack online pizza delivery store.");
        apiCreationDTO.setContext("pizza");
        apiCreationDTO.setVersion("1.0.0");
        apiCreationDTO.setProvider("admin");
        apiCreationDTO.setLifeCycleStatus("CREATED");
        apiCreationDTO.setType(APIDTO.TypeEnum.HTTP);
        apiCreationDTO.setAudience(APIDTO.AudienceEnum.PUBLIC);
        apiCreationDTO.setIsDefaultVersion(Boolean.valueOf(false));
        apiCreationDTO.setAccessControl(APIDTO.AccessControlEnum.NONE);
        APIBusinessInformationDTO apiBusinessInformationDTO = new APIBusinessInformationDTO();
        apiBusinessInformationDTO.setBusinessOwner("businessowner");
        apiBusinessInformationDTO.setBusinessOwnerEmail("businessowner@wso2.com");
        apiBusinessInformationDTO.setTechnicalOwner("technicalowner");
        apiBusinessInformationDTO.setTechnicalOwnerEmail("technicalowner@wso2.com");
        apiCreationDTO.setBusinessInformation(apiBusinessInformationDTO);
        APIServiceInfoDTO apiServiceInfoDTO = new APIServiceInfoDTO();
        apiServiceInfoDTO.setKey("Pizzashack-Endpoint-1.0.0");
        apiServiceInfoDTO.setName("Pizzashack-Endpoint");
        apiServiceInfoDTO.setVersion("v1");
        apiServiceInfoDTO.setOutdated(Boolean.valueOf(false));
        apiCreationDTO.setServiceInfo(apiServiceInfoDTO);
        APIDTO apidto = this.restAPIPublisher.addAPI(apiCreationDTO, "v3");
        Assert.assertNotNull((Object)apidto);
        Assert.assertNotNull((Object)apidto.getServiceInfo());
        Assert.assertEquals((String)apidto.getServiceInfo().getName(), (String)"Pizzashack-Endpoint");
        Assert.assertEquals((String)apidto.getServiceInfo().getKey(), (String)"Pizzashack-Endpoint-1.0.0");
        this.apiId = apidto.getId();
    }

    @Test(groups={"wso2.am"}, description="Get Service Usage by UUID through the Service Catalog Rest API", dependsOnMethods={"testCreateAnAPIThroughPublisher"})
    public void testGetServiceUsage() throws Exception {
        if (!this.serviceIdOne.equals("")) {
            APIListDTO serviceUsageRes = this.restAPIServiceCatalog.retrieveServiceUsage(this.serviceIdOne);
            Assert.assertNotNull((Object)serviceUsageRes);
            Assert.assertNotNull((Object)serviceUsageRes.getList());
            Assert.assertEquals((int)serviceUsageRes.getList().size(), (int)1);
            Assert.assertEquals((String)((APIInfoDTO)serviceUsageRes.getList().get(0)).getName(), (String)"PizzaShackAPI");
        }
        try {
            this.restAPIServiceCatalog.retrieveServiceUsage("01234567-0123-0123-0123");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Delete Service through the Service Catalog Rest API", dependsOnMethods={"testGetServiceUsage"})
    public void testDeleteService() throws Exception {
        if (!this.serviceIdOne.equals("")) {
            try {
                this.restAPIServiceCatalog.deleteService(this.serviceIdOne);
            }
            catch (ApiException e) {
                Assert.assertEquals((int)409, (int)e.getCode());
            }
        }
        if (!this.serviceIdTwo.equals("")) {
            ApiResponse deleteServiceRes = this.restAPIServiceCatalog.deleteService(this.serviceIdTwo);
            Assert.assertEquals((int)204, (int)deleteServiceRes.getStatusCode());
        }
        try {
            this.restAPIServiceCatalog.deleteService("01234567-0123-0123-0123");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIServiceCatalog.deleteService(this.serviceIdOne);
        this.restAPIServiceCatalog.deleteService(this.importedServiceId);
        super.cleanUp();
    }

    private String validateCreateServiceRes(ServiceDTO createServiceRes, String name, String version, String serviceKey) {
        Assert.assertNotNull((Object)createServiceRes);
        Assert.assertEquals((String)createServiceRes.getName(), (String)name);
        Assert.assertEquals((String)createServiceRes.getVersion(), (String)version);
        Assert.assertEquals((String)createServiceRes.getServiceKey(), (String)serviceKey);
        Assert.assertNotNull((Object)createServiceRes.getId());
        return createServiceRes.getId();
    }

    private void validateSearchRes(ServiceListDTO searchServiceRes, String type, String value) {
        Assert.assertNotNull((Object)searchServiceRes);
        Assert.assertNotNull((Object)searchServiceRes.getList());
        Assert.assertNotNull(searchServiceRes.getList().get(0));
        switch (type) {
            case "name": {
                Assert.assertEquals((String)((ServiceDTO)searchServiceRes.getList().get(0)).getName(), (String)value);
                break;
            }
            case "version": {
                Assert.assertEquals((String)((ServiceDTO)searchServiceRes.getList().get(0)).getVersion(), (String)value);
                break;
            }
            case "serviceKey": {
                Assert.assertEquals((String)((ServiceDTO)searchServiceRes.getList().get(0)).getServiceKey(), (String)value);
                break;
            }
            case "definitionType": {
                Assert.assertEquals((String)((ServiceDTO)searchServiceRes.getList().get(0)).getDefinitionType().getValue(), (String)value);
            }
        }
    }

    private void validateSortedListRes(ServiceListDTO searchServiceOrderRes, String firstName, String secondName) {
        Assert.assertNotNull((Object)searchServiceOrderRes);
        Assert.assertNotNull((Object)searchServiceOrderRes.getList());
        Assert.assertNotNull(searchServiceOrderRes.getList().get(0));
        Assert.assertEquals((String)((ServiceDTO)searchServiceOrderRes.getList().get(0)).getName(), (String)firstName);
        Assert.assertNotNull(searchServiceOrderRes.getList().get(1));
        Assert.assertEquals((String)((ServiceDTO)searchServiceOrderRes.getList().get(1)).getName(), (String)secondName);
    }

    private void validateLimitAndOffsetRes(ServiceListDTO searchServiceRes, int size, String name) {
        Assert.assertNotNull((Object)searchServiceRes);
        Assert.assertNotNull((Object)searchServiceRes.getList());
        Assert.assertEquals((int)searchServiceRes.getList().size(), (int)size);
        Assert.assertNotNull(searchServiceRes.getList().get(0));
        Assert.assertEquals((String)((ServiceDTO)searchServiceRes.getList().get(0)).getName(), (String)name);
    }
}

