/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.RoleAliasDTO;
import org.wso2.am.integration.clients.admin.api.dto.RoleAliasListDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.tests.other.APIDenyPolicyTestCase;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APISystemScopesTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIDenyPolicyTestCase.class);
    private AdminApiTestHelper adminApiTestHelper;
    private RoleAliasListDTO roleList;

    @Factory(dataProvider="userModeDataProvider")
    public APISystemScopesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add scope mapping")
    public void testAddScopeMapping() throws ApiException {
        this.roleList = new RoleAliasListDTO();
        RoleAliasDTO roleAliasDTO = new RoleAliasDTO();
        ArrayList<String> roleAliasList = new ArrayList<String>();
        String role = "admin";
        String alias = "testRole";
        int count = 1;
        roleAliasDTO.setRole(role);
        roleAliasList.add(alias);
        roleAliasDTO.setAliases(roleAliasList);
        this.roleList.setCount(Integer.valueOf(count));
        this.roleList.setList(Arrays.asList(roleAliasDTO));
        ApiResponse response = this.restAPIAdmin.putRoleAliases(this.roleList);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyRoleAliasListDTO((RoleAliasListDTO)response.getData(), this.roleList);
    }

    @Test(groups={"wso2.am"}, description="Test get scope mapping", dependsOnMethods={"testAddScopeMapping"})
    public void testGetScopeMapping() throws ApiException {
        ApiResponse response = this.restAPIAdmin.getRoleAliases();
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyRoleAliasListDTO((RoleAliasListDTO)response.getData(), this.roleList);
    }

    @Test(groups={"wso2.am"}, description="Test delete scope mapping", dependsOnMethods={"testGetScopeMapping"})
    public void testDeleteRoleAliasMapping() throws ApiException {
        List deletedRoleAliasMapping = this.roleList.getList().stream().filter(item -> !item.getAliases().contains("testRole")).collect(Collectors.toList());
        RoleAliasListDTO updatedRoleAliasListDTO = new RoleAliasListDTO();
        updatedRoleAliasListDTO.setList(deletedRoleAliasMapping);
        updatedRoleAliasListDTO.setCount(Integer.valueOf(0));
        ApiResponse response = this.restAPIAdmin.putRoleAliases(updatedRoleAliasListDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyRoleAliasListDTO((RoleAliasListDTO)response.getData(), updatedRoleAliasListDTO);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

