/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ConditionalGroupDTO;
import org.wso2.am.integration.clients.admin.api.dto.HeaderConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.IPConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.JWTClaimsConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.QueryParameterConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class AdvancedThrottlingPolicyTestCase
extends APIMIntegrationBaseTest {
    private String displayName = "Test Policy";
    private String description = "This is a test advanced throttle policy";
    private String timeUnit = "min";
    private String timeUnitHour = "hour";
    private Integer unitTime = 1;
    private AdvancedThrottlePolicyDTO requestCountPolicyDTO;
    private AdvancedThrottlePolicyDTO requestCountPolicyDTO1;
    private AdvancedThrottlePolicyDTO bandwidthPolicyDTO;
    private AdvancedThrottlePolicyDTO conditionalGroupsPolicyDTO;
    private AdminApiTestHelper adminApiTestHelper;
    private final String ADMIN_ROLE = "admin";
    private final String ADMIN1_USERNAME = "admin1";
    private final String ADMIN2_USERNAME = "admin2";
    private final String PASSWORD = "admin1";
    private String apiId1;
    private String apiId2;
    private String applicationId1;
    private String applicationId2;
    private ApplicationKeyDTO applicationKeyDTO;
    private final String API_END_POINT_METHOD = "/customers/123";
    private String apiEndPointUrl;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";

    @Factory(dataProvider="userModeDataProvider")
    public AdvancedThrottlingPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.userManagementClient.addUser("admin1", "admin1", new String[]{"admin"}, "admin1");
        this.userManagementClient.addUser("admin2", "admin1", new String[]{"admin"}, "admin2");
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with request count limit")
    public void testAddPolicyWithRequestCountLimit() throws Exception {
        String policyName = "TestPolicyOne";
        Long requestCount = 50L;
        ArrayList conditionalGroups = new ArrayList();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        this.requestCountPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with bandwidth limit", dependsOnMethods={"testAddPolicyWithRequestCountLimit"})
    public void testAddPolicyWithBandwidthLimit() throws Exception {
        String policyName = "TestPolicyTwo_WithUnderscore";
        Long dataAmount = 2L;
        String dataUnit = "KB";
        ArrayList conditionalGroups = new ArrayList();
        BandwidthLimitDTO bandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)dataAmount, (String)dataUnit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)bandwidthLimit);
        this.bandwidthPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.bandwidthPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.bandwidthPolicyDTO.setPolicyId(policyId);
        this.bandwidthPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.bandwidthPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with conditional groups", dependsOnMethods={"testAddPolicyWithBandwidthLimit"})
    public void testAddPolicyWithConditionalGroups() throws Exception {
        String policyName = "TestPolicyThree";
        Long requestCount = 50L;
        ArrayList<ConditionalGroupDTO> conditionalGroups = new ArrayList<ConditionalGroupDTO>();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        conditionalGroups.add(this.createConditionalGroup(defaultLimit));
        this.conditionalGroupsPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.conditionalGroupsPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.conditionalGroupsPolicyDTO.setPolicyId(policyId);
        this.conditionalGroupsPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.conditionalGroupsPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test get and update advanced throttling policy", dependsOnMethods={"testAddPolicyWithConditionalGroups"})
    public void testGetAndUpdatePolicy() throws Exception {
        String policyId = this.requestCountPolicyDTO.getPolicyId();
        ApiResponse retrievedPolicy = this.restAPIAdmin.getAdvancedThrottlingPolicy(policyId);
        AdvancedThrottlePolicyDTO retrievedPolicyDTO = (AdvancedThrottlePolicyDTO)retrievedPolicy.getData();
        Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, retrievedPolicyDTO);
        String updatedDescription = "This is a updated test advanced throttle policy";
        this.requestCountPolicyDTO.setDescription(updatedDescription);
        ApiResponse updatedPolicy = this.restAPIAdmin.updateAdvancedThrottlingPolicy(policyId, this.requestCountPolicyDTO);
        AdvancedThrottlePolicyDTO updatedPolicyDTO = (AdvancedThrottlePolicyDTO)updatedPolicy.getData();
        Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, updatedPolicyDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test delete already assigned advanced throttling policy", dependsOnMethods={"testGetAndUpdatePolicy"})
    public void testDeletePolicyAlreadyExisting() throws Exception {
        APIRequest apiRequest = new APIRequest("AdvancedThrottlingPolicyTest", "AdvancedThrottlingPolicy", new URL(this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/"));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVersion("1.0.0");
        HttpResponse addResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiID = addResponse.getData();
        apiRequest.setApiTier(this.requestCountPolicyDTO.getPolicyName());
        this.restAPIPublisher.updateAPI(apiRequest, apiID);
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.requestCountPolicyDTO.getPolicyId());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)403, (String)("Advanced throttling policy " + this.requestCountPolicyDTO.getPolicyName() + ": " + this.requestCountPolicyDTO.getPolicyId() + " deleted even it is already assigned to an API."));
            Assert.assertTrue((boolean)e.getResponseBody().contains("Cannot delete the advanced policy with the name " + this.requestCountPolicyDTO.getPolicyName() + " because it is already assigned to an API/Resource"));
        }
        finally {
            if (apiID != null) {
                this.restAPIPublisher.deleteAPI(apiID);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy", dependsOnMethods={"testDeletePolicyAlreadyExisting"})
    public void testDeletePolicy() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.requestCountPolicyDTO.getPolicyId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with existing policy name", dependsOnMethods={"testDeletePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addAdvancedThrottlingPolicy(this.bandwidthPolicyDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy with non existing policy ID", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicyWithNonExistingPolicyId() {
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    @Test(groups={"wso2.am"}, description="Test change throttling policy from Operation level to API level ", dependsOnMethods={"testDeletePolicyWithNonExistingPolicyId"})
    public void testChangePolicyOperationLevelToAPILevel() throws Exception {
        this.requestCountPolicyDTO1 = this.createThrottlingPolicy("NewThrottlingPolicy");
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO1);
        APIRequest apiRequest = new APIRequest("AdvancedThrottlingPolicyTestAPI5", "AdvancedThrottlingPolicyTestAPI5", new URL(this.apiEndPointUrl));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVersion("1.0.0");
        HttpResponse addResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId2 = addResponse.getData();
        apiRequest.setApiTier(this.requestCountPolicyDTO1.getPolicyName());
        this.restAPIPublisher.updateAPI(apiRequest, this.apiId2);
        this.createAPIRevisionAndDeployUsingRest(this.apiId2, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId2, false);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        String retrievedSwagger = this.restAPIPublisher.getSwaggerByID(this.apiId2);
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult swaggerParseResult = parser.readContents(retrievedSwagger, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        Assert.assertEquals(openAPI.getExtensions().get("x-throttling-tier"), (Object)this.requestCountPolicyDTO1.getPolicyName());
        HttpResponse applicationResponse = this.restAPIStore.createApplication("TestApplication2", "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId2 = applicationResponse.getData();
        this.restAPIStore.createSubscription(this.apiId2, this.applicationId2, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId2, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found. return token: ", (String)accessToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        this.verifyThrottling("AdvancedThrottlingPolicyTestAPI5", requestHeaders);
    }

    @Test(groups={"wso2.am"}, description="Test change throttling policy from API level to Operation level ", dependsOnMethods={"testChangePolicyOperationLevelToAPILevel"})
    public void testChangePolicyAPILevelToOperationLevel() throws Exception {
        APIRequest apiRequest = new APIRequest("AdvancedThrottlingPolicyTestAPI4", "AdvancedThrottlingPolicyTestAPI4", new URL(this.apiEndPointUrl));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVersion("1.0.0");
        apiRequest.setApiTier(this.requestCountPolicyDTO1.getPolicyName());
        HttpResponse addResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId1 = addResponse.getData();
        APIDTO apidto = this.restAPIPublisher.getAPIByID(this.apiId1);
        Assert.assertEquals((String)apidto.getApiThrottlingPolicy(), (String)this.requestCountPolicyDTO1.getPolicyName());
        List operationsDTOS = apidto.getOperations();
        for (APIOperationsDTO operationsDTO : operationsDTOS) {
            operationsDTO.setThrottlingPolicy(this.requestCountPolicyDTO1.getPolicyName());
        }
        apiRequest.setOperationsDTOS(operationsDTOS);
        this.restAPIPublisher.updateAPI(apiRequest, this.apiId1);
        this.createAPIRevisionAndDeployUsingRest(this.apiId1, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId1, false);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        String retrievedSwagger = this.restAPIPublisher.getSwaggerByID(this.apiId1);
        List<Object> resourceThrottlingTiers = this.getResourceThrottlingPolicies(retrievedSwagger);
        Assert.assertEquals((Object)resourceThrottlingTiers.get(0), (Object)this.requestCountPolicyDTO1.getPolicyName());
        HttpResponse applicationResponse = this.restAPIStore.createApplication("TestApplication1", "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId1 = applicationResponse.getData();
        this.restAPIStore.createSubscription(this.apiId1, this.applicationId1, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId1, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found. return token: ", (String)accessToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        this.verifyThrottling("AdvancedThrottlingPolicyTestAPI4", requestHeaders);
    }

    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy created with a different admin user ", dependsOnMethods={"testChangePolicyAPILevelToOperationLevel"})
    public void testDeleteAdvancedPolicyWithDifferentAdminUser() throws Exception {
        this.restAPIAdmin = new RestAPIAdminImpl("admin1", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        this.requestCountPolicyDTO = this.createThrottlingPolicy("TestPolicyAdmin1");
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
        this.restAPIAdmin = new RestAPIAdminImpl("admin2", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        ApiResponse apiResponse = this.restAPIAdmin.deleteAdvancedThrottlingPolicy(policyId);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy assigned to API created with a different admin user ", dependsOnMethods={"testDeleteAdvancedPolicyWithDifferentAdminUser"})
    public void testDeleteAssignedAPILevelAdvancedPolicyWithDifferentAdminUser() throws Exception {
        this.restAPIAdmin = new RestAPIAdminImpl("admin1", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        this.requestCountPolicyDTO = this.createThrottlingPolicy("TestPolicyAdmin2");
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
        this.restAPIPublisher = new RestAPIPublisherImpl("admin1", "admin1", this.user.getUserDomain(), this.publisherURLHttps);
        APIRequest apiRequest = new APIRequest("AdvancedThrottlingPolicyTestAPI2", "AdvancedThrottlingPolicyTestAPI2", new URL(this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/"));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVersion("1.0.0");
        HttpResponse addResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiID = addResponse.getData();
        apiRequest.setApiTier(this.requestCountPolicyDTO.getPolicyName());
        this.restAPIPublisher.updateAPI(apiRequest, apiID);
        this.restAPIAdmin = new RestAPIAdminImpl("admin2", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(policyId);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)403);
        }
        finally {
            if (apiID != null) {
                this.restAPIPublisher.deleteAPI(apiID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy assigned to a resource created with a different admin user ", dependsOnMethods={"testDeleteAssignedAPILevelAdvancedPolicyWithDifferentAdminUser"})
    public void testDeleteAssignedResourceLevelAdvancedPolicyWithDifferentAdminUser() throws Exception {
        this.restAPIAdmin = new RestAPIAdminImpl("admin1", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        this.requestCountPolicyDTO = this.createThrottlingPolicy("TestPolicyAdmin3");
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
        APIRequest apiRequest = new APIRequest("AdvancedThrottlingPolicyTestAPI3", "AdvancedThrottlingPolicyTestAPI3", new URL(this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/"));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVersion("1.0.0");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        apiOperationsDTO.setAuthType("None");
        apiOperationsDTO.setThrottlingPolicy(this.requestCountPolicyDTO.getPolicyName());
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operationsDTOS);
        HttpResponse addResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiID = addResponse.getData();
        Assert.assertNotNull((Object)apiID);
        this.restAPIAdmin = new RestAPIAdminImpl("admin2", "admin1", this.user.getUserDomain(), this.adminURLHttps);
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(policyId);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)403);
        }
        finally {
            if (apiID != null) {
                this.restAPIPublisher.deleteAPI(apiID);
            }
        }
    }

    public ConditionalGroupDTO createConditionalGroup(ThrottleLimitDTO limit) {
        String conditionalGroupDescription = "This is a test conditional group";
        List<ThrottleConditionDTO> conditions = this.createThrottlingConditions();
        return DtoFactory.createConditionalGroupDTO((String)conditionalGroupDescription, conditions, (ThrottleLimitDTO)limit);
    }

    public List<ThrottleConditionDTO> createThrottlingConditions() {
        ArrayList<ThrottleConditionDTO> throttleConditions = new ArrayList<ThrottleConditionDTO>();
        String specificIP = "10.100.1.22";
        IPConditionDTO ipConditionDTO = DtoFactory.createIPConditionDTO((IPConditionDTO.IpConditionTypeEnum)IPConditionDTO.IpConditionTypeEnum.IPSPECIFIC, (String)specificIP, null, null);
        ThrottleConditionDTO ipCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.IPCONDITION, (boolean)false, null, (IPConditionDTO)ipConditionDTO, null, null);
        throttleConditions.add(ipCondition);
        String headerName = "Host";
        String headerValue = "10.100.7.77";
        HeaderConditionDTO headerConditionDTO = DtoFactory.createHeaderConditionDTO((String)headerName, (String)headerValue);
        ThrottleConditionDTO headerCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.HEADERCONDITION, (boolean)false, (HeaderConditionDTO)headerConditionDTO, null, null, null);
        throttleConditions.add(headerCondition);
        String claimUrl = "claimUrl";
        String attribute = "claimAttribute";
        QueryParameterConditionDTO queryParameterConditionDTO = DtoFactory.createQueryParameterConditionDTO((String)claimUrl, (String)attribute);
        ThrottleConditionDTO queryParameterCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.QUERYPARAMETERCONDITION, (boolean)false, null, null, null, (QueryParameterConditionDTO)queryParameterConditionDTO);
        throttleConditions.add(queryParameterCondition);
        String parameterName = "name";
        String parameterValue = "admin";
        JWTClaimsConditionDTO jwtClaimsConditionDTO = DtoFactory.createJWTClaimsConditionDTO((String)parameterName, (String)parameterValue);
        ThrottleConditionDTO jwtClaimsCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.JWTCLAIMSCONDITION, (boolean)false, null, null, (JWTClaimsConditionDTO)jwtClaimsConditionDTO, null);
        throttleConditions.add(jwtClaimsCondition);
        return throttleConditions;
    }

    public AdvancedThrottlePolicyDTO createThrottlingPolicy(String policyName) {
        Long requestCount = 10L;
        ArrayList conditionalGroups = new ArrayList();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnitHour, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        return advancedThrottlePolicyDTO;
    }

    private void verifyThrottling(String apiContext, Map<String, String> requestHeaders) throws Exception {
        AdvancedThrottlingPolicyTestCase.waitUntilClockHour();
        boolean isThrottled = false;
        for (int invocationCount = 0; invocationCount < 20; ++invocationCount) {
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps(apiContext, "1.0.0") + "/customers/123"), requestHeaders);
            if (invokeResponse.getResponseCode() == 429) {
                Assert.assertTrue((invocationCount >= 10 ? 1 : 0) != 0);
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by Throttling Policy");
    }

    private List<Object> getResourceThrottlingPolicies(String swaggerContent) throws APIManagementException {
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult swaggerParseResult = parser.readContents(swaggerContent, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        Paths paths = openAPI.getPaths();
        ArrayList<Object> throttlingPolicies = new ArrayList<Object>();
        for (String pathKey : paths.keySet()) {
            Map operationsMap = ((PathItem)paths.get((Object)pathKey)).readOperationsMap();
            for (Map.Entry entry : operationsMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                Map extensions = operation.getExtensions();
                Assert.assertNotNull(extensions.get("x-throttling-tier"));
                throttlingPolicies.add(extensions.get("x-throttling-tier"));
            }
        }
        return throttlingPolicies;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.bandwidthPolicyDTO.getPolicyId());
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.conditionalGroupsPolicyDTO.getPolicyId());
        this.restAPIStore.deleteApplication(this.applicationId1);
        this.restAPIStore.deleteApplication(this.applicationId2);
        this.restAPIPublisher.deleteAPI(this.apiId1);
        this.restAPIPublisher.deleteAPI(this.apiId2);
    }
}

