/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.api.dto.ThrottlePolicyDetailsDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottlePolicyDetailsListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class GetThrottlingPoliciesTestCase
extends APIMIntegrationBaseTest {
    private final String APP_POLICY_NAME = "50PerMin";
    private final String SUB_POLICY_NAME = "Gold";
    private final String API_POLICY_NAME = "10KPerMin";

    @Factory(dataProvider="userModeDataProvider")
    public GetThrottlingPoliciesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Get ThrottlePolicies List and check few default policies")
    public void testThrottlePoliciesGet() throws Exception {
        ThrottlePolicyDetailsListDTO policies = this.restAPIAdmin.getThrottlePolicies("type:all");
        List policyList = policies.getList();
        Assert.assertTrue((boolean)this.containsPolicy(policyList, "50PerMin"), (String)"Doesn't contain app Policy");
        Assert.assertTrue((boolean)this.containsPolicy(policyList, "Gold"), (String)"Doesn't contain sub Policy");
        Assert.assertTrue((boolean)this.containsPolicy(policyList, "10KPerMin"), (String)"Doesn't contain api Policy");
    }

    private boolean containsPolicy(List<ThrottlePolicyDetailsDTO> list, String name) {
        return list.stream().anyMatch(o -> o.getPolicyName().equals(name));
    }
}

