/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.CustomAttributeDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class SubscriptionThrottlingPolicyTestCase
extends APIMIntegrationBaseTest {
    private String displayName = "Test Policy";
    private String description = "This is a test subscription throttle policy";
    private String timeUnit = "min";
    private Integer unitTime = 1;
    private Integer graphQLMaxComplexity = 400;
    private Integer graphQLMaxDepth = 10;
    private Integer rateLimitCount = -1;
    private String rateLimitTimeUnit = "NA";
    private boolean stopQuotaOnReach = false;
    private String billingPlan = "COMMERCIAL";
    private Integer subscriberCount = 0;
    private List<CustomAttributeDTO> customAttributes = null;
    private SubscriptionThrottlePolicyDTO requestCountPolicyDTO;
    private SubscriptionThrottlePolicyDTO bandwidthPolicyDTO;
    private SubscriptionThrottlePolicyPermissionDTO permissions;
    private AdminApiTestHelper adminApiTestHelper;
    UserManagementClient userManagementClient1 = null;
    private String CREATOR_USER = "testUserCreator";
    private String SUBSCRIBER_USER = "testUserSubscriber";
    private final String USER_PASSWORD = "123123";
    private final String INTERNAL_CREATOR = "Internal/creator";
    private final String INTERNAL_PUBLISHER = "Internal/publisher";
    private final String INTERNAL_SUBSCRIBER = "Internal/subscriber";
    private final String INTERNAL_EVERYONE = "Internal/everyone";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_NAME = "TestAPI";
    private final String API_CONTEXT = "testapi";
    private final String API_VERSION = "1.0.0";
    private String apiId;
    private String app1Id;
    private String app2Id;
    private String providerName;
    private SubscriptionThrottlePolicyDTO sampleSubscriptionThrottlePolicyDTO1;
    private SubscriptionThrottlePolicyDTO sampleSubscriptionThrottlePolicyDTO2;
    private ArrayList grantTypes;
    private List<String> roleList;

    @Factory(dataProvider="userModeDataProvider")
    public SubscriptionThrottlingPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient1.addUser(this.CREATOR_USER, "123123", new String[]{"Internal/creator", "Internal/publisher"}, this.CREATOR_USER);
        this.userManagementClient1.addUser(this.SUBSCRIBER_USER, "123123", new String[]{"Internal/subscriber"}, this.SUBSCRIBER_USER);
        this.providerName = this.user.getUserName();
        this.adminApiTestHelper = new AdminApiTestHelper();
        this.customAttributes = new ArrayList<CustomAttributeDTO>();
        CustomAttributeDTO attribute = new CustomAttributeDTO();
        attribute.setName("testAttribute");
        attribute.setValue("testValue");
        this.customAttributes.add(attribute);
        this.grantTypes = new ArrayList();
        this.grantTypes.add("client_credentials");
    }

    @Test(groups={"wso2.am"}, description="Test add subscription throttling policy with request count limit")
    public void testAddPolicyWithRequestCountLimit() throws Exception {
        String policyName = "TestPolicyOne";
        Long requestCount = 50L;
        this.roleList = new ArrayList<String>();
        this.roleList.add("Internal/creator");
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        this.permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, this.roleList);
        this.requestCountPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)this.graphQLMaxComplexity, (int)this.graphQLMaxDepth, (int)this.rateLimitCount, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)this.stopQuotaOnReach, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)this.permissions);
        ApiResponse addedPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedPolicyDTO = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifySubscriptionThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add subscription throttling policy with bandwidth limit", dependsOnMethods={"testAddPolicyWithRequestCountLimit"})
    public void testAddPolicyWithBandwidthLimit() throws Exception {
        String policyName = "TestPolicyTwo";
        Long dataAmount = 2L;
        String dataUnit = "KB";
        this.roleList = new ArrayList<String>();
        this.roleList.add("Internal/everyone");
        this.roleList.add("Internal/subscriber");
        BandwidthLimitDTO bandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)dataAmount, (String)dataUnit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)bandwidthLimit);
        this.bandwidthPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)this.graphQLMaxComplexity, (int)this.graphQLMaxDepth, (int)this.rateLimitCount, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)this.stopQuotaOnReach, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)this.permissions);
        ApiResponse addedPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.bandwidthPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedPolicyDTO = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.bandwidthPolicyDTO.setPolicyId(policyId);
        this.bandwidthPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifySubscriptionThrottlePolicyDTO(this.bandwidthPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test check whether subscription throttling policy works", dependsOnMethods={"testAddPolicyWithBandwidthLimit"})
    public void testSubscriptionLevelThrottling() throws Exception {
        String policyName1 = "SubscriptionThrottlePolicy10per1hour";
        RequestCountLimitDTO requestCountLimit1 = DtoFactory.createRequestCountLimitDTO((String)"hours", (Integer)1, (Long)10L);
        ThrottleLimitDTO defaultLimit1 = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit1, null);
        SubscriptionThrottlePolicyPermissionDTO permissions1 = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, this.roleList);
        this.sampleSubscriptionThrottlePolicyDTO1 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName1, (String)policyName1, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit1, (int)this.graphQLMaxComplexity, (int)this.graphQLMaxDepth, (int)this.rateLimitCount, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)true, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions1);
        ApiResponse addedPolicy1 = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.sampleSubscriptionThrottlePolicyDTO1);
        Assert.assertEquals((int)addedPolicy1.getStatusCode(), (int)201);
        String policyName2 = "SubscriptionThrottlePolicy20per1hour";
        RequestCountLimitDTO requestCountLimit2 = DtoFactory.createRequestCountLimitDTO((String)"hours", (Integer)1, (Long)20L);
        ThrottleLimitDTO defaultLimit2 = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit2, null);
        SubscriptionThrottlePolicyPermissionDTO permissions2 = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, this.roleList);
        this.sampleSubscriptionThrottlePolicyDTO2 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName2, (String)policyName2, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit2, (int)this.graphQLMaxComplexity, (int)this.graphQLMaxDepth, (int)this.rateLimitCount, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)true, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions2);
        ApiResponse addedPolicy2 = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.sampleSubscriptionThrottlePolicyDTO2);
        Assert.assertEquals((int)addedPolicy2.getStatusCode(), (int)201);
        APIRequest apiRequest = new APIRequest("TestAPI", "testapi", new URL(this.backEndServerUrl.getWebAppURLHttps() + "jaxrs_basic/services/customers/customerservice/"));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection(policyName1 + "," + policyName2 + "," + "Bronze" + ",TestPolicyOne");
        apiRequest.setProvider(this.providerName);
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        this.apiId = apiResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeployment();
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("App1", "Unlimited", "", "TestApp Description");
        this.app1Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.app1Id, policyName1);
        Assert.assertNotNull((Object)subscriptionDTO);
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.app1Id, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, (List)this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO);
        String accessToken1 = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders1 = new HashMap<String, String>();
        requestHeaders1.put("Authorization", "Bearer " + accessToken1);
        requestHeaders1.put("accept", "text/xml");
        requestHeaders1.put("content-type", "application/json");
        boolean isThrottled1 = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response1 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("testapi", "1.0.0") + "/customers/123"), requestHeaders1);
            if (response1.getResponseCode() == 429) {
                Assert.assertTrue((i >= 10 ? 1 : 0) != 0);
                isThrottled1 = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled1, (String)("Request not throttled by " + policyName1));
        this.restAPIStore.removeSubscription(subscriptionDTO);
        subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.app1Id, policyName2);
        Assert.assertNotNull((Object)subscriptionDTO);
        String accessToken2 = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders2 = new HashMap<String, String>();
        requestHeaders2.put("Authorization", "Bearer " + accessToken2);
        requestHeaders2.put("accept", "text/xml");
        requestHeaders2.put("content-type", "application/json");
        boolean isThrottled2 = false;
        for (int i = 0; i < 25; ++i) {
            HttpResponse response2 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("testapi", "1.0.0") + "/customers/123"), requestHeaders2);
            if (response2.getResponseCode() == 429) {
                Assert.assertTrue((i >= 20 ? 1 : 0) != 0);
                isThrottled2 = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled2, (String)("Request not throttled by " + policyName2));
        this.restAPIStore.removeSubscription(subscriptionDTO);
    }

    @Test(groups={"wso2.am"}, description="Test check whether restricted policies can be viewed", dependsOnMethods={"testSubscriptionLevelThrottling"})
    public void testCheckPolicyPermission() throws Exception {
        this.restAPIStore = new RestAPIStoreImpl(this.SUBSCRIBER_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("App2", "Unlimited", "", "Applications");
        this.app2Id = applicationDTO.getApplicationId();
        ApplicationKeyDTO appDTO = this.restAPIStore.generateKeys(this.app2Id, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, (List)this.grantTypes);
        Assert.assertNotNull((Object)appDTO);
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.app2Id, "Bronze");
        Assert.assertNotNull((Object)subscriptionDTO);
        try {
            this.restAPIStore.subscribeToAPI(this.apiId, this.app2Id, "TestPolicyOne");
        }
        catch (org.wso2.am.integration.clients.store.api.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)403);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Tier TestPolicyOne is not allowed"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test get and update subscription throttling policy", dependsOnMethods={"testCheckPolicyPermission"})
    public void testGetAndUpdatePolicy() throws Exception {
        String policyId = this.requestCountPolicyDTO.getPolicyId();
        ApiResponse retrievedPolicy = this.restAPIAdmin.getSubscriptionThrottlingPolicy(policyId);
        SubscriptionThrottlePolicyDTO retrievedPolicyDTO = (SubscriptionThrottlePolicyDTO)retrievedPolicy.getData();
        Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifySubscriptionThrottlePolicyDTO(this.requestCountPolicyDTO, retrievedPolicyDTO);
        String updatedDescription = "This is a updated test subscription throttle policy";
        this.requestCountPolicyDTO.setDescription(updatedDescription);
        ApiResponse updatedPolicy = this.restAPIAdmin.updateSubscriptionThrottlingPolicy(policyId, this.requestCountPolicyDTO);
        SubscriptionThrottlePolicyDTO updatedPolicyDTO = (SubscriptionThrottlePolicyDTO)updatedPolicy.getData();
        Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifySubscriptionThrottlePolicyDTO(this.requestCountPolicyDTO, updatedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test delete subscription throttling policy", dependsOnMethods={"testGetAndUpdatePolicy"})
    public void testDeletePolicy() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.requestCountPolicyDTO.getPolicyId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test add subscription throttling policy with existing policy name", dependsOnMethods={"testDeletePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.bandwidthPolicyDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete subscription throttling policy with non existing policy ID", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicyWithNonExistingPolicyId() {
        try {
            this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.bandwidthPolicyDTO.getPolicyId());
        this.restAPIStore.deleteApplication(this.app1Id);
        this.restAPIStore.deleteApplication(this.app2Id);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

