/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ConditionalGroupDTO;
import org.wso2.am.integration.clients.admin.api.dto.CustomAttributeDTO;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;
import org.wso2.am.integration.clients.admin.api.dto.ExportThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.MonetizationInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.tests.restapi.admin.throttlingpolicy.AdvancedThrottlingPolicyTestCase;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class ThrottlePolicyExportImportTestCase
extends APIMIntegrationBaseTest {
    private final String DISPLAY_NAME = "Test Policy";
    private final String TIME_UNIT = "min";
    private final Integer UNIT_TIME = 1;
    private final String APIM_VERSION = "v4.2.0";
    private final String DESCRIPTION = "This is a test throttle policy";
    private final String ADVANCED_POLICY_NAME = "TestPolicyAdvanced";
    private final String APPLICATION_POLICY_NAME = "TestPolicyApplication";
    private final String CUSTOM_POLICY_NAME = "TestPolicyCustom";
    private final String SUBSCRIPTION_POLICY_NAME = "TestPolicySubscription";
    private final String THROTTLE_POLICY_TYPE = "throttling policy";
    private final String ADVANCED_POLICY_SUBTYPE = "advanced policy";
    private final String APPLICATION_POLICY_SUBTYPE = "application policy";
    private final String SUBSCRIPTION_POLICY_SUBTYPE = "subscription policy";
    private final String CUSTOM_POLICY_SUBTYPE = "custom rule";
    private final String ADVANCED_POLICY_TYPE = "api";
    private final String APPLICATION_POLICY_TYPE = "app";
    private final String SUBSCRIPTION_POLICY_TYPE = "sub";
    private final String CUSTOM_POLICY_TYPE = "global";
    private AdvancedThrottlePolicyDTO AdvancedPolicyDTO;
    private ApplicationThrottlePolicyDTO ApplicationPolicyDTO;
    private CustomRuleDTO CustomPolicyDTO;
    private SubscriptionThrottlePolicyDTO SubscriptionPolicyDTO;
    private AdminApiTestHelper adminApiTestHelper;
    private String advancedPolicyId;
    private String applicationPolicyId;
    private String subscriptionPolicyId;
    private String customPolicyId;
    private File exportedFileAdvancedPolicy;
    private File exportedFileApplicationPolicy;
    private File exportedFileCustomPolicy;
    private File exportedFileSubscriptionPolicy;

    @Factory(dataProvider="userModeDataProvider")
    public ThrottlePolicyExportImportTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
        this.addAdvancedPolicy();
        this.addApplicationPolicy();
        this.addSubscriptionPolicy();
        this.addCustomPolicy();
    }

    public void addSubscriptionPolicy() throws Exception {
        String timeUnit = "min";
        Integer unitTime = 1;
        int graphQLMaxComplexity = 400;
        int graphQLMaxDepth = 10;
        int rateLimitCount = -1;
        String rateLimitTimeUnit = "NA";
        boolean stopQuotaOnReach = false;
        String billingPlan = "COMMERCIAL";
        int subscriberCount = 0;
        MonetizationInfoDTO monetization = new MonetizationInfoDTO();
        ArrayList<CustomAttributeDTO> customAttributes = new ArrayList<CustomAttributeDTO>();
        CustomAttributeDTO attribute = new CustomAttributeDTO();
        attribute.setName("testAttribute");
        attribute.setValue("testValue");
        customAttributes.add(attribute);
        Long requestCount = 50L;
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add("Internal/creator");
        monetization.setMonetizationPlan(MonetizationInfoDTO.MonetizationPlanEnum.DYNAMICRATE);
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)timeUnit, (Integer)unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        SubscriptionThrottlePolicyPermissionDTO permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, roleList);
        this.SubscriptionPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)"TestPolicySubscription", (String)"Test Policy", (String)"This is a test throttle policy", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)graphQLMaxComplexity, (int)graphQLMaxDepth, (int)rateLimitCount, (String)rateLimitTimeUnit, customAttributes, (boolean)stopQuotaOnReach, (String)billingPlan, (int)subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        this.SubscriptionPolicyDTO.setMonetization(monetization);
        ApiResponse addedPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.SubscriptionPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedPolicyDTO = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        this.subscriptionPolicyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.subscriptionPolicyId, (String)"The policy ID cannot be null or empty");
        this.SubscriptionPolicyDTO.setPolicyId(this.subscriptionPolicyId);
        this.SubscriptionPolicyDTO.setIsDeployed(Boolean.valueOf(false));
        this.SubscriptionPolicyDTO.setType("SubscriptionThrottlePolicy");
        this.adminApiTestHelper.verifySubscriptionThrottlePolicyDTO(this.SubscriptionPolicyDTO, addedPolicyDTO);
    }

    public void addAdvancedPolicy() throws Exception {
        Long requestCount = 50L;
        ArrayList<ConditionalGroupDTO> conditionalGroups = new ArrayList<ConditionalGroupDTO>();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.UNIT_TIME, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        AdvancedThrottlingPolicyTestCase advancedThrottlingPolicyTestCase = new AdvancedThrottlingPolicyTestCase(this.userMode);
        conditionalGroups.add(advancedThrottlingPolicyTestCase.createConditionalGroup(defaultLimit));
        this.AdvancedPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)"TestPolicyAdvanced", (String)"Test Policy", (String)"This is a test throttle policy", (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.AdvancedPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        this.advancedPolicyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.advancedPolicyId, (String)"The policy ID cannot be null or empty");
        this.AdvancedPolicyDTO.setPolicyId(this.advancedPolicyId);
        this.AdvancedPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.AdvancedPolicyDTO, addedPolicyDTO);
    }

    public void addApplicationPolicy() throws Exception {
        Long requestCount = 50L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.UNIT_TIME, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        this.ApplicationPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)"TestPolicyApplication", (String)"Test Policy", (String)"This is a test throttle policy", (boolean)false, (ThrottleLimitDTO)defaultLimit);
        ApiResponse addedPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(this.ApplicationPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedPolicyDTO = (ApplicationThrottlePolicyDTO)addedPolicy.getData();
        this.applicationPolicyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.applicationPolicyId, (String)"The policy ID cannot be null or empty");
        this.ApplicationPolicyDTO.setPolicyId(this.applicationPolicyId);
        this.ApplicationPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyApplicationThrottlePolicyDTO(this.ApplicationPolicyDTO, addedPolicyDTO);
    }

    public void addCustomPolicy() {
        block2: {
            String description = "This is a test custom throttle policy";
            String siddhiQuery = "FROM RequestStream\nSELECT userId, ( userId == 'admin@carbon.super' ) AS isEligible, str:concat('admin@carbon.super','') as throttleKey\nINSERT INTO EligibilityStream; \n\nFROM EligibilityStream[isEligible==true]#throttler:timeBatch(1 min) \nSELECT throttleKey, (count(userId) >= 10) as isThrottled, expiryTimeStamp group by throttleKey \nINSERT ALL EVENTS into ResultStream;";
            String keyTemplate = "$userId";
            this.CustomPolicyDTO = DtoFactory.createCustomThrottlePolicyDTO((String)"TestPolicyCustom", (String)description, (boolean)false, (String)siddhiQuery, (String)keyTemplate);
            try {
                ApiResponse addedPolicy = this.restAPIAdmin.addCustomThrottlingPolicy(this.CustomPolicyDTO);
                Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
                CustomRuleDTO addedPolicyDTO = (CustomRuleDTO)addedPolicy.getData();
                this.customPolicyId = addedPolicyDTO.getPolicyId();
                Assert.assertNotNull((Object)this.customPolicyId, (String)"The policy ID cannot be null or empty");
                this.CustomPolicyDTO.setPolicyId(this.customPolicyId);
                this.CustomPolicyDTO.setIsDeployed(Boolean.valueOf(true));
                this.adminApiTestHelper.verifyCustomThrottlePolicyDTO(this.CustomPolicyDTO, addedPolicyDTO);
            }
            catch (ApiException e) {
                if (this.userMode != TestUserMode.TENANT_ADMIN) break block2;
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Custom ThrottlePolicy")
    public void testCustomThrottlePolicyExport() throws Exception {
        if (this.userMode == TestUserMode.TENANT_ADMIN) {
            throw new SkipException("Skipping the export custom policy");
        }
        this.exportedFileCustomPolicy = this.exportArtifact("TestPolicyCustom", "global");
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(String.valueOf(this.exportedFileCustomPolicy), new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted Throttle Policy file " + this.exportedFileCustomPolicy, (Throwable)e);
        }
        String exportedThrottlePolicyContent = contentBuilder.toString();
        JSONObject exportedThrottlePolicyJson = (JSONObject)new JSONParser().parse(exportedThrottlePolicyContent);
        this.CustomPolicyDTO.setIsDeployed(Boolean.valueOf(false));
        this.CustomPolicyDTO.setType("CustomRule");
        ExportThrottlePolicyDTO customPolicyExportedDTO = DtoFactory.createExportThrottlePolicyDTO((String)"throttling policy", (String)"custom rule", (String)"v4.2.0", (Object)this.CustomPolicyDTO);
        ExportThrottlePolicyDTO expectedExportedPolicy = (ExportThrottlePolicyDTO)new Gson().fromJson(exportedThrottlePolicyJson.toJSONString(), ExportThrottlePolicyDTO.class);
        CustomRuleDTO customPolicy = (CustomRuleDTO)new ObjectMapper().convertValue(expectedExportedPolicy.getData(), CustomRuleDTO.class);
        expectedExportedPolicy.setData((Object)customPolicy);
        Assert.assertEquals((Object)expectedExportedPolicy, (Object)customPolicyExportedDTO);
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Subscription ThrottlePolicy")
    public void testSubscriptionThrottlePolicyExport() throws Exception {
        this.exportedFileSubscriptionPolicy = this.exportArtifact("TestPolicySubscription", "sub");
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(String.valueOf(this.exportedFileSubscriptionPolicy), new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted Throttle Policy file " + this.exportedFileSubscriptionPolicy, (Throwable)e);
        }
        String exportedThrottlePolicyContent = contentBuilder.toString();
        JSONObject exportedThrottlePolicyJson = (JSONObject)new JSONParser().parse(exportedThrottlePolicyContent);
        this.SubscriptionPolicyDTO.setIsDeployed(Boolean.valueOf(false));
        this.SubscriptionPolicyDTO.setType("SubscriptionThrottlePolicy");
        ExportThrottlePolicyDTO subscriptionPolicyExportedDTO = DtoFactory.createExportThrottlePolicyDTO((String)"throttling policy", (String)"subscription policy", (String)"v4.2.0", (Object)this.SubscriptionPolicyDTO);
        ExportThrottlePolicyDTO expectedExportedPolicy = (ExportThrottlePolicyDTO)new Gson().fromJson(exportedThrottlePolicyJson.toJSONString(), ExportThrottlePolicyDTO.class);
        SubscriptionThrottlePolicyDTO subPolicy = (SubscriptionThrottlePolicyDTO)new ObjectMapper().convertValue(expectedExportedPolicy.getData(), SubscriptionThrottlePolicyDTO.class);
        expectedExportedPolicy.setData((Object)subPolicy);
        Assert.assertEquals((Object)subscriptionPolicyExportedDTO, (Object)expectedExportedPolicy);
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Application ThrottlePolicy")
    public void testApplicationThrottlePolicyExport() throws Exception {
        this.exportedFileApplicationPolicy = this.exportArtifact("TestPolicyApplication", "app");
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(String.valueOf(this.exportedFileApplicationPolicy), new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted Throttle Policy file " + this.exportedFileApplicationPolicy, (Throwable)e);
        }
        String exportedThrottlePolicyContent = contentBuilder.toString();
        JSONObject exportedThrottlePolicyJson = (JSONObject)new JSONParser().parse(exportedThrottlePolicyContent);
        this.ApplicationPolicyDTO.setIsDeployed(Boolean.valueOf(false));
        this.ApplicationPolicyDTO.setType("ApplicationThrottlePolicy");
        ExportThrottlePolicyDTO applicationPolicyExportedDTO = DtoFactory.createExportThrottlePolicyDTO((String)"throttling policy", (String)"application policy", (String)"v4.2.0", (Object)this.ApplicationPolicyDTO);
        ExportThrottlePolicyDTO expectedExportedPolicy = (ExportThrottlePolicyDTO)new Gson().fromJson(exportedThrottlePolicyJson.toJSONString(), ExportThrottlePolicyDTO.class);
        ApplicationThrottlePolicyDTO appPolicy = (ApplicationThrottlePolicyDTO)new ObjectMapper().convertValue(expectedExportedPolicy.getData(), ApplicationThrottlePolicyDTO.class);
        expectedExportedPolicy.setData((Object)appPolicy);
        Assert.assertEquals((Object)applicationPolicyExportedDTO, (Object)expectedExportedPolicy);
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Advanced ThrottlePolicy")
    public void testAdvancedThrottlePolicyExport() throws Exception {
        this.exportedFileAdvancedPolicy = this.exportArtifact("TestPolicyAdvanced", "api");
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(String.valueOf(this.exportedFileAdvancedPolicy), new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted Throttle Policy file " + this.exportedFileAdvancedPolicy, (Throwable)e);
        }
        String exportedThrottlePolicyContent = contentBuilder.toString();
        JSONObject exportedThrottlePolicyJson = (JSONObject)new JSONParser().parse(exportedThrottlePolicyContent);
        this.AdvancedPolicyDTO.setIsDeployed(Boolean.valueOf(false));
        this.AdvancedPolicyDTO.setType("AdvancedThrottlePolicy");
        ExportThrottlePolicyDTO advancedPolicyExportedDTO = DtoFactory.createExportThrottlePolicyDTO((String)"throttling policy", (String)"advanced policy", (String)"v4.2.0", (Object)this.AdvancedPolicyDTO);
        ExportThrottlePolicyDTO expectedExportedPolicy = (ExportThrottlePolicyDTO)new Gson().fromJson(exportedThrottlePolicyJson.toJSONString(), ExportThrottlePolicyDTO.class);
        AdvancedThrottlePolicyDTO advancedPolicy = (AdvancedThrottlePolicyDTO)new ObjectMapper().convertValue(expectedExportedPolicy.getData(), AdvancedThrottlePolicyDTO.class);
        expectedExportedPolicy.setData((Object)advancedPolicy);
        Assert.assertEquals((Object)advancedPolicyExportedDTO, (Object)expectedExportedPolicy);
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Custom Throttle Policy without update", dependsOnMethods={"testCustomThrottlePolicyExport"})
    public void testCustomThrottlePolicyUpdateConflict() {
        try {
            ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileCustomPolicy, Boolean.valueOf(false));
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Subscription Throttle Policy without update", dependsOnMethods={"testSubscriptionThrottlePolicyExport"})
    public void testSubscriptionThrottlePolicyUpdateConflict() {
        try {
            ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileSubscriptionPolicy, Boolean.valueOf(false));
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Application Throttle Policy without update", dependsOnMethods={"testApplicationThrottlePolicyExport"})
    public void testApplicationThrottlePolicyUpdateConflict() {
        try {
            ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileApplicationPolicy, Boolean.valueOf(false));
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Advanced Throttle Policy without update", dependsOnMethods={"testAdvancedThrottlePolicyExport"})
    public void testAdvancedThrottlePolicyUpdateConflict() {
        try {
            ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileAdvancedPolicy, Boolean.valueOf(false));
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Custom Throttle Policy with update", dependsOnMethods={"testCustomThrottlePolicyExport"})
    public void testCustomThrottlePolicyUpdate() throws Exception {
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileCustomPolicy, Boolean.valueOf(true));
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Subscription Throttle Policy with update", dependsOnMethods={"testSubscriptionThrottlePolicyExport"})
    public void testSubscriptionThrottlePolicyUpdate() throws Exception {
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileSubscriptionPolicy, Boolean.valueOf(true));
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Application Throttle Policy with update", dependsOnMethods={"testApplicationThrottlePolicyExport"})
    public void testApplicationThrottlePolicyUpdate() throws Exception {
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileApplicationPolicy, Boolean.valueOf(true));
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Importing an existing Advanced Throttle Policy with update", dependsOnMethods={"testAdvancedThrottlePolicyExport"})
    public void testAdvancedThrottlePolicyUpdate() throws Exception {
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileAdvancedPolicy, Boolean.valueOf(true));
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Importing a new Custom ThrottlePolicy", dependsOnMethods={"testCustomThrottlePolicyUpdate"})
    public void testCustomThrottlePolicyNewImport() throws Exception {
        ApiResponse ApiResponse2 = this.restAPIAdmin.deleteCustomThrottlingPolicy(this.customPolicyId);
        Assert.assertEquals((int)ApiResponse2.getStatusCode(), (int)200);
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileCustomPolicy, Boolean.valueOf(false));
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
    }

    @Test(groups={"wso2.am"}, description="Importing a new Subscription ThrottlePolicy", dependsOnMethods={"testSubscriptionThrottlePolicyUpdate"})
    public void testSubscriptionThrottlePolicyNewImport() throws Exception {
        ApiResponse ApiResponse2 = this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subscriptionPolicyId);
        Assert.assertEquals((int)ApiResponse2.getStatusCode(), (int)200);
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileSubscriptionPolicy, Boolean.valueOf(false));
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
    }

    @Test(groups={"wso2.am"}, description="Importing a new Application ThrottlePolicy", dependsOnMethods={"testApplicationThrottlePolicyUpdate"})
    public void testApplicationThrottlePolicyNewImport() throws Exception {
        ApiResponse ApiResponse2 = this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.applicationPolicyId);
        Assert.assertEquals((int)ApiResponse2.getStatusCode(), (int)200);
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileApplicationPolicy, Boolean.valueOf(false));
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
    }

    @Test(groups={"wso2.am"}, description="Importing a new Advanced ThrottlePolicy", dependsOnMethods={"testAdvancedThrottlePolicyUpdate"})
    public void testAdvancedThrottlePolicyNewImport() throws Exception {
        ApiResponse ApiResponse2 = this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.advancedPolicyId);
        Assert.assertEquals((int)ApiResponse2.getStatusCode(), (int)200);
        ApiResponse response = this.restAPIAdmin.importThrottlePolicy(this.exportedFileAdvancedPolicy, Boolean.valueOf(false));
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
    }

    private File exportArtifact(String policyName, String policyType) throws IOException, ApiException {
        File TempDir = com.google.common.io.Files.createTempDir();
        String fileName = policyType + "_" + policyName;
        File newExportedFile = new File(TempDir.getAbsolutePath() + File.separator + fileName + ".json");
        ApiResponse response = this.restAPIAdmin.exportThrottlePolicy(policyName, policyType);
        ExportThrottlePolicyDTO entity = (ExportThrottlePolicyDTO)response.getData();
        new ObjectMapper().writeValue(newExportedFile, (Object)entity);
        Assert.assertEquals((int)response.getStatusCode(), (int)200, (String)"Response code is not as expected");
        Assert.assertTrue((boolean)newExportedFile.exists(), (String)"File save was not successful");
        return newExportedFile;
    }
}

