/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.schemaValidation;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class SchemaValidationTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(SchemaValidationTestCase.class);
    private RestAPIPublisherImpl restAPIPublisherExport;
    private final String ROOT_RESOURCE_PATH = "schemaValidation";
    private final String API_END_POINT_POSTFIX_URL = "schemaValidationAPI";
    private String apiContext = "schemaValidationTestAPI";
    private String invokeURL;
    private String applicationID;
    private String apiID;
    Map<String, String> requestHeaders = new HashMap<String, String>();

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String apiDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("schemaValidation" + File.separator + "schemaValidator.yml"), (String)"UTF-8");
        String additionalProperties = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("schemaValidation" + File.separator + "apiRequest.json"), (String)"UTF-8");
        JSONObject apiCreateRequestObject = new JSONObject(additionalProperties);
        apiCreateRequestObject.put("provider", (Object)this.user.getUserName());
        String apiEndPointUrl = this.getGatewayURLNhttp() + "schemaValidationAPI";
        JSONObject endpoint = new JSONObject();
        endpoint.put("url", (Object)apiEndPointUrl);
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoint);
        endpointConfig.put("sandbox_endpoints", (Object)endpoint);
        apiCreateRequestObject.put("endpointConfig", (Object)endpointConfig);
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            this.apiContext = "/t/" + this.user.getUserDomain() + this.apiContext;
        }
        apiCreateRequestObject.put("context", (Object)this.apiContext);
        apiCreateRequestObject.put("version", (Object)"1.0.0");
        File file = APIMTestCaseUtils.getTempSwaggerFileWithContent((String)apiDefinition);
        APIDTO apidto = this.restAPIPublisher.importOASDefinition(file, apiCreateRequestObject.toString());
        this.apiID = apidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiID, false);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        HttpResponse applicationResponse = this.restAPIStore.createApplication("ApplicationTesttestSchemaValidationApp", "Application to test Schema Validation", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        this.applicationID = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(this.apiID, this.applicationID, "Unlimited");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.requestHeaders.put("accept", "application/json");
        this.requestHeaders.put("Content-Type", "application/json");
        this.invokeURL = this.getAPIInvocationURLHttp(this.apiContext, "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation with invalid request body")
    public void testRequestSchemaValidationForInvalidRequestBody() throws Exception {
        JSONObject queryObject = new JSONObject();
        queryObject.put("category", (Object)"dog");
        queryObject.put("status", (Object)"available");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)(this.invokeURL + "/pets"), this.requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)400);
        Assert.assertEquals((boolean)serviceResponse.getData().contains("Schema validation failed in the Request"), (boolean)true);
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation failure for requests without required headers")
    public void testSchemaValidationForRequestsWithoutRequiredHeaders() throws Exception {
        HttpResponse serviceResponseWithoutHeader = HTTPSClientUtils.doGet((String)(this.invokeURL + "/pets"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponseWithoutHeader.getResponseCode(), (int)400);
        Assert.assertEquals((boolean)serviceResponseWithoutHeader.getData().contains("Schema validation failed in the Request"), (boolean)true);
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation success for requests with required headers")
    public void testSchemaValidationForRequestsWithRequiredHeaders() throws Exception {
        this.requestHeaders.put("x-request-id", "787878");
        HttpResponse serviceResponseWithHeader = HTTPSClientUtils.doGet((String)(this.invokeURL + "/pets"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponseWithHeader.getResponseCode(), (int)200);
        this.requestHeaders.remove("x-request-id");
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation with invalid response body")
    public void testRequestSchemaValidationForInvalidResponse() throws Exception {
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(this.invokeURL + "/pets/123"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)400);
        Assert.assertEquals((boolean)serviceResponse.getData().contains("Schema validation failed in the Response:"), (boolean)true);
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation with valid request body")
    public void testRequestSchemaValidationForValidRequestBody() throws Exception {
        JSONObject queryObject = new JSONObject();
        queryObject.put("id", (Object)"8999898");
        queryObject.put("name", (Object)"max");
        queryObject.put("tag", (Object)"terrier");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)(this.invokeURL + "/pets"), this.requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation with valid response body")
    public void testRequestSchemaValidationForValidResponseBody() throws Exception {
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(this.invokeURL + "/pets/123?isAvailable=false"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test SchemaValidation with valid requests for unsecured API resources")
    public void testRequestSchemaValidationForUnSecuredAPIResource() throws Exception {
        HashMap<String, String> requestHeadersWithoutAuthToken = new HashMap<String, String>();
        requestHeadersWithoutAuthToken.put("accept", "application/json");
        requestHeadersWithoutAuthToken.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(this.invokeURL + "/pet/findByStatus"), requestHeadersWithoutAuthToken);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)400);
        Assert.assertEquals((boolean)serviceResponse.getData().contains("Schema validation failed in the Request"), (boolean)true);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiID);
    }
}

