/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.solace;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.AsyncAPISpecificationValidationResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class SolaceTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(SolaceTestCase.class);
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_NO_CONTENT = Response.Status.NO_CONTENT.getStatusCode();
    protected static final String SOLACE_USER_NAME = "testUser";
    protected static final String SOLACE_PASSWORD = "testPassword";
    protected static final String SOLACE_ORGANIZATION = "TestWSO2";
    protected static final String SOLACE_DEVELOPER_USER_NAME = "devPortTestEnv";
    protected static final String SOLACE_ENVIRONMENT = "devportalEnv";
    protected static final String SOLACE_BASE_URL = "http://localhost:9960";
    private static WireMockServer solaceWireMockServer;
    private ArrayList<String> grantTypes;
    private final String solaceGatewayVendor = "solace";
    private String newSubApplicationId;
    private SubscriptionDTO subscriptionDTO1;
    private SubscriptionDTO subscriptionDTO2;
    private final String solaceApiVersion = "1.0";
    private String solaceApiId;
    private final String solaceApiName = "SolaceSampleAPI11";
    private final String solaceApiContext = "SolaceSampleAPI11";
    private final String solaceApiProductName = "devportalEnv-SolaceSampleAPI11-SolaceSampleAPI11-1.0";
    private String solaceApiId2;
    private final String solaceApiName2 = "SolaceSampleAPI12";
    private final String solaceApiContext2 = "SolaceSampleAPI12";
    private final String solaceApiProductName2 = "devportalEnv-SolaceSampleAPI12-SolaceSampleAPI12-1.0";
    private String solaceApiId3;
    private final String solaceApiName3 = "SolaceSampleAPI3";
    private final String solaceApiContext3 = "SolaceSampleAPI3";
    private final String solaceApiVersion3 = "1.0";
    private final String solaceApiProductName3 = "devportalEnv-SolaceSampleAPI3-SolaceSampleAPI3-1.0";
    private String solaceApiId4;
    private final String solaceApiName4 = "SolaceLifeCycleAPI";
    private final String solaceApiContext4 = "SolaceLifeCycleAPI";
    private final String solaceApiProductName4 = "devportalEnv-SolaceLifeCycleAPI-SolaceLifeCycleAPI-1.0";
    private String solaceApiId5;
    private final String solaceApiName5 = "SolaceSampleAPI5";
    private final String solaceApiContext5 = "SolaceSampleAPI5";
    private final String solaceApiProductName5 = "devportalEnv-SolaceSampleAPI5-SolaceSampleAPI5-1.0";

    @Factory(dataProvider="userModeDataProvider")
    public SolaceTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.log.info((Object)"SolaceAPICreateTestCase initiated");
        super.init(this.userMode);
        this.grantTypes = new ArrayList();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("SolaceNewSubApp", "New Subscription for API Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.newSubApplicationId = applicationResponse.getData();
        this.startSolaceWiremockServer();
    }

    public void startSolaceWiremockServer() {
        int wireMockPort = 9960;
        solaceWireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(wireMockPort));
        String toEncode = "testUser:testPassword";
        solaceWireMockServer.stubFor(WireMock.get((String)"/TestWSO2/developers/devPortTestEnv").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n    \"email\": \"dev-1@service-co.com\",\n    \"firstName\": \"Dev-1\",\n    \"lastName\": \"Developer-1\",\n    \"userName\": \"dev-1\"\n}").withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        String body = "{\n    \"description\": \"development api gateway broker\",\n    \"name\": \"devEnv\",\n    \"serviceId\": \"1j7v403y2q9f\",\n    \"serviceName\": \"dev-broker\",\n    \"creationState\": \"completed\",\n    \"datacenterId\": \"aws-eu-central-1a\",\n    \"datacenterProvider\": \"aws\",\n    \"msgVpnName\": \"dev-broker\",\n    \"serviceClassDisplayedAttributes\": {\n        \"High Availability\": \"HA Group\",\n        \"Network Speed\": \"450 Mbps\",\n        \"Storage\": \"25 GB\",\n        \"Message Broker Tenancy\": \"Dedicated\",\n        \"Queues\": \"250\",\n        \"Clients\": \"250\",\n        \"Network Usage\": \"50 GB per month\"\n    },\n    \"serviceClassId\": \"enterprise-250-nano\",\n    \"serviceTypeId\": \"enterprise\",\n    \"messagingProtocols\": [\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"mqtt\",\n                \"version\": \"3.1.1\"\n            },\n            \"transport\": \"TCP\",\n            \"uri\": \"tcp://mr1j7v403y2qa9.messaging.solace.cloud:1883\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"secure-mqtt\",\n                \"version\": \"3.1.1\"\n            },\n            \"transport\": \"SSL\",\n            \"uri\": \"ssl://mr1j7v403y2qa9.messaging.solace.cloud:8883\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"ws-mqtt\",\n                \"version\": \"3.1.1\"\n            },\n            \"transport\": \"WS\",\n            \"uri\": \"ws://mr1j7v403y2qa9.messaging.solace.cloud:8000\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"wss-mqtt\",\n                \"version\": \"3.1.1\"\n            },\n            \"transport\": \"WSS\",\n            \"uri\": \"wss://mr1j7v403y2qa9.messaging.solace.cloud:8443\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"jms\",\n                \"version\": \"1.1\"\n            },\n            \"transport\": \"TCP\",\n            \"uri\": \"smf://mr1j7v403y2qa9.messaging.solace.cloud:55555\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"secure-jms\",\n                \"version\": \"1.1\"\n            },\n            \"transport\": \"TLS\",\n            \"uri\": \"smfs://mr1j7v403y2qa9.messaging.solace.cloud:55443\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"http\",\n                \"version\": \"1.1\"\n            },\n            \"transport\": \"HTTP\",\n            \"uri\": \"http://mr1j7v403y2qa9.messaging.solace.cloud:9000\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"https\",\n                \"version\": \"1.1\"\n            },\n            \"transport\": \"HTTPS\",\n            \"uri\": \"https://mr1j7v403y2qa9.messaging.solace.cloud:9443\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"amqp\",\n                \"version\": \"1.0.0\"\n            },\n            \"transport\": \"AMQP\",\n            \"uri\": \"amqp://mr1j7v403y2qa9.messaging.solace.cloud:5672\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"amqps\",\n                \"version\": \"1.0.0\"\n            },\n            \"transport\": \"AMQPS\",\n            \"uri\": \"amqps://mr1j7v403y2qa9.messaging.solace.cloud:5671\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"smf\",\n                \"version\": \"smf\"\n            },\n            \"transport\": \"TCP\",\n            \"uri\": \"tcp://mr1j7v403y2qa9.messaging.solace.cloud:55555\"\n        },\n        {\n            \"compressed\": \"yes\",\n            \"secure\": \"no\",\n            \"protocol\": {\n                \"name\": \"compressed-smf\",\n                \"version\": \"smf\"\n            },\n            \"transport\": \"TCP\",\n            \"uri\": \"tcp://mr1j7v403y2qa9.messaging.solace.cloud:55003\"\n        },\n        {\n            \"compressed\": \"no\",\n            \"secure\": \"yes\",\n            \"protocol\": {\n                \"name\": \"smfs\",\n                \"version\": \"smfs\"\n            },\n            \"transport\": \"TLS\",\n            \"uri\": \"tcps://mr1j7v403y2qa9.messaging.solace.cloud:55443\"\n        }\n    ]\n}";
        solaceWireMockServer.stubFor(WireMock.get((String)"/TestWSO2/environments/devportalEnv").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody(body).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        String apiNameForRegistration = "SolaceSampleAPI11-1.0";
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration)).inScenario("Get API1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration)).inScenario("Get API1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        String apiNameForRegistration2 = "SolaceSampleAPI12-1.0";
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration2)).inScenario("Get API1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration2)).inScenario("Get API1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        String apiNameForRegistration3 = "SolaceSampleAPI3-1.0";
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration3)).inScenario("Get API1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration3)).inScenario("Get API1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        String apiNameForRegistration4 = "SolaceLifeCycleAPI-1.0";
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration4)).inScenario("Get API1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration4)).inScenario("Get API1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        String apiNameForRegistration5 = "SolaceSampleAPI5-1.0";
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration5)).inScenario("Get API1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/apis/" + apiNameForRegistration5)).inScenario("Get API1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        solaceWireMockServer.stubFor(WireMock.put((String)("/TestWSO2/apis/" + apiNameForRegistration)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.put((String)("/TestWSO2/apis/" + apiNameForRegistration2)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.put((String)("/TestWSO2/apis/" + apiNameForRegistration3)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.put((String)("/TestWSO2/apis/" + apiNameForRegistration4)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.put((String)("/TestWSO2/apis/" + apiNameForRegistration5)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/apis/" + apiNameForRegistration)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/apis/" + apiNameForRegistration2)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/apis/" + apiNameForRegistration3)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/apis/" + apiNameForRegistration4)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/apis/" + apiNameForRegistration5)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI11-SolaceSampleAPI11-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI11-SolaceSampleAPI11-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI12-SolaceSampleAPI12-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI12-SolaceSampleAPI12-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI3-SolaceSampleAPI3-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI3-SolaceSampleAPI3-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceLifeCycleAPI-SolaceLifeCycleAPI-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceLifeCycleAPI-SolaceLifeCycleAPI-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI5-SolaceSampleAPI5-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI5-SolaceSampleAPI5-1.0").inScenario("Get APIProduct1").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Started"));
        solaceWireMockServer.stubFor(WireMock.post((String)"/TestWSO2/apiProducts").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI11-SolaceSampleAPI11-1.0").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI12-SolaceSampleAPI12-1.0").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI3-SolaceSampleAPI3-1.0").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)"/TestWSO2/apiProducts/devportalEnv-SolaceLifeCycleAPI-SolaceLifeCycleAPI-1.0").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)"/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI5-SolaceSampleAPI5-1.0").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.post((String)"/TestWSO2/developers/devPortTestEnv/apps").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_CREATED).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/developers/devPortTestEnv/apps/" + this.newSubApplicationId)).inScenario("Get newSubApplicationId").whenScenarioStateIs("Started").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NOT_FOUND).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor((MappingBuilder)WireMock.get((String)("/TestWSO2/developers/devPortTestEnv/apps/" + this.newSubApplicationId)).inScenario("Get newSubApplicationId").whenScenarioStateIs("Cause Success").withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withBody("{\n    \"name\": \"SolaceNewSubApp\",\n    \"displayName\": \"TestApp\",\n    \"apiProducts\": [\n        \"devportalEnv-SolaceSampleAPI-SolaceSampleAPI-1.0\",\n        \"devportalEnv-SolaceSampleAPI-SolaceSampleAPI-1.0\"\n    ]\n}").withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})).willSetStateTo("Cause Success"));
        solaceWireMockServer.stubFor(WireMock.patch((UrlPattern)WireMock.urlPathEqualTo((String)("/TestWSO2/developers/devPortTestEnv/apps/" + this.newSubApplicationId))).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_OK).withBody("{\n    \"name\": \"SolaceNewSubApp\",\n    \"displayName\": \"TestApp\",\n    \"apiProducts\": [\n        \"devportalEnv-SolaceSampleAPI-SolaceSampleAPI-1.0\",\n        \"devportalEnv-SolaceSampleAPI2-SolaceSampleAPI2-1.0\",\n    ]\n}").withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.stubFor(WireMock.delete((String)("/TestWSO2/developers/devPortTestEnv/apps/" + this.newSubApplicationId)).withHeader("Authorization", WireMock.equalTo((String)("Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HTTP_RESPONSE_CODE_NO_CONTENT).withHeader("Content-Type", new String[]{"application/json", "charset=utf-8"})));
        solaceWireMockServer.start();
    }

    @Test(groups={"wso2.am"}, description="Show the published Solace API details in the Developer Portal")
    public void showSolaceApiInDeveloperPortal() throws Exception {
        this.log.info((Object)"showSolaceApiInDeveloperPortal initiated");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        environment.add(SOLACE_ENVIRONMENT);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("name", (Object)"SolaceSampleAPI11");
        additionalPropertiesObj.put("context", (Object)"SolaceSampleAPI11");
        additionalPropertiesObj.put("version", (Object)"1.0");
        additionalPropertiesObj.put("gatewayVendor", (Object)"solace");
        additionalPropertiesObj.put("type", (Object)"WEBSUB");
        String solaceDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "solace" + File.separator + "APIMaintenance.yml";
        File file = new File(solaceDefinitionPath);
        AsyncAPISpecificationValidationResponseDTO asyncAPISpecificationValidationResponseDTO = this.restAPIPublisher.validateAsyncAPISchemaDefinition(null, file);
        Assert.assertTrue((boolean)asyncAPISpecificationValidationResponseDTO.isIsValid());
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO solaceApiDto = this.restAPIPublisher.importAsyncAPISchemaDefinition(file, null, additionalPropertiesObj.toString());
        this.solaceApiId = solaceApiDto.getId();
        Assert.assertEquals((String)solaceApiDto.getName(), (String)"SolaceSampleAPI11");
        Assert.assertEquals((String)solaceApiDto.getContext(), (String)"/SolaceSampleAPI11");
        Assert.assertEquals((String)solaceApiDto.getGatewayVendor(), (String)"solace");
        ArrayList<String> asyncProtocolsForAssertion = new ArrayList<String>();
        asyncProtocolsForAssertion.add("mqtt");
        asyncProtocolsForAssertion.add("http");
        Assert.assertEquals((Collection)solaceApiDto.getAsyncTransportProtocols(), asyncProtocolsForAssertion);
        this.createSolaceAPIRevisionAndDeployToSolaceBroker(this.solaceApiId, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.solaceApiId, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "SolaceSampleAPI11", "1.0", "\"isApiExists\":true");
        APIDTO storeAPI = this.restAPIStore.getAPI(this.solaceApiId);
        Assert.assertEquals((String)storeAPI.getName(), (String)"SolaceSampleAPI11");
        Assert.assertEquals((String)storeAPI.getContext(), (String)"/SolaceSampleAPI11/1.0");
        Assert.assertEquals((String)storeAPI.getGatewayVendor(), (String)"solace");
        Assert.assertNotNull((Object)storeAPI.getAsyncTransportProtocols());
    }

    @Test(groups={"wso2.am"}, description="Create a new application and generate Keys for Solace subscription", dependsOnMethods={"showSolaceApiInDeveloperPortal"})
    public void testGenerateKeysForSolaceSubscriptions() throws Exception {
        this.log.info((Object)"testGenerateKeysForSolaceSubscriptions initiated");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.newSubApplicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)"Access Token not found ", (String)applicationKeyDTO.getConsumerKey());
        Assert.assertNotNull((Object)"Access Token not found ", (String)applicationKeyDTO.getConsumerSecret());
    }

    @Test(groups={"wso2.am"}, description="Create a new subscription for Solace API", dependsOnMethods={"testGenerateKeysForSolaceSubscriptions"})
    public void testSolaceAPINewSubscriptionCreation() throws Exception {
        this.log.info((Object)"testSolaceAPINewSubscriptionCreation initiated");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("http://localhost:9960/TestWSO2/apiProducts/devportalEnv-SolaceSampleAPI11-SolaceSampleAPI11-1.0");
        String toEncode = "testUser:testPassword";
        httpGet.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes()));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        this.subscriptionDTO1 = this.restAPIStore.subscribeToAPI(this.solaceApiId, this.newSubApplicationId, "AsyncUnlimited");
        ApplicationDTO newSubApplication = this.restAPIStore.getApplicationById(this.newSubApplicationId);
        Assert.assertNotNull((Object)newSubApplication.getSubscriptionCount());
        Assert.assertEquals((int)newSubApplication.getSubscriptionCount(), (int)1);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse appDeleteResponse = this.restAPIStore.deleteApplication(this.newSubApplicationId);
        Assert.assertEquals((int)appDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK);
    }

    @Test(groups={"wso2.am"}, description="Importing Solace Async API definition and create API")
    public void testSolaceDefinitionImport() throws Exception {
        this.log.info((Object)"testWsdlDefinitionImport initiated");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        environment.add(SOLACE_ENVIRONMENT);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("name", (Object)"SolaceSampleAPI3");
        additionalPropertiesObj.put("context", (Object)"SolaceSampleAPI3");
        additionalPropertiesObj.put("version", (Object)"1.0");
        additionalPropertiesObj.put("gatewayVendor", (Object)"solace");
        additionalPropertiesObj.put("type", (Object)"WEBSUB");
        String solaceDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "solace" + File.separator + "APIMaintenance.yml";
        File file = new File(solaceDefinitionPath);
        AsyncAPISpecificationValidationResponseDTO asyncAPISpecificationValidationResponseDTO = this.restAPIPublisher.validateAsyncAPISchemaDefinition(null, file);
        Assert.assertTrue((boolean)asyncAPISpecificationValidationResponseDTO.isIsValid());
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO solaceApiDto = this.restAPIPublisher.importAsyncAPISchemaDefinition(file, null, additionalPropertiesObj.toString());
        this.solaceApiId3 = solaceApiDto.getId();
        Assert.assertEquals((String)solaceApiDto.getName(), (String)"SolaceSampleAPI3");
        Assert.assertEquals((String)solaceApiDto.getContext(), (String)"/SolaceSampleAPI3");
        Assert.assertEquals((String)solaceApiDto.getGatewayVendor(), (String)"solace");
        ArrayList<String> asyncProtocolsForAssertion = new ArrayList<String>();
        asyncProtocolsForAssertion.add("mqtt");
        asyncProtocolsForAssertion.add("http");
        Assert.assertEquals((Collection)solaceApiDto.getAsyncTransportProtocols(), asyncProtocolsForAssertion);
    }

    @Test(groups={"wso2.am"}, description="Deploy created Solace API into Solace broker", dependsOnMethods={"testSolaceDefinitionImport"})
    public void testSolaceAPIDeployToSolaceBroker() throws Exception {
        this.log.info((Object)"testSolaceAPIDeployToSolaceBroker initiated");
        this.createSolaceAPIRevisionAndDeployToSolaceBroker(this.solaceApiId3, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.solaceApiId3, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Undeploy deployed Solace API from Solace broker", dependsOnMethods={"testSolaceAPIDeployToSolaceBroker"})
    public void testSolaceAPIUndeployFromSolaceBroker() throws Exception {
        this.log.info((Object)"testSolaceAPIUndeployFromSolaceBroker initiated");
        this.undeployAndDeleteSolaceAPIRevisionsFromSolaceBroker(this.solaceApiId3, this.restAPIPublisher);
        this.waitForAPIUnDeploymentSync(this.user.getUserName(), "SolaceSampleAPI3", "1.0", "\"isApiExists\":true");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String apiNameForRegistration = "SolaceSampleAPI3-1.0";
        HttpGet httpGet = new HttpGet("http://localhost:9960/TestWSO2/apis/" + apiNameForRegistration);
        String toEncode = "testUser:testPassword";
        httpGet.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes()));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        this.undeployAndDeleteSolaceAPIRevisionsFromSolaceBroker(this.solaceApiId3, this.restAPIPublisher);
        this.waitForAPIUnDeploymentSync(this.user.getUserName(), "SolaceSampleAPI3", "1.0", "\"isApiExists\":true");
        HttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)response2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Invocation passes for GET request");
    }

    @Test(groups={"wso2.am"}, description="Deploy Solace API to solace broker and change life cycle as Retired and assert undeployment at Solace side", dependsOnMethods={"testSolaceAPIUndeployFromSolaceBroker"})
    public void testSolaceAPIRetireLifeCycleAndUndeployFromSolaceBroker() throws Exception {
        this.log.info((Object)"testSolaceAPIRetireLifeCycleAndUndeployFromSolaceBroker initiated");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        environment.add(SOLACE_ENVIRONMENT);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("name", (Object)"SolaceLifeCycleAPI");
        additionalPropertiesObj.put("context", (Object)"SolaceLifeCycleAPI");
        additionalPropertiesObj.put("version", (Object)"1.0");
        additionalPropertiesObj.put("gatewayVendor", (Object)"solace");
        additionalPropertiesObj.put("type", (Object)"WEBSUB");
        String solaceDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "solace" + File.separator + "APIMaintenance.yml";
        File file = new File(solaceDefinitionPath);
        AsyncAPISpecificationValidationResponseDTO asyncAPISpecificationValidationResponseDTO = this.restAPIPublisher.validateAsyncAPISchemaDefinition(null, file);
        Assert.assertTrue((boolean)asyncAPISpecificationValidationResponseDTO.isIsValid());
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO solaceApiDto = this.restAPIPublisher.importAsyncAPISchemaDefinition(file, null, additionalPropertiesObj.toString());
        this.solaceApiId4 = solaceApiDto.getId();
        Assert.assertEquals((String)solaceApiDto.getName(), (String)"SolaceLifeCycleAPI");
        Assert.assertEquals((String)solaceApiDto.getContext(), (String)"/SolaceLifeCycleAPI");
        Assert.assertEquals((String)solaceApiDto.getGatewayVendor(), (String)"solace");
        ArrayList<String> asyncProtocolsForAssertion = new ArrayList<String>();
        asyncProtocolsForAssertion.add("mqtt");
        asyncProtocolsForAssertion.add("http");
        Assert.assertEquals((Collection)solaceApiDto.getAsyncTransportProtocols(), asyncProtocolsForAssertion);
        this.createSolaceAPIRevisionAndDeployToSolaceBroker(this.solaceApiId4, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.solaceApiId4, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "SolaceLifeCycleAPI", "1.0", "\"isApiExists\":true");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse blockAPIActionResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.solaceApiId4, APILifeCycleAction.DEPRECATE.getAction(), null);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)APILifeCycleState.DEPRECATED.getState().equals(blockAPIActionResponse.getData()), (String)("API status Change is invalid when retire an API :SolaceLifeCycleAPI with API ID (" + this.solaceApiId4 + ") Response Code:" + blockAPIActionResponse.getResponseCode()));
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String apiNameForRegistration = "SolaceLifeCycleAPI-1.0";
        HttpGet httpGet = new HttpGet("http://localhost:9960/TestWSO2/apis/" + apiNameForRegistration);
        String toEncode = "testUser:testPassword";
        httpGet.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes()));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation Fails for GET request");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse retiredAPIActionResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.solaceApiId4, APILifeCycleAction.RETIRE.getAction(), null);
        Assert.assertEquals((int)retiredAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)APILifeCycleState.RETIRED.getState().equals(retiredAPIActionResponse.getData()), (String)("API status Change is invalid when retire an API :SolaceLifeCycleAPI with API ID (" + this.solaceApiId4 + ") Response Code:" + retiredAPIActionResponse.getResponseCode()));
        HttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)response2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Invocation Passes for GET request");
    }

    @Test(groups={"wso2.am"}, description="Deploy Solace API to solace broker and delete API from publisher assert undeployment at Solace side", dependsOnMethods={"testSolaceAPIRetireLifeCycleAndUndeployFromSolaceBroker"})
    public void testSolaceAPIDeleteAndUndeployFromSolaceBroker() throws Exception {
        this.log.info((Object)"testSolaceAPIDeleteAndUndeployFromSolaceBroker initiated");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        environment.add(SOLACE_ENVIRONMENT);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("name", (Object)"SolaceSampleAPI5");
        additionalPropertiesObj.put("context", (Object)"SolaceSampleAPI5");
        additionalPropertiesObj.put("version", (Object)"1.0");
        additionalPropertiesObj.put("gatewayVendor", (Object)"solace");
        additionalPropertiesObj.put("type", (Object)"WEBSUB");
        String solaceDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "solace" + File.separator + "APIMaintenance.yml";
        File file = new File(solaceDefinitionPath);
        AsyncAPISpecificationValidationResponseDTO asyncAPISpecificationValidationResponseDTO = this.restAPIPublisher.validateAsyncAPISchemaDefinition(null, file);
        Assert.assertTrue((boolean)asyncAPISpecificationValidationResponseDTO.isIsValid());
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO solaceApiDto = this.restAPIPublisher.importAsyncAPISchemaDefinition(file, null, additionalPropertiesObj.toString());
        this.solaceApiId5 = solaceApiDto.getId();
        Assert.assertEquals((String)solaceApiDto.getName(), (String)"SolaceSampleAPI5");
        Assert.assertEquals((String)solaceApiDto.getContext(), (String)"/SolaceSampleAPI5");
        Assert.assertEquals((String)solaceApiDto.getGatewayVendor(), (String)"solace");
        ArrayList<String> asyncProtocolsForAssertion = new ArrayList<String>();
        asyncProtocolsForAssertion.add("mqtt");
        asyncProtocolsForAssertion.add("http");
        Assert.assertEquals((Collection)solaceApiDto.getAsyncTransportProtocols(), asyncProtocolsForAssertion);
        this.createSolaceAPIRevisionAndDeployToSolaceBroker(this.solaceApiId5, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.solaceApiId5, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "SolaceSampleAPI5", "1.0", "\"isApiExists\":true");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String apiNameForRegistration = "SolaceSampleAPI5-1.0";
        HttpGet httpGet = new HttpGet("http://localhost:9960/TestWSO2/apis/" + apiNameForRegistration);
        String toEncode = "testUser:testPassword";
        httpGet.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes()));
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiDeleteResponse = this.restAPIPublisher.deleteAPI(this.solaceApiId5);
        Assert.assertEquals((int)apiDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to delete API :" + apiDeleteResponse.getData()));
        HttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)response2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Invocation passes for GET request");
    }

    protected String createSolaceAPIRevisionAndDeployToSolaceBroker(String apiId, RestAPIPublisherImpl restAPIPublisher) throws ApiException, JSONException, APIManagerIntegrationTestException {
        int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
        int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
        String revisionUUID = null;
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(apiId);
        apiRevisionRequest.setDescription("Solace API Test Revision 1");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionResponse = restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + apiRevisionResponse.getData()));
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsGetResponse = restAPIPublisher.getAPIRevisions(apiId, null);
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            revisionUUID = revision.getString("id");
        }
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName(SOLACE_ENVIRONMENT);
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsDeployResponse = restAPIPublisher.deployAPIRevision(apiId, revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
        return revisionUUID;
    }

    protected String undeployAndDeleteSolaceAPIRevisionsFromSolaceBroker(String apiId, RestAPIPublisherImpl restAPIPublisher) throws ApiException, JSONException, XPathExpressionException, APIManagerIntegrationTestException {
        int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
        int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
        String revisionUUID = null;
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsGetResponse = restAPIPublisher.getAPIRevisions(apiId, "deployed:true");
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            revisionUUID = revision.getString("id");
        }
        if (revisionUUID == null) {
            return null;
        }
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName(SOLACE_ENVIRONMENT);
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsUnDeployResponse = restAPIPublisher.undeployAPIRevision(apiId, revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to Undeploy API Revisions:" + apiRevisionsUnDeployResponse.getData()));
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsFullGetResponse = restAPIPublisher.getAPIRevisions(apiId, null);
        Assert.assertEquals((int)apiRevisionsFullGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsFullGetResponse.getData()));
        ArrayList<JSONObject> revisionFullList = new ArrayList<JSONObject>();
        JSONObject jsonFullObject = new JSONObject(apiRevisionsFullGetResponse.getData());
        JSONArray arrayFullList = jsonFullObject.getJSONArray("list");
        int l2 = arrayFullList.length();
        for (int i = 0; i < l2; ++i) {
            revisionFullList.add(arrayFullList.getJSONObject(i));
        }
        for (JSONObject revision : revisionFullList) {
            revisionUUID = revision.getString("id");
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionsDeleteResponse = restAPIPublisher.deleteAPIRevision(apiId, revisionUUID);
            Assert.assertEquals((int)apiRevisionsDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to delete API Revisions:" + apiRevisionsDeleteResponse.getData()));
        }
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = restAPIPublisher.getAPI(apiId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiDto.getName(), apiDto.getVersion(), "\"isApiExists\":false");
        return revisionUUID;
    }

    @AfterClass(alwaysRun=true)
    void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.solaceApiId);
        this.restAPIPublisher.deleteAPI(this.solaceApiId3);
        this.restAPIPublisher.deleteAPI(this.solaceApiId4);
        solaceWireMockServer.stop();
    }
}

