/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.async;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class AsyncAPITestCase
extends APIMIntegrationBaseTest {
    private final String ASYNC_TYPE = "ASYNC";
    private final String apiName = "AsyncAPI";
    private final String apiContext = "async";
    private final String apiVersion = "1.0.0";
    private final String applicationName = "testAppAsync";
    private String provider;
    private String apiId;
    private String appId;
    private String asyncAPIDefinition;

    @Factory(dataProvider="userModeDataProvider")
    public AsyncAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.provider = this.user.getUserName();
    }

    @Test(description="Create Async API as a normal API")
    public void testCreateAsyncApiWithoutAdvertiseOnly() throws Exception {
        this.asyncAPIDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("async" + File.separator + "asyncapi.yaml"), (Charset)StandardCharsets.UTF_8);
        File file = this.getTempFileWithContent(this.asyncAPIDefinition);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"AsyncAPI");
        additionalPropertiesObj.put("context", (Object)"async");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        additionalPropertiesObj.put("type", (Object)"ASYNC");
        ApiResponse response = null;
        try {
            response = this.restAPIPublisher.importAsyncAPIDefinition(file, additionalPropertiesObj.toString());
        }
        catch (ApiException e) {
            Assert.assertTrue((boolean)e.getResponseBody().contains("ASYNC type APIs only can be created as third party APIs"));
        }
        if (response != null) {
            Assert.fail();
        }
    }

    @Test(description="Import and Publish Async API")
    public void testPublishAsyncApi() throws Exception {
        this.asyncAPIDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("async" + File.separator + "asyncapi.yaml"), (Charset)StandardCharsets.UTF_8);
        File file = this.getTempFileWithContent(this.asyncAPIDefinition);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"AsyncAPI");
        additionalPropertiesObj.put("context", (Object)"async");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        additionalPropertiesObj.put("type", (Object)"ASYNC");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("AsyncWHUnlimited");
        additionalPropertiesObj.put("policies", policies);
        JSONObject advertiseInfo = new JSONObject();
        advertiseInfo.put("advertised", true);
        advertiseInfo.put("apiExternalProductionEndpoint", (Object)"https://test.com");
        advertiseInfo.put("apiExternalSandboxEndpoint", (Object)"https://test.com");
        advertiseInfo.put("originalDevPortalUrl", (Object)"https://test.com");
        advertiseInfo.put("vendor", (Object)"WSO2");
        advertiseInfo.put("apiOwner", (Object)this.provider);
        additionalPropertiesObj.put("advertiseInfo", (Object)advertiseInfo);
        ApiResponse response = this.restAPIPublisher.importAsyncAPIDefinition(file, additionalPropertiesObj.toString());
        Assert.assertEquals((int)201, (int)response.getStatusCode());
        APIDTO apidto = (APIDTO)response.getData();
        this.apiId = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"AsyncAPI API creation is failed");
        String revisionUUID = null;
        try {
            revisionUUID = this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        }
        catch (ApiException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error while adding new API Revision for API : "));
        }
        if (revisionUUID != null) {
            Assert.fail();
        }
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeployment();
        APIIdentifier apiIdentifier = new APIIdentifier(this.provider, "AsyncAPI", "1.0.0");
        APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"testPublishAsyncApi"})
    public void testAsyncApiApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("testAppAsync", "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, "AsyncWHUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    private File getTempFileWithContent(String asyncApi) throws Exception {
        File temp = File.createTempFile("async", ".yaml");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(asyncApi);
        out.close();
        return temp;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

