/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WebsubSubscriptionConfigurationDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.streamingapis.StreamingApiTestUtils;
import org.wso2.am.integration.tests.streamingapis.websub.WebSubAPITestCase;
import org.wso2.am.integration.tests.streamingapis.websub.client.WebhookSender;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServlet;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServlet2;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class MultipleWebSubSubcriptionTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSubAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int TOPIC_PORT = 9521;
    private final String DEFAULT_TOPIC = "_default";
    private final String SUBSCRIBE = "subscribe";
    private final String UNSUBSCRIBE = "unsubscribe";
    private String apiName = "WebSubMultipleSubAPI";
    private String applicationName1 = "WebSubultipleSubApplication1";
    private String applicationName2 = "WebSubultipleSubApplication2";
    private String apiContext = "websubMultiSub";
    private String apiVersion = "1.0.0";
    private String webSubEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "streamingAPIs" + File.separator + "webSubTest" + File.separator;
    private String webSubRequestEventPublisherSource = "WebSub_Req_Logger.xml";
    private String webSubThrottleOutEventPublisherSource = "WebSub_Throttle_Out_Logger.xml";
    private String webSubEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private ServerConfigurationManager serverConfigurationManager;
    private String provider;
    private APIRequest apiRequest;
    private int callbackReceiverPort1;
    private int callbackReceiverPort2;
    private String serverHost;
    private String apiId;
    private String appId;
    private String topicSecret;
    private String apiEndpoint;
    private WebhookSender webhookSender;
    private CallbackServerServlet callbackServerServlet;
    private CallbackServerServlet2 callbackServerServlet2;
    private Server callbackServer;
    private String accessToken1;
    private String accessToken2;

    @Factory(dataProvider="userModeDataProvider")
    public MultipleWebSubSubcriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubRequestEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubThrottleOutEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubThrottleOutEventPublisherSource), false);
        this.serverHost = InetAddress.getLocalHost().getHostName();
        this.callbackReceiverPort1 = this.getCallBackServletPort(8080, 8090);
        this.callbackReceiverPort2 = this.getCallBackServletPort(8060, 8070);
        this.log.info((Object)("Selected port " + this.callbackReceiverPort1 + " to start callback receiver"));
        this.callbackServerServlet = new CallbackServerServlet();
        this.initializeCallbackReceiver(this.callbackReceiverPort1, (Servlet)this.callbackServerServlet);
        this.callbackServerServlet2 = new CallbackServerServlet2();
        this.initializeCallbackReceiver(this.callbackReceiverPort2, (Servlet)this.callbackServerServlet2);
        Thread.sleep(5000L);
    }

    private int getCallBackServletPort(int lowerPortLimit, int upperPortLimit) throws APIManagerIntegrationTestException {
        int port = StreamingApiTestUtils.getAvailablePort(lowerPortLimit, upperPortLimit, this.serverHost);
        if (port == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        return port;
    }

    @Test(description="Publish WebSub API")
    public void testPublishWebSubApi() throws Exception {
        this.provider = this.user.getUserName();
        this.apiRequest = new APIRequest(this.apiName, this.apiContext);
        this.apiRequest.setVersion(this.apiVersion);
        this.apiRequest.setTiersCollection("AsyncWHUnlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WEBSUB");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.apiId = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId);
        this.topicSecret = UUID.randomUUID().toString();
        WebsubSubscriptionConfigurationDTO websubSubscriptionConfig = new WebsubSubscriptionConfigurationDTO();
        websubSubscriptionConfig.setSecret(this.topicSecret);
        websubSubscriptionConfig.setSigningAlgorithm("SHA1");
        websubSubscriptionConfig.setSignatureHeader("x-hub-signature");
        apiDto.setWebsubSubscriptionConfiguration(websubSubscriptionConfig);
        this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifier = new APIIdentifier(this.provider, this.apiName, this.apiVersion);
        this.apiEndpoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getSuperTenantAPIInvocationURLHttp(this.apiContext, this.apiVersion) : this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifier, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"testPublishWebSubApi"})
    public void testWebSubApiApplicationSubscription() throws Exception {
        this.accessToken1 = this.subscribeToAPI(this.applicationName1);
        this.accessToken2 = this.subscribeToAPI(this.applicationName2);
    }

    private String subscribeToAPI(String applicationName) throws ApiException, APIManagerIntegrationTestException {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = null;
        subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, "AsyncWHUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        return applicationKeyDTO.getToken().getAccessToken();
    }

    @Test(description="Invoke the WebSub API", dependsOnMethods={"testWebSubApiApplicationSubscription"})
    public void testInvokeWebSubApi() throws Exception {
        String callbackUrl1 = "http://" + this.serverHost + ":" + this.callbackReceiverPort1 + "/receiver";
        String callbackUrl2 = "http://" + this.serverHost + ":" + this.callbackReceiverPort2 + "/receiver";
        MultipleWebSubSubcriptionTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl1, "_default", this.topicSecret, "50000000", this.accessToken1);
        MultipleWebSubSubcriptionTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl2, "_default", this.topicSecret, "50000000", this.accessToken2);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        int noOfEventsToSend = 10;
        for (int i = 0; i < noOfEventsToSend; ++i) {
            this.webhookSender.send();
            Thread.sleep(3000L);
        }
        MultipleWebSubSubcriptionTestCase.handleCallbackSubscription("unsubscribe", this.apiEndpoint, callbackUrl1, "_default", this.topicSecret, "50000000", this.accessToken1);
        MultipleWebSubSubcriptionTestCase.handleCallbackSubscription("unsubscribe", this.apiEndpoint, callbackUrl2, "_default", this.topicSecret, "50000000", this.accessToken2);
        Thread.sleep(5000L);
        int sent = this.webhookSender.getWebhooksSent();
        int receivedBy1 = this.callbackServerServlet.getCallbacksReceived();
        int receivedBy2 = this.callbackServerServlet2.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)noOfEventsToSend);
        Assert.assertEquals((int)(sent + 1), (int)receivedBy1);
        Assert.assertEquals((int)(sent + 1), (int)receivedBy2);
        this.callbackServerServlet.setCallbacksReceived(0);
        this.callbackServerServlet2.setCallbacksReceived(0);
        this.webhookSender.setWebhooksSent(0);
    }

    private void initializeCallbackReceiver(int port, final Servlet servlet) {
        Server server = new Server(port);
        final ServletHandler servletHandler = new ServletHandler();
        server.setHandler((Handler)servletHandler);
        this.callbackServer = server;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletHolder servletHolder = new ServletHolder(servlet);
                    servletHandler.addServletWithMapping(servletHolder, "/receiver");
                    MultipleWebSubSubcriptionTestCase.this.callbackServer.start();
                }
                catch (Exception e) {
                    MultipleWebSubSubcriptionTestCase.this.log.error((Object)"Failed to start the callback server");
                }
            }
        });
    }

    private void initializeWebhookSender(String secret) {
        String payloadUrl = this.apiEndpoint.replaceAll(":([0-9]+)/", ":9521/") + "/webhooks_events_receiver_resource?topic=" + "_default";
        this.webhookSender = new WebhookSender(payloadUrl, secret);
    }

    private static void handleCallbackSubscription(String hubMode, String webSubApiUrl, String callbackUrl, String hubTopic, String hubSecret, String hubLeaseSeconds, String bearerToken) throws UnsupportedEncodingException, MalformedURLException, AutomationFrameworkException {
        String encodedUrl = URLEncoder.encode(callbackUrl, StandardCharsets.UTF_8.toString());
        String url = webSubApiUrl + "?hub.callback=" + encodedUrl + "&hub.mode=" + hubMode + "&hub.secret=" + hubSecret + "&hub.lease_seconds=" + hubLeaseSeconds + "&hub.topic=" + hubTopic;
        HttpRequestUtil.doPost((URL)new URL(url), (String)"", Collections.singletonMap("Authorization", "Bearer " + bearerToken));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.callbackServer.stop();
        this.executorService.shutdownNow();
        super.cleanUp();
    }
}

