/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.EventCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WebsubSubscriptionConfigurationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.streamingapis.StreamingApiTestUtils;
import org.wso2.am.integration.tests.streamingapis.websub.WebSubAPITestCase;
import org.wso2.am.integration.tests.streamingapis.websub.client.WebhookSender;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServlet;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ThrottlingTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSubAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int TOPIC_PORT = 9521;
    private final String DEFAULT_TOPIC = "_default";
    private final String SUBSCRIBE = "subscribe";
    private final String UNSUBSCRIBE = "unsubscribe";
    private String apiName = "WebSubThrottlingAPI";
    private String applicationName = "WebSubThrottlingApplication";
    private String apiContext = "websubThrottling";
    private String apiVersion = "1.0.0";
    private String webSubEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "streamingAPIs" + File.separator + "webSubTest" + File.separator;
    private String webSubRequestEventPublisherSource = "WebSub_Req_Logger.xml";
    private String webSubThrottleOutEventPublisherSource = "WebSub_Throttle_Out_Logger.xml";
    private String webSubEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private ServerConfigurationManager serverConfigurationManager;
    private String provider;
    private APIRequest apiRequest;
    private int callbackReceiverPort;
    private String serverHost;
    private String apiId;
    private String appId;
    private String topicSecret;
    private String apiEndpoint;
    private WebhookSender webhookSender;
    private CallbackServerServlet callbackServerServlet;
    private Server callbackServer;
    private String subPolicyId;
    private String subPolicyName;
    private String accessToken;

    @Factory(dataProvider="userModeDataProvider")
    public ThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubRequestEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubThrottleOutEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubThrottleOutEventPublisherSource), false);
        this.serverHost = InetAddress.getLocalHost().getHostName();
        String INTERNAL_EVERYONE = "Internal/everyone";
        ArrayList<String> roleList = new ArrayList<String>();
        FileInputStream inputStream = new FileInputStream(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "streamingAPIs" + File.separator + "webSubTest" + File.separator + "policy.json");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonMap = mapper.readTree((InputStream)inputStream);
        this.subPolicyName = jsonMap.get("policyName").textValue();
        JsonNode defaultLimitJson = jsonMap.get("defaultLimit");
        JsonNode requestCountJson = defaultLimitJson.get("requestCount");
        Long requestCountLimit = Long.valueOf(String.valueOf(requestCountJson.get("requestCount")));
        String timeUnit = requestCountJson.get("timeUnit").textValue();
        Integer unitTime = Integer.valueOf(String.valueOf(requestCountJson.get("unitTime")));
        EventCountLimitDTO eventCountLimitDTO = DtoFactory.createEventCountLimitDTO((String)timeUnit, (Integer)unitTime, (Long)requestCountLimit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createEventCountThrottleLimitDTO((EventCountLimitDTO)eventCountLimitDTO);
        roleList.add(INTERNAL_EVERYONE);
        SubscriptionThrottlePolicyPermissionDTO permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, roleList);
        SubscriptionThrottlePolicyDTO bandwidthSubscriptionPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)this.subPolicyName, (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)-1, (int)-1, (int)5, (String)"min", new ArrayList(), (boolean)true, (String)"", (int)2, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse addedSubscriptionPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(bandwidthSubscriptionPolicyDTO);
        Assert.assertEquals((int)addedSubscriptionPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedSubscriptionPolicyDTO = (SubscriptionThrottlePolicyDTO)addedSubscriptionPolicy.getData();
        this.subPolicyId = addedSubscriptionPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.subPolicyId, (String)"The policy ID cannot be null or empty");
        int lowerPortLimit = 8080;
        int upperPortLimit = 8090;
        this.callbackReceiverPort = StreamingApiTestUtils.getAvailablePort(lowerPortLimit, upperPortLimit, this.serverHost);
        if (this.callbackReceiverPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.callbackReceiverPort + " to start callback receiver"));
        this.initializeCallbackReceiver(this.callbackReceiverPort);
        Thread.sleep(5000L);
    }

    @Test(description="Publish WebSub API")
    public void testPublishWebSubApi() throws Exception {
        this.provider = this.user.getUserName();
        this.apiRequest = new APIRequest(this.apiName, this.apiContext);
        this.apiRequest.setVersion(this.apiVersion);
        this.apiRequest.setTiersCollection(this.subPolicyName);
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WEBSUB");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.apiId = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId);
        this.topicSecret = UUID.randomUUID().toString();
        WebsubSubscriptionConfigurationDTO websubSubscriptionConfig = new WebsubSubscriptionConfigurationDTO();
        websubSubscriptionConfig.setSecret(this.topicSecret);
        websubSubscriptionConfig.setSigningAlgorithm("SHA1");
        websubSubscriptionConfig.setSignatureHeader("x-hub-signature");
        apiDto.setWebsubSubscriptionConfiguration(websubSubscriptionConfig);
        this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifier = new APIIdentifier(this.provider, this.apiName, this.apiVersion);
        this.apiEndpoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getSuperTenantAPIInvocationURLHttp(this.apiContext, this.apiVersion) : this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifier, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"testPublishWebSubApi"})
    public void testWebSubApiApplicationSubscription() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, this.subPolicyName);
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
    }

    @Test(description="Test events throttling", dependsOnMethods={"testWebSubApiApplicationSubscription"})
    public void testEventsThrottling() throws Exception {
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        ThrottlingTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        int noOfEventsToSend = 10;
        for (int i = 0; i < noOfEventsToSend; ++i) {
            this.webhookSender.send();
            Thread.sleep(5000L);
        }
        ThrottlingTestCase.handleCallbackSubscription("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        int sent = this.webhookSender.getWebhooksSent();
        int received = this.callbackServerServlet.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)noOfEventsToSend);
        Assert.assertTrue((received < noOfEventsToSend ? 1 : 0) != 0);
        this.callbackServerServlet.setCallbacksReceived(0);
        this.webhookSender.setWebhooksSent(0);
    }

    @Test(description="Test subscription count throttling", dependsOnMethods={"testWebSubApiApplicationSubscription"})
    public void testSubscriptionCountThrottling() throws Exception {
        String callbackUrl1 = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        String callbackUrl2 = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver2";
        String callbackUrl3 = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver3";
        HttpResponse response = ThrottlingTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl1, "_default", this.topicSecret, "50000000", this.accessToken);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        response = ThrottlingTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl2, "_default", this.topicSecret, "50000000", this.accessToken);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        response = ThrottlingTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl3, "_default", this.topicSecret, "50000000", this.accessToken);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)429);
    }

    private void initializeCallbackReceiver(int port) {
        Server server = new Server(port);
        final ServletHandler servletHandler = new ServletHandler();
        server.setHandler((Handler)servletHandler);
        this.callbackServerServlet = new CallbackServerServlet();
        this.callbackServer = server;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletHolder servletHolder = new ServletHolder((Servlet)ThrottlingTestCase.this.callbackServerServlet);
                    servletHandler.addServletWithMapping(servletHolder, "/receiver");
                    ThrottlingTestCase.this.callbackServer.start();
                }
                catch (Exception e) {
                    ThrottlingTestCase.this.log.error((Object)"Failed to start the callback server");
                }
            }
        });
    }

    private void initializeWebhookSender(String secret) {
        String payloadUrl = this.apiEndpoint.replaceAll(":([0-9]+)/", ":9521/") + "/webhooks_events_receiver_resource?topic=" + "_default";
        this.webhookSender = new WebhookSender(payloadUrl, secret);
    }

    private static HttpResponse handleCallbackSubscription(String hubMode, String webSubApiUrl, String callbackUrl, String hubTopic, String hubSecret, String hubLeaseSeconds, String bearerToken) throws IOException, URISyntaxException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(webSubApiUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (!StringUtils.isEmpty((CharSequence)callbackUrl)) {
            String encodedUrl = URLEncoder.encode(callbackUrl, StandardCharsets.UTF_8.toString());
            params.add(new BasicNameValuePair("hub.callback", encodedUrl));
        }
        if (!StringUtils.isEmpty((CharSequence)hubMode)) {
            params.add(new BasicNameValuePair("hub.mode", hubMode));
        }
        if (!StringUtils.isEmpty((CharSequence)hubTopic)) {
            params.add(new BasicNameValuePair("hub.topic", hubTopic));
        }
        if (!StringUtils.isEmpty((CharSequence)hubSecret)) {
            params.add(new BasicNameValuePair("hub.secret", hubSecret));
        }
        if (!StringUtils.isEmpty((CharSequence)hubLeaseSeconds)) {
            params.add(new BasicNameValuePair("hub.lease_seconds", hubLeaseSeconds));
        }
        URI uri = new URIBuilder(httppost.getURI()).addParameters(params).build();
        httppost.setURI(uri);
        httppost.setHeader("Authorization", "Bearer " + bearerToken);
        return httpclient.execute((HttpUriRequest)httppost);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.callbackServer.stop();
        this.executorService.shutdownNow();
        super.cleanUp();
    }
}

