/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Servlet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WebsubSubscriptionConfigurationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.streamingapis.StreamingApiTestUtils;
import org.wso2.am.integration.tests.streamingapis.websub.client.WebhookSender;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServlet;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServletWithSubVerification;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class WebSubAPITestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSubAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int TOPIC_PORT = 9521;
    private final String DEFAULT_TOPIC = "_default";
    private final String SUBSCRIBE = "subscribe";
    private final String UNSUBSCRIBE = "unsubscribe";
    private String apiName = "WebSubAPI";
    private String applicationName = "WebSubApplication";
    private String apiContext = "websub";
    private String apiVersion = "1.0.0";
    private String webSubEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "streamingAPIs" + File.separator + "webSubTest" + File.separator;
    private String webSubRequestEventPublisherSource = "WebSub_Req_Logger.xml";
    private String webSubThrottleOutEventPublisherSource = "WebSub_Throttle_Out_Logger.xml";
    private String webSubEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private ServerConfigurationManager serverConfigurationManager;
    private String provider;
    private APIRequest apiRequest;
    private int callbackReceiverPort;
    private String serverHost;
    private String apiId;
    private String appId;
    private String topicSecret;
    private String apiEndpoint;
    private WebhookSender webhookSender;
    private CallbackServerServlet callbackServerServlet;
    private Server callbackServer;
    private String accessToken;
    private CallbackServerServletWithSubVerification callbackServerServletWithSubVerification;
    private int callbackReceiverWithSubVerificationPort;
    private Server callbackServerWithSubVerification;

    @Factory(dataProvider="userModeDataProvider")
    public WebSubAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubRequestEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubThrottleOutEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubThrottleOutEventPublisherSource), false);
        this.serverHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 8080;
        int upperPortLimit = 8090;
        this.callbackReceiverPort = StreamingApiTestUtils.getAvailablePort(lowerPortLimit, upperPortLimit, this.serverHost);
        if (this.callbackReceiverPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.callbackReceiverPort + " to start callback receiver"));
        this.initializeCallbackReceiver(this.callbackReceiverPort);
        Thread.sleep(5000L);
        this.callbackReceiverWithSubVerificationPort = StreamingApiTestUtils.getAvailablePort(lowerPortLimit, upperPortLimit, this.serverHost);
        if (this.callbackReceiverWithSubVerificationPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.callbackReceiverWithSubVerificationPort + " to start callback receiver"));
        this.initializeCallbackReceiverWithSubVerification(this.callbackReceiverWithSubVerificationPort);
        Thread.sleep(5000L);
    }

    @Test(description="Publish WebSub API")
    public void testPublishWebSubApi() throws Exception {
        this.provider = this.user.getUserName();
        this.apiRequest = new APIRequest(this.apiName, this.apiContext);
        this.apiRequest.setVersion(this.apiVersion);
        this.apiRequest.setTiersCollection("AsyncWHUnlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WEBSUB");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.apiId = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId);
        this.topicSecret = UUID.randomUUID().toString();
        WebsubSubscriptionConfigurationDTO websubSubscriptionConfig = new WebsubSubscriptionConfigurationDTO();
        websubSubscriptionConfig.setSecret(this.topicSecret);
        websubSubscriptionConfig.setSigningAlgorithm("SHA1");
        websubSubscriptionConfig.setSignatureHeader("x-hub-signature");
        apiDto.setWebsubSubscriptionConfiguration(websubSubscriptionConfig);
        this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifier = new APIIdentifier(this.provider, this.apiName, this.apiVersion);
        this.apiEndpoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getSuperTenantAPIInvocationURLHttp(this.apiContext, this.apiVersion) : this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifier, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"testPublishWebSubApi"})
    public void testWebSubApiApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, "AsyncWHUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    @Test(description="Invoke the WebSub API", dependsOnMethods={"testWebSubApiApplicationSubscription"})
    public void testInvokeWebSubApi() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)this.accessToken, (String)"Error occurred while generating the access token");
    }

    @Test(description="Test invoke WebSub API when parameters are passed as query parameters", dependsOnMethods={"testInvokeWebSubApi"})
    public void testInvokeWebSubApiWithQueryParameters() throws Exception {
        this.callbackServerServlet.setCallbacksReceived(0);
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        WebSubAPITestCase.handleCallbackSubscriptionWithQueryParameters("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        int noOfEventsToSend = 10;
        for (int i = 0; i < noOfEventsToSend; ++i) {
            this.webhookSender.send();
            Thread.sleep(5000L);
        }
        WebSubAPITestCase.handleCallbackSubscriptionWithQueryParameters("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        Thread.sleep(5000L);
        int sent = this.webhookSender.getWebhooksSent();
        int received = this.callbackServerServlet.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)noOfEventsToSend);
        Assert.assertEquals((int)(sent + 1), (int)received);
    }

    @Test(description="Test invoke WebSub API when parameters are passed as form url encoded data", dependsOnMethods={"testInvokeWebSubApi"})
    public void testInvokeWebSubAPIWithFormUrlEncodedData() throws Exception {
        this.callbackServerServlet.setCallbacksReceived(0);
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        HttpResponse subResponse = WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        Assert.assertEquals((int)202, (int)subResponse.getResponseCode(), (String)("Subscribe request failed with a " + subResponse.getResponseCode() + " response"));
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        int noOfEventsToSend = 5;
        for (int i = 0; i < noOfEventsToSend; ++i) {
            this.webhookSender.send();
            Thread.sleep(5000L);
        }
        HttpResponse unSubResponse = WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        Thread.sleep(5000L);
        Assert.assertEquals((int)202, (int)unSubResponse.getResponseCode(), (String)("Unsubscribe request failed with a " + unSubResponse.getResponseCode() + " response"));
        int sent = this.webhookSender.getWebhooksSent();
        int received = this.callbackServerServlet.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)noOfEventsToSend, (String)"Webhook sender failed to send all the requests");
        Assert.assertEquals((int)sent, (int)received, (String)"Callback server did not receive all the content distribution requests");
    }

    @Test(description="Check availability of mandatory parameters", dependsOnMethods={"testInvokeWebSubApi"})
    public void testMandatoryParameters() throws Exception {
        this.callbackServerServlet.setCallbacksReceived(0);
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        Assert.assertEquals((String)"subscribe", (String)this.callbackServerServlet.getHubMode(), (String)"Callback server did not receive the expected hub.mode parameter");
        Assert.assertEquals((String)"_default", (String)this.callbackServerServlet.getHubTopic(), (String)"Callback server did not receive the expected hub.topic parameter");
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)this.callbackServerServlet.getHubChallenge()), (String)"Callback server did not receive the hub.challenge parameter");
        String hubUrl = "http://localhost:9521";
        this.webhookSender.send();
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)this.callbackServerServlet.getLinkHeader().contains(hubUrl), (String)"Missing link header in content distribution request");
        WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        Thread.sleep(5000L);
    }

    @Test(description="Check subscription when mandatory parameters are missing", dependsOnMethods={"testInvokeWebSubApi"})
    public void testMissingMandatoryParameters() throws Exception {
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        try {
            WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
            Thread.sleep(5000L);
            Assert.fail((String)"WebSub subscription invoked without mandatory parameters.");
        }
        catch (AutomationFrameworkException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 500"));
        }
    }

    @Test(description="Check subscriber verification", dependsOnMethods={"testInvokeWebSubApi"})
    public void testSubscriberVerification() throws Exception {
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId);
        apiDto.setEnableSubscriberVerification(Boolean.valueOf(true));
        this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        this.callbackServerServlet.setCallbacksReceived(0);
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverWithSubVerificationPort + "/receiver";
        WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        int noOfEventsToSend = 5;
        for (int i = 0; i < noOfEventsToSend; ++i) {
            this.webhookSender.send();
            Thread.sleep(5000L);
        }
        WebSubAPITestCase.handleCallbackSubscriptionWithFormUrlEncoded("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "50000000", this.accessToken);
        Thread.sleep(5000L);
        int sent = this.webhookSender.getWebhooksSent();
        int received = this.callbackServerServletWithSubVerification.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)noOfEventsToSend, (String)"Webhook sender failed to send all the requests");
        Assert.assertEquals((int)sent, (int)received, (String)"Callback server did not receive all the content distribution requests");
    }

    private void initializeCallbackReceiverWithSubVerification(int port) {
        Server server = new Server(port);
        final ServletHandler servletHandler = new ServletHandler();
        server.setHandler((Handler)servletHandler);
        this.callbackServerServletWithSubVerification = new CallbackServerServletWithSubVerification();
        this.callbackServerWithSubVerification = server;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletHolder servletHolder = new ServletHolder((Servlet)WebSubAPITestCase.this.callbackServerServletWithSubVerification);
                    servletHandler.addServletWithMapping(servletHolder, "/receiver");
                    WebSubAPITestCase.this.callbackServerWithSubVerification.start();
                }
                catch (Exception e) {
                    WebSubAPITestCase.this.log.error((Object)"Failed to start the callback server");
                }
            }
        });
    }

    private void initializeCallbackReceiver(int port) {
        Server server = new Server(port);
        final ServletHandler servletHandler = new ServletHandler();
        server.setHandler((Handler)servletHandler);
        this.callbackServerServlet = new CallbackServerServlet();
        this.callbackServer = server;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletHolder servletHolder = new ServletHolder((Servlet)WebSubAPITestCase.this.callbackServerServlet);
                    servletHandler.addServletWithMapping(servletHolder, "/receiver");
                    WebSubAPITestCase.this.callbackServer.start();
                }
                catch (Exception e) {
                    WebSubAPITestCase.this.log.error((Object)"Failed to start the callback server");
                }
            }
        });
    }

    private void initializeWebhookSender(String secret) {
        String payloadUrl = this.apiEndpoint.replaceAll(":([0-9]+)/", ":9521/") + "/webhooks_events_receiver_resource?topic=" + "_default";
        this.webhookSender = new WebhookSender(payloadUrl, secret);
        this.webhookSender.setWebhooksSent(0);
    }

    private static void handleCallbackSubscriptionWithQueryParameters(String hubMode, String webSubApiUrl, String callbackUrl, String hubTopic, String hubSecret, String hubLeaseSeconds, String bearerToken) throws UnsupportedEncodingException, MalformedURLException, AutomationFrameworkException {
        String encodedUrl = URLEncoder.encode(callbackUrl, StandardCharsets.UTF_8.toString());
        String url = webSubApiUrl + "?hub.callback=" + encodedUrl + "&hub.mode=" + hubMode + "&hub.secret=" + hubSecret + "&hub.lease_seconds=" + hubLeaseSeconds + "&hub.topic=" + hubTopic;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + bearerToken);
        headers.put("Content-Type", "application/json");
        HttpRequestUtil.doPost((URL)new URL(url), (String)"", headers);
    }

    private static HttpResponse handleCallbackSubscriptionWithFormUrlEncoded(String hubMode, String url, String callbackUrl, String hubTopic, String hubSecret, String hubLeaseSeconds, String bearerToken) throws UnsupportedEncodingException, MalformedURLException, AutomationFrameworkException {
        String encodedUrl = URLEncoder.encode(callbackUrl, StandardCharsets.UTF_8.toString());
        String body = "hub.callback=" + encodedUrl + "&hub.mode=" + hubMode + "&hub.secret=" + hubSecret + "&hub.lease_seconds=" + hubLeaseSeconds + "&hub.topic=" + hubTopic;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + bearerToken);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return HttpRequestUtil.doPost((URL)new URL(url), (String)body, headers);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.callbackServer.stop();
        this.callbackServerWithSubVerification.stop();
        this.executorService.shutdownNow();
        super.cleanUp();
    }
}

