/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub.server;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(urlPatterns={"/receiver"})
public class CallbackServerServletWithSubVerification
extends HttpServlet {
    private final Log log = LogFactory.getLog(CallbackServerServletWithSubVerification.class);
    private AtomicInteger callbacksReceived = new AtomicInteger(0);
    private String message;
    private String signature;
    private String linkHeader;
    private String hubMode;
    private String hubTopic;
    private String hubChallenge;

    public String getHubMode() {
        return this.hubMode;
    }

    public void setHubMode(String hubMode) {
        this.hubMode = hubMode;
    }

    public String getHubTopic() {
        return this.hubTopic;
    }

    public void setHubTopic(String hubTopic) {
        this.hubTopic = hubTopic;
    }

    public String getHubChallenge() {
        return this.hubChallenge;
    }

    public void setHubChallenge(String hubChallenge) {
        this.hubChallenge = hubChallenge;
    }

    public String getLinkHeader() {
        return this.linkHeader;
    }

    public void setLinkHeader(String linkHeader) {
        this.linkHeader = linkHeader;
    }

    public int getCallbacksReceived() {
        return this.callbacksReceived.get();
    }

    public void setCallbacksReceived(int callbacksReceived) {
        this.callbacksReceived.set(callbacksReceived);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.log.info((Object)"Callback Received");
        this.message = IOUtils.toString((Reader)req.getReader());
        this.signature = req.getHeader("x-hub-signature");
        this.setLinkHeader(req.getHeader("link"));
        this.callbacksReceived.incrementAndGet();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.log.info((Object)"Subscription callback Received");
        this.setHubMode(req.getParameter("hub.mode"));
        this.setHubTopic(req.getParameter("hub.topic"));
        this.setHubChallenge(req.getParameter("hub.challenge"));
        if (this.getHubMode().equals("subscribe")) {
            resp.addHeader("Content-Type", "text/plain");
            resp.setStatus(200);
            resp.getWriter().write(this.getHubChallenge());
            resp.getWriter().flush();
        }
    }

    public String getLastReceivedMessage() {
        return this.message;
    }

    public String getLastReceivedSignature() {
        return this.signature;
    }
}

