/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.CustomAttributeDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class BurstControlTestCase
extends APIManagerLifecycleBaseTest {
    private String subscriptionTier5RPMburst = "SubscriptionTier5RPMburst";
    private String subscriptionTier25RPMburst = "SubscriptionTier25RPMburst";
    private SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO1;
    private SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO2;
    private String rateLimitTimeUnit = "min";
    private boolean stopQuotaOnReach = true;
    private String billingPlan = "COMMERCIAL";
    private Integer subscriberCount = 0;
    private List<CustomAttributeDTO> customAttributes = null;
    private int burstLimit1 = 5;
    private int burstLimit2 = 25;
    private String backendEP;
    private String apiId;
    private String APIName = "APIThrottleBurstAPI";
    private String APIVersion = "1.0.0";
    private String APIContext = "api_burst";
    private String applicationName = "APIThrottleBurst-application";
    private ApplicationDTO applicationDTO;
    private final Log log = LogFactory.getLog(BurstControlTestCase.class);
    private String payload = "{\"payload\" : \"test\"}";

    @Factory(dataProvider="userModeDataProvider")
    public BurstControlTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String INTERNAL_EVERYONE = "Internal/everyone";
        ArrayList<String> roleList = new ArrayList<String>();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)1, (Long)1000L);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        roleList.add(INTERNAL_EVERYONE);
        SubscriptionThrottlePolicyPermissionDTO permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, roleList);
        this.subscriptionThrottlePolicyDTO1 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)this.subscriptionTier5RPMburst, (String)"subscriptionTier5RPMburst", (String)"1000 request per min with burst of 5 requests per minute", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)0, (int)0, (int)this.burstLimit1, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)this.stopQuotaOnReach, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse apiResponse = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO1);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)201);
        this.subscriptionThrottlePolicyDTO1 = (SubscriptionThrottlePolicyDTO)apiResponse.getData();
        this.subscriptionThrottlePolicyDTO2 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)this.subscriptionTier25RPMburst, (String)"subscriptionTier25RPMburst", (String)"1000 request per min with burst of 25 requests per minute", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)0, (int)0, (int)this.burstLimit2, (String)this.rateLimitTimeUnit, this.customAttributes, (boolean)this.stopQuotaOnReach, (String)this.billingPlan, (int)this.subscriberCount, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        apiResponse = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO2);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)201);
        this.subscriptionThrottlePolicyDTO2 = (SubscriptionThrottlePolicyDTO)apiResponse.getData();
        String url = this.backendEP = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        APIRequest apiRequest = new APIRequest(this.APIName, this.APIContext, new URL(url), new URL(url));
        apiRequest.setVersion(this.APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Unlimited," + this.subscriptionTier5RPMburst + "," + this.subscriptionTier25RPMburst);
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("POST");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTO.setAuthType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        operations.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operations);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.APIName, this.APIVersion, "\"isApiExists\":true");
        HashMap requestHeaders = new HashMap();
        HttpResponse response = HttpRequestUtil.doGet((String)this.backendEP, requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
        this.applicationDTO = this.restAPIStore.addApplication(this.applicationName, "Unlimited", "", "this-is-test");
    }

    @Test(groups={"wso2.am"}, description="Test changing the burst limit of an API subscription by subscribing to a different subscription policy with different burst limit")
    public void testBurstLimitChange() throws Exception {
        SubscriptionDTO subscriptionDTO1 = this.restAPIStore.subscribeToAPI(this.apiId, this.applicationDTO.getApplicationId(), this.subscriptionTier5RPMburst);
        Assert.assertTrue((boolean)subscriptionDTO1.getThrottlingPolicy().equals(this.subscriptionTier5RPMburst), (String)("Error occurred while subscribing to the api. Subscribed policy is not as expected as " + this.subscriptionTier5RPMburst));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        String apiInvocationUrl = this.getAPIInvocationURLHttps(this.APIContext + "/" + this.APIVersion + "/");
        this.checkThrottling(apiInvocationUrl, requestHeaders, this.burstLimit1);
        this.log.info((Object)("Old subscription id:" + subscriptionDTO1.getSubscriptionId()));
        HttpResponse httpResponse = this.restAPIStore.removeSubscription(subscriptionDTO1);
        this.log.info((Object)("httpResponse of removeSubscription ====== : " + httpResponse));
        this.log.info((Object)("AAA= " + subscriptionDTO1));
        Thread.sleep(5000L);
        SubscriptionDTO subscriptionDTO2 = this.restAPIStore.subscribeToAPI(this.apiId, this.applicationDTO.getApplicationId(), this.subscriptionTier25RPMburst);
        Assert.assertTrue((boolean)subscriptionDTO2.getThrottlingPolicy().equals(this.subscriptionTier25RPMburst), (String)("Error occurred while subscribing to the api. Subscribed policy is not as expected as " + this.subscriptionTier25RPMburst));
        Thread.sleep(60000L);
        this.checkThrottling(apiInvocationUrl, requestHeaders, this.burstLimit2);
    }

    private void checkThrottling(String invokeURL, Map<String, String> requestHeaders, int limit) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        for (int count = 1; count < limit + 2; ++count) {
            HttpResponse apiCallResponse;
            if (count > limit) {
                boolean isThrottled = false;
                while (count < limit + 10) {
                    apiCallResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
                    if (apiCallResponse.getResponseCode() == 429) {
                        isThrottled = true;
                        break;
                    }
                    Thread.sleep(500L);
                    ++count;
                }
                Assert.assertTrue((boolean)isThrottled, (String)"Throttling has't happened at the expected count");
                continue;
            }
            apiCallResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
            if (apiCallResponse.getResponseCode() == 429) {
                Assert.fail((String)("Throttling has happened at the count : " + count + ". But expected to throttle after the request count " + limit));
                continue;
            }
            Assert.assertEquals((int)apiCallResponse.getResponseCode(), (int)200, (String)"API invocation Response code is not as expected");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationDTO.getApplicationId());
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO1.getPolicyId());
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subscriptionThrottlePolicyDTO2.getPolicyId());
        super.cleanUp();
    }
}

