/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTBandwidthThrottlingTestCase
extends APIMIntegrationBaseTest {
    private String appPolicyName = "AppPolicyWithBandwidth";
    private String subPolicyName = "SubPolicyWithBandwidth";
    private String apiPolicyName = "APIPolicyWithBandwidth";
    private String appPolicyId;
    private String subPolicyId;
    private String apiPolicyId;
    private String apiId;
    private String gatewayUrl;
    private String app1Id;
    private String app2Id;
    private String backendEP;
    private String body = "{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}";
    private String app3Id;
    private static final Log log = LogFactory.getLog(JWTBandwidthThrottlingTestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public JWTBandwidthThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String INTERNAL_EVERYONE = "Internal/everyone";
        ArrayList<String> roleList = new ArrayList<String>();
        BandwidthLimitDTO bandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)"min", (Integer)1, (Long)1L, (String)"KB");
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)bandwidthLimit);
        roleList.add(INTERNAL_EVERYONE);
        SubscriptionThrottlePolicyPermissionDTO permissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, roleList);
        ApplicationThrottlePolicyDTO bandwidthApplicationPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)this.appPolicyName, (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit);
        ApiResponse addedApplicationPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(bandwidthApplicationPolicyDTO);
        Assert.assertEquals((int)addedApplicationPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedApplicationPolicyDTO = (ApplicationThrottlePolicyDTO)addedApplicationPolicy.getData();
        this.appPolicyId = addedApplicationPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.appPolicyId, (String)"The policy ID cannot be null or empty");
        SubscriptionThrottlePolicyDTO bandwidthSubscriptionPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)this.subPolicyName, (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)-1, (int)-1, (int)100, (String)"min", new ArrayList(), (boolean)true, (String)"", (int)0, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse addedSubscriptionPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(bandwidthSubscriptionPolicyDTO);
        Assert.assertEquals((int)addedSubscriptionPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedSubscriptionPolicyDTO = (SubscriptionThrottlePolicyDTO)addedSubscriptionPolicy.getData();
        this.subPolicyId = addedSubscriptionPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.subPolicyId, (String)"The policy ID cannot be null or empty");
        AdvancedThrottlePolicyDTO bandwidthAdvancedPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)this.apiPolicyName, (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit, new ArrayList());
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(bandwidthAdvancedPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedAdvancedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        this.apiPolicyId = addedAdvancedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.apiPolicyId, (String)"The policy ID cannot be null or empty");
        this.backendEP = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        String APIName = "BandwidthTestAPI";
        String APIContext = "bandwithtestapi";
        String tags = "youtube, token, media";
        String url = this.backendEP;
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Unlimited," + this.subPolicyName);
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("POST");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTO.setAuthType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        operations.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operations);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), APIName, APIVersion, "\"isApiExists\":true");
        this.gatewayUrl = this.getAPIInvocationURLHttps(APIContext + "/" + APIVersion + "/");
        HashMap requestHeaders = new HashMap();
        HttpResponse response = HttpRequestUtil.doGet((String)this.backendEP, requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
    }

    @Test(groups={"wso2.am"}, description="")
    public void testApplicationLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("ApplicationBandwidthtestapp", this.appPolicyName, "", "this-is-test");
        this.app1Id = applicationDTO.getApplicationId();
        Assert.assertEquals((boolean)true, (boolean)applicationDTO.getThrottlingPolicy().equals(this.appPolicyName));
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Unlimited"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        JSONObject jwtObject = new JSONObject(jwtString);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in application tier");
    }

    @Test(groups={"wso2.am"}, description="")
    public void testSubscriptionLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("SubscriptionBandwidthtestapp", "Unlimited", "", "this-is-test");
        this.app2Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), this.subPolicyName);
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals(this.subPolicyName));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        JSONObject jwtObject = new JSONObject(jwtString);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in subscription tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testSubscriptionLevelThrottling", "testApplicationLevelThrottling"})
    public void testAPILevelThrottling() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy(this.apiPolicyName);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)this.apiPolicyName, (String)"API tier not updated.");
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("NormalAPP", "Unlimited", "", "this-is-test");
        this.app3Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Unlimited"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in api tier");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.app1Id);
        this.restAPIStore.deleteApplication(this.app2Id);
        this.restAPIStore.deleteApplication(this.app3Id);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.apiPolicyId);
        this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.appPolicyId);
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subPolicyId);
    }
}

