/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling.unlimitedDisable;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SettingsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ConfigurableDefaultPolicyTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(ConfigurableDefaultPolicyTestCase.class);
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_CONTEXT = "info";
    private final String GRAPHQL_API_NAME = "ConfigurableDefaultPolicyTestCaseGraphql";
    private final String END_POINT_URL = "https://localhost:9943/am-graphQL-sample/api/graphql/";
    private AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO;
    private String providerName;
    private String schemaDefinition;
    private String graphqlAPIId;
    private String restAPIId;
    private SubscriptionThrottlePolicyDTO defaultSubscriptionPolicy;
    private ApplicationThrottlePolicyDTO defaultApplicationThrottlePolicyDTO;
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private String tenantConfigBeforeTestCase;
    private String[] subscriberRole = new String[]{"Internal/subscriber"};

    @Factory(dataProvider="userModeDataProvider")
    public ConfigurableDefaultPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.providerName = this.user.getUserName();
        ThrottleLimitDTO defaultLimit = new ThrottleLimitDTO().type(ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT).requestCount(new RequestCountLimitDTO().requestCount(Long.valueOf(10L)).unitTime(Integer.valueOf(1)).timeUnit("min")).bandwidth(null);
        AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO = new AdvancedThrottlePolicyDTO();
        advancedThrottlePolicyDTO.setPolicyName("DefaultAPIPolicy");
        advancedThrottlePolicyDTO.setDefaultLimit(defaultLimit);
        ApiResponse advancedThrottlePolicyDTOApiResponse = this.restAPIAdmin.addAdvancedThrottlingPolicy(advancedThrottlePolicyDTO);
        Assert.assertEquals((int)advancedThrottlePolicyDTOApiResponse.getStatusCode(), (int)201);
        this.advancedThrottlePolicyDTO = (AdvancedThrottlePolicyDTO)advancedThrottlePolicyDTOApiResponse.getData();
        SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO = new SubscriptionThrottlePolicyDTO();
        subscriptionThrottlePolicyDTO.setPolicyName("DefaultSubscriptionLevelTier");
        subscriptionThrottlePolicyDTO.setDefaultLimit(defaultLimit);
        subscriptionThrottlePolicyDTO.setRateLimitCount(Integer.valueOf(10));
        subscriptionThrottlePolicyDTO.setRateLimitTimeUnit("sec");
        subscriptionThrottlePolicyDTO.setSubscriberCount(Integer.valueOf(10));
        subscriptionThrottlePolicyDTO.setBillingPlan("FREE");
        ApiResponse subscriptionThrottlePolicyDTOApiResponse = this.restAPIAdmin.addSubscriptionThrottlingPolicy(subscriptionThrottlePolicyDTO);
        Assert.assertEquals((int)subscriptionThrottlePolicyDTOApiResponse.getStatusCode(), (int)201);
        this.defaultSubscriptionPolicy = (SubscriptionThrottlePolicyDTO)subscriptionThrottlePolicyDTOApiResponse.getData();
        ApplicationThrottlePolicyDTO applicationThrottlePolicyDTO = new ApplicationThrottlePolicyDTO();
        applicationThrottlePolicyDTO.setPolicyName("DefaultApplicationLevelTier");
        applicationThrottlePolicyDTO.setDefaultLimit(defaultLimit);
        ApiResponse applicationThrottlePolicyDTOApiResponse = this.restAPIAdmin.addApplicationThrottlingPolicy(applicationThrottlePolicyDTO);
        Assert.assertEquals((int)applicationThrottlePolicyDTOApiResponse.getStatusCode(), (int)201);
        this.defaultApplicationThrottlePolicyDTO = (ApplicationThrottlePolicyDTO)applicationThrottlePolicyDTOApiResponse.getData();
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.tenantConfigBeforeTestCase = this.restAPIAdmin.getTenantConfig();
        JSONObject tenantConfigJson = (JSONObject)new JSONParser().parse(this.tenantConfigBeforeTestCase);
        tenantConfigJson.put((Object)"DefaultAPILevelTier", (Object)"DefaultAPIPolicy");
        tenantConfigJson.put((Object)"DefaultApplicationLevelTier", (Object)"DefaultApplicationLevelTier");
        tenantConfigJson.put((Object)"DefaultSubscriptionLevelTier", (Object)"DefaultSubscriptionLevelTier");
        this.restAPIAdmin.updateTenantConfig((Object)tenantConfigJson);
        this.userManagementClient.addUser("tenantConfigured", "tenantConfigured", this.subscriberRole, "default");
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.advancedThrottlePolicyDTO.getPolicyId());
            Assert.fail((String)"Default API Policy get deleted.");
        }
        catch (org.wso2.am.integration.clients.admin.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
        try {
            this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.defaultSubscriptionPolicy.getPolicyId());
            Assert.fail((String)"Default Subscription Policy get deleted.");
        }
        catch (org.wso2.am.integration.clients.admin.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
        try {
            this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.defaultApplicationThrottlePolicyDTO.getPolicyId());
            Assert.fail((String)"Default Application Policy get deleted.");
        }
        catch (org.wso2.am.integration.clients.admin.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Create graphQL API and see if the rate limiting is set to a policy other than Unlimited")
    public void testCreateGraphQLAPI() throws Exception {
        this.schemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "schema.graphql"), (String)"UTF-8");
        File file = this.getTempFileWithContent(this.schemaDefinition);
        GraphQLValidationResponseDTO responseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(file);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = responseApiDto.getGraphQLInfo();
        String arrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        JSONArray operations = new JSONArray(arrayToJson);
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        ArrayList policies = new ArrayList();
        org.json.JSONObject additionalPropertiesObj = new org.json.JSONObject();
        additionalPropertiesObj.put("name", (Object)"ConfigurableDefaultPolicyTestCaseGraphql");
        additionalPropertiesObj.put("context", (Object)"info");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        org.json.JSONObject url = new org.json.JSONObject();
        url.put("url", (Object)"https://localhost:9943/am-graphQL-sample/api/graphql/");
        org.json.JSONObject endpointConfig = new org.json.JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("operations", (Object)operations);
        String additionalProperties = additionalPropertiesObj.toString();
        APIDTO apidto = this.restAPIPublisher.importGraphqlSchemaDefinition(file, additionalProperties);
        this.graphqlAPIId = apidto.getId();
        List operationsList = apidto.getOperations();
        log.info((Object)("operationsList" + operationsList));
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlAPIId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode());
        Assert.assertTrue((boolean)((APIOperationsDTO)operationsList.get(0)).getThrottlingPolicy().equalsIgnoreCase("DefaultAPIPolicy"), (String)("Throttling policy " + ((APIOperationsDTO)operationsList.get(0)).getThrottlingPolicy() + " is applied"));
    }

    @Test(groups={"wso2.am"}, description="Create a REST API without x-throttling tier and check if API gets published successfully")
    public void createAPIwithThrottlingTierNull() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "unlimitedTier" + File.separator + "TestAPI.json";
        File definition = new File(swaggerPath);
        org.json.JSONObject endpoints = new org.json.JSONObject();
        endpoints.put("url", (Object)"http://testapi.com");
        org.json.JSONObject endpointConfig = new org.json.JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        org.json.JSONObject apiProperties = new org.json.JSONObject();
        apiProperties.put("name", (Object)"TestAPI");
        apiProperties.put("context", (Object)"/TestAPI");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.providerName);
        apiProperties.put("policies", tierList);
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        APIDTO restAPIDTO = this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
        this.restAPIId = restAPIDTO.getId();
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.restAPIId, false);
        APIDTO retrievedDto = this.restAPIPublisher.getAPIByID(this.restAPIId);
        Assert.assertNotNull((Object)retrievedDto);
        Assert.assertNotNull((Object)retrievedDto.getOperations());
        for (APIOperationsDTO operation : retrievedDto.getOperations()) {
            Assert.assertNotEquals((Object)operation.getThrottlingPolicy(), (Object)"Unlimited");
        }
        String retrievedSwagger = this.restAPIPublisher.getSwaggerByID(this.restAPIId);
        retrievedSwagger = this.restAPIPublisher.updateSwagger(this.restAPIId, retrievedSwagger);
        Assert.assertNotNull((Object)retrievedSwagger);
        this.validateThrottlingPolicy(retrievedSwagger);
        retrievedDto.getPolicies().add("Unlimited");
        try {
            this.restAPIPublisher.updateAPI(retrievedDto, this.restAPIId);
            Assert.fail((String)"API Update Successful with Unlimited Subscription Policy.");
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Unlimited"));
        }
    }

    @Test(groups={"wso2.am"}, description="Check Setting API not returning Unlimited Tier")
    public void verifySettingsRestAPIInPublisher() throws org.wso2.am.integration.clients.publisher.api.ApiException {
        SettingsDTO settings = this.restAPIPublisher.getSettings();
        Assert.assertEquals((String)settings.getDefaultAdvancePolicy(), (String)"DefaultAPIPolicy");
        Assert.assertEquals((String)settings.getDefaultSubscriptionPolicy(), (String)"DefaultSubscriptionLevelTier");
    }

    @Test(groups={"wso2.am"}, description="Check Setting API not returning Unlimited Tier")
    public void verifyDefaultApplicationCreatedThrottlePolicy() throws ApiException {
        RestAPIStoreImpl restAPIStore1 = this.userMode != TestUserMode.SUPER_TENANT_ADMIN ? new RestAPIStoreImpl("tenantConfigured", "tenantConfigured", "wso2.com", "https://localhost:9943/") : new RestAPIStoreImpl("tenantConfigured", "tenantConfigured", "carbon.super", "https://localhost:9943/");
        ApplicationListDTO defaultApplication = restAPIStore1.getApplications("DefaultApplication");
        Assert.assertNotNull((Object)defaultApplication);
        Assert.assertEquals((int)defaultApplication.getCount(), (int)1);
        ApplicationInfoDTO applicationInfoDTO = (ApplicationInfoDTO)defaultApplication.getList().get(0);
        Assert.assertEquals((String)applicationInfoDTO.getThrottlingPolicy(), (String)"DefaultApplicationLevelTier");
        restAPIStore1.deleteApplication(applicationInfoDTO.getApplicationId());
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        JSONObject tenantConfigBeforeTestCaseJson = (JSONObject)new JSONParser().parse(this.tenantConfigBeforeTestCase);
        this.restAPIAdmin.updateTenantConfig((Object)tenantConfigBeforeTestCaseJson);
        this.restAPIPublisher.deleteAPI(this.restAPIId);
        this.restAPIPublisher.deleteAPI(this.graphqlAPIId);
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.advancedThrottlePolicyDTO.getPolicyId());
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.defaultSubscriptionPolicy.getPolicyId());
        this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.defaultApplicationThrottlePolicyDTO.getPolicyId());
        super.cleanUp();
    }

    private void validateThrottlingPolicy(String swaggerContent) throws APIManagementException {
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult swaggerParseResult = parser.readContents(swaggerContent, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        Paths paths = openAPI.getPaths();
        for (String pathKey : paths.keySet()) {
            Map operationsMap = ((PathItem)paths.get((Object)pathKey)).readOperationsMap();
            for (Map.Entry entry : operationsMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                Map extensions = operation.getExtensions();
                Assert.assertNotNull(extensions.get("x-throttling-tier"));
                Assert.assertEquals(extensions.get("x-throttling-tier"), (Object)"DefaultAPIPolicy");
            }
        }
    }
}

