/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling.unlimitedDisable;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SettingsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class UnlimitedTierDisabledTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(UnlimitedTierDisabledTestCase.class);
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_CONTEXT = "info";
    private final String GRAPHQL_API_NAME = "CountriesGraphqlAPI";
    private static final String GRAPHQL_TEST_USER = "graphqluser";
    private static final String GRAPHQL_TEST_USER_PASSWORD = "graphqlUser";
    private static final String GRAPHQL_ROLE = "graphqlrole";
    private final String END_POINT_URL = "http://localhost:9943/am-graphQL-sample/api/graphql/";
    private String providerName;
    private String schemaDefinition;
    private String graphqlAPIId;
    private String restAPIId;

    @Factory(dataProvider="userModeDataProvider")
    public UnlimitedTierDisabledTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create graphQL API and see if the rate limiting is set to a policy other than Unlimited")
    public void testCreateGraphQLAPI() throws Exception {
        this.schemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "schema.graphql"), (String)"UTF-8");
        File file = this.getTempFileWithContent(this.schemaDefinition);
        GraphQLValidationResponseDTO responseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(file);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = responseApiDto.getGraphQLInfo();
        String arrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        JSONArray operations = new JSONArray(arrayToJson);
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        ArrayList policies = new ArrayList();
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"CountriesGraphqlAPI");
        additionalPropertiesObj.put("context", (Object)"info");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        JSONObject url = new JSONObject();
        url.put("url", (Object)"http://localhost:9943/am-graphQL-sample/api/graphql/");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("policies", policies);
        additionalPropertiesObj.put("operations", (Object)operations);
        String additionalProperties = additionalPropertiesObj.toString();
        APIDTO apidto = this.restAPIPublisher.importGraphqlSchemaDefinition(file, additionalProperties);
        this.graphqlAPIId = apidto.getId();
        List operationsList = apidto.getOperations();
        log.info((Object)("operationsList" + operationsList));
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlAPIId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode());
        Assert.assertFalse((boolean)((APIOperationsDTO)operationsList.get(0)).getThrottlingPolicy().equalsIgnoreCase("Unlimited"), (String)("Throttling policy " + ((APIOperationsDTO)operationsList.get(0)).getThrottlingPolicy() + " is applied"));
    }

    @Test(groups={"wso2.am"}, description="Create a REST API without x-throttling tier and check if API gets published successfully")
    public void createAPIwithThrottlingTierNull() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "unlimitedTier" + File.separator + "TestAPI.json";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"http://testapi.com");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"TestAPI");
        apiProperties.put("context", (Object)"/TestAPI");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.providerName);
        apiProperties.put("policies", tierList);
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        APIDTO restAPIDTO = this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
        this.restAPIId = restAPIDTO.getId();
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.restAPIId, false);
        APIDTO retrievedDto = this.restAPIPublisher.getAPIByID(this.restAPIId);
        Assert.assertNotNull((Object)retrievedDto);
        Assert.assertNotNull((Object)retrievedDto.getOperations());
        for (APIOperationsDTO operation : retrievedDto.getOperations()) {
            Assert.assertNotEquals((Object)operation.getThrottlingPolicy(), (Object)"Unlimited");
        }
        String retrievedSwagger = this.restAPIPublisher.getSwaggerByID(this.restAPIId);
        retrievedSwagger = this.restAPIPublisher.updateSwagger(this.restAPIId, retrievedSwagger);
        Assert.assertNotNull((Object)retrievedSwagger);
        this.validateThrottlingPolicyNotUnlimited(retrievedSwagger);
        retrievedDto.getPolicies().add("Unlimited");
        try {
            this.restAPIPublisher.updateAPI(retrievedDto, this.restAPIId);
            Assert.fail((String)"API Update Successful with Unlimited Subscription Policy.");
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Unlimited"));
        }
    }

    @Test(groups={"wso2.am"}, description="Create a REST API with x-throttling tier as Unlimited and check if API gets published successfully")
    public void createAPIwithThrottlingTierUnlimitedNegative1() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "unlimitedTier" + File.separator + "UnlimitedTierAvailableTestAPI.json";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"http://unlimitedtiertestapi.com");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"UnlimitedTierTestAPI");
        apiProperties.put("context", (Object)"/unlimitedtiertestapi");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.providerName);
        apiProperties.put("policies", tierList);
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        try {
            this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
            Assert.fail((String)"API Imported Successfully with Unlimited Tier");
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
            Assert.assertTrue((boolean)e.getResponseBody().contains(ExceptionCodes.TIER_NAME_INVALID.getErrorMessage()));
        }
    }

    @Test(groups={"wso2.am"}, description="Create Application with Application tier as Unlimited successfully.")
    public void createApplicationWithUnlimitedTierNegative2() {
        try {
            this.restAPIStore.createApplicationWithHttpInfo("UnlimitedNegativeApp", "", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
            Assert.fail((String)"Application created successfully with Unlimited Tier");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
            Assert.assertTrue((boolean)e.getResponseBody().contains(ExceptionCodes.TIER_NAME_INVALID.getErrorMessage()));
        }
    }

    @Test(groups={"wso2.am"}, description="Check Setting API not returning Unlimited Tier")
    public void verifySettingsRestAPIInPublisher() throws org.wso2.am.integration.clients.publisher.api.ApiException {
        SettingsDTO settings = this.restAPIPublisher.getSettings();
        Assert.assertNotEquals((Object)settings.getDefaultAdvancePolicy(), (Object)"Unlimited");
        Assert.assertNotEquals((Object)settings.getDefaultSubscriptionPolicy(), (Object)"Unlimited");
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.testDeleteApi(this.restAPIId);
        this.testDeleteApi(this.graphqlAPIId);
    }

    private void testDeleteApi(String apiId) throws Exception {
        if (apiId == null) {
            return;
        }
        this.restAPIPublisher.deleteAPI(apiId);
    }

    private void validateThrottlingPolicyNotUnlimited(String swaggerContent) throws APIManagementException {
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult swaggerParseResult = parser.readContents(swaggerContent, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        Paths paths = openAPI.getPaths();
        for (String pathKey : paths.keySet()) {
            Map operationsMap = ((PathItem)paths.get((Object)pathKey)).readOperationsMap();
            for (Map.Entry entry : operationsMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                Map extensions = operation.getExtensions();
                Assert.assertNotNull(extensions.get("x-throttling-tier"));
                Assert.assertNotEquals(extensions.get("x-throttling-tier"), (Object)"Unlimited");
            }
        }
    }
}

