/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class OpenIDTokenAPITestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String consumerSecret;
    private String userAccessToken;
    private String applicationId;

    @Factory(dataProvider="userModeDataProvider")
    public OpenIDTokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("OpenIDTokenTestAPIApplication", " Description", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.applicationId = applicationResponse.getData();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample")
    public void testGenerateAccessTokenWithOpenIdScope() throws Exception {
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=openid";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        this.userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String scope = accessTokenGenerationResponse.getString("scope");
        Assert.assertTrue((boolean)scope.contains("openid"), (String)"Response data mismatched, openid scope test failed due to error in response");
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample", dependsOnMethods={"testGenerateAccessTokenWithOpenIdScope"})
    public void testCallUserInfoApiWithOpenIdAccessToken() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)this.userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        HttpResponse userInfoResponse = HTTPSClientUtils.doGet((String)(this.keyManagerHTTPSURL + "oauth2/userinfo?schema=openid"), requestHeaders);
        Assert.assertEquals((int)userInfoResponse.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample", dependsOnMethods={"testCallUserInfoApiWithOpenIdAccessToken"})
    public void testCallUserInfoApiWithOpenIdJWTAccessToken() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.userAccessToken);
        String keyManagerURLSuffix = "oauth2/userinfo?schema=openid";
        String tenantDomain = this.user.getUserDomain();
        if (!StringUtils.equals((String)tenantDomain, (String)"carbon.super")) {
            keyManagerURLSuffix = "t/" + tenantDomain + "/" + keyManagerURLSuffix;
        }
        HttpResponse userInfoResponse = HTTPSClientUtils.doGet((String)(this.keyManagerHTTPSURL + keyManagerURLSuffix), requestHeaders);
        Assert.assertEquals((int)userInfoResponse.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }
}

