/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(TokenAPITestCase.class);
    private String apiId;
    private String appId;
    private String oauthTokenTestAppId;
    private String infiniteTokenTestAppId;
    private String gatewayUrl;
    private String consumerKey;
    private String consumerSecret;

    @Factory(dataProvider="userModeDataProvider")
    public TokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String APIName = "TokenTestAPI";
        String APIContext = "tokenTestAPI";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        this.gatewayUrl = this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/customers/123");
    }

    @Test(groups={"wso2.am"}, description="Token API Test other")
    public void testTokenAPITestCase() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("TokenTestAPI-Application", "Unlimited", "", "this-is-test");
        this.appId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        grantTypes.add("refresh_token");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String sandboxAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + sandboxAccessToken);
        requestHeadersSandBox.put("accept", "text/xml");
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)200, (String)"Response code mismatched");
        ApplicationKeyDTO productionApplicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = productionApplicationKeyDTO.getToken().getAccessToken();
        this.consumerKey = productionApplicationKeyDTO.getConsumerKey();
        this.consumerSecret = productionApplicationKeyDTO.getConsumerSecret();
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        HttpResponse httpAccessTokenGenerationResponse = this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpAccessTokenGenerationResponse.getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        HttpResponse youTubeResponseWithApplicationToken = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponseWithApplicationToken.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<Customer>"), (String)"Response data mismatched");
        HttpResponse youTubeResponseWithApplicationTokenHttps = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        log.info((Object)("Response " + youTubeResponseWithApplicationTokenHttps));
        Assert.assertEquals((int)youTubeResponseWithApplicationTokenHttps.getResponseCode(), (int)200, (String)"Response code mismatched");
        HttpResponse errorResponse = null;
        errorResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        log.info((Object)("Error response " + errorResponse));
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer this-is-incorrect-token");
        requestHeaders.put("accept", "text/xml");
        errorResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
        try {
            errorResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/most_popular"), requestHeaders);
            log.info((Object)("Error Response " + errorResponse));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
    }

    @Test(groups={"wso2.am"}, description="Test Refresh token functionality", dependsOnMethods={"testTokenAPITestCase"})
    public void testRefreshTokenAPITestCase() throws Exception {
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        requestHeaders.put("accept", "text/xml");
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        String getAccessTokenFromRefreshTokenRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, getAccessTokenFromRefreshTokenRequestBody, tokenEndpointURL).getData());
        userAccessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        tokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        requestHeaders.put("accept", "text/xml");
        httpResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
    }

    @Test(groups={"wso2.am"}, description="Oauth Token API Test other", dependsOnMethods={"testRefreshTokenAPITestCase"})
    public void testOauthTokenAPITestCase() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("oauthTokenTestAPI-Application", "Unlimited", "", "this-is-test", "OAUTH");
        this.oauthTokenTestAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.oauthTokenTestAppId, "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.oauthTokenTestAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String sandboxAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        String sandTokenJti = TokenUtils.getJtiOfJwtToken((String)sandboxAccessToken);
        requestHeadersSandBox.put("Authorization", "Bearer " + sandTokenJti);
        requestHeadersSandBox.put("accept", "text/xml");
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)200, (String)"Response code mismatched");
        ApplicationKeyDTO productionApplicationKeyDTO = this.restAPIStore.generateKeys(this.oauthTokenTestAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String consumerKey = productionApplicationKeyDTO.getConsumerKey();
        String consumerSecret = productionApplicationKeyDTO.getConsumerSecret();
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        HttpResponse httpAccessTokenGenerationResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpAccessTokenGenerationResponse.getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String accessTokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + accessTokenJti);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
    }

    @Test(groups={"wso2.am"}, description="Infinite Token API Test other", dependsOnMethods={"testOauthTokenAPITestCase"})
    public void testInfiniteTokenAPITestCase() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("infiniteTokenTestAPI-Application", "Unlimited", "", "test app for Infinite Token API invocation", "JWT");
        this.infiniteTokenTestAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.infiniteTokenTestAppId, "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("application_access_token_expiry_time", "-1");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        try {
            ApiResponse apiResponse = this.restAPIStore.generateKeysWithApiResponse(this.infiniteTokenTestAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes, additionalProperties, null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
            ErrorDTO errorDTO = (ErrorDTO)new Gson().fromJson(e.getResponseBody(), ErrorDTO.class);
            Assert.assertEquals((long)errorDTO.getCode(), (long)900970L);
            Assert.assertEquals((String)errorDTO.getMessage(), (String)"Invalid application additional properties");
            Assert.assertTrue((boolean)errorDTO.getDescription().contains("Application configuration values cannot have negative values"));
        }
        additionalProperties.put("application_access_token_expiry_time", String.valueOf(Long.MAX_VALUE));
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.infiniteTokenTestAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes, additionalProperties, null);
        String sandboxAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + sandboxAccessToken);
        requestHeadersSandBox.put("accept", "text/xml");
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)200, (String)"Response code mismatched");
        applicationKeyDTO = this.restAPIStore.generateKeys(this.infiniteTokenTestAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes, additionalProperties, null);
        String productionAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersProduction = new HashMap<String, String>();
        requestHeadersProduction.put("Authorization", "Bearer " + productionAccessToken);
        requestHeadersProduction.put("accept", "text/xml");
        HttpResponse youTubeResponseProduction = HttpRequestUtil.doGet((String)this.gatewayUrl, requestHeadersProduction);
        log.info((Object)("Response " + youTubeResponseProduction));
        Assert.assertEquals((int)youTubeResponseProduction.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.appId);
        this.restAPIStore.deleteApplication(this.oauthTokenTestAppId);
        this.restAPIStore.deleteApplication(this.infiniteTokenTestAppId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

