/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM366PublishNewCopyGivenDeprecateOldVersionTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM366DeprecateTestAPI";
    private final String apiVersionOld = "1.0.0";
    private final String apiVersionNew = "1.0.1";
    private final String applicationName = "APIM366DeprecateAPI";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerNameApi;
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierStoreOldVersion;
    private APIIdentifier apiIdentifierStoreNewVersion;

    @Factory(dataProvider="userModeDataProvider")
    public APIM366PublishNewCopyGivenDeprecateOldVersionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiEndpointPostfixUrlJaxrs = "jaxrs_basic/services/customers/customerservice/customers/123";
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiEndpointPostfixUrlJaxrs;
        this.providerNameApi = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierStoreOldVersion = new APIIdentifier(this.providerNameApi, "APIM366DeprecateTestAPI", "1.0.0");
        this.apiIdentifierStoreNewVersion = new APIIdentifier(this.providerNameApi, "APIM366DeprecateTestAPI", "1.0.1");
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy for the  given deprecate old versions option")
    public void testPublishNewCopyGivenDeprecateOldVersion() throws Exception {
        String apiContext = "apim366deprecateTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag366-1, tag366-2, tag366-3";
        String defaultVersion = "default_version";
        String apiResponse = "<Customer><id>123</id><name>John</name></Customer>";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM366DeprecateTestAPI", apiContext, "1.0.0", this.providerNameApi, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setDefault_version(defaultVersion);
        apiCreationRequestBean.setDefaultVersionChecked(defaultVersion);
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject jsonObjectCreation = new JSONObject(apiCreationResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCreation.getBoolean("error"), (String)"APIM366DeprecateTestAPI is not created");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM366DeprecateTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"APIM366DeprecateTestAPI has not been created in publisher");
        HttpResponse appResponse = this.apiStore.addApplication("APIM366DeprecateAPI", "Gold", "", "");
        JSONObject appJsonObject = new JSONObject(appResponse.getData());
        Assert.assertFalse((boolean)appJsonObject.getBoolean("error"), (String)"APIM366DeprecateAPI is not created in Store");
        Assert.assertEquals((String)appJsonObject.getString("status"), (String)"APPROVED", (String)"APIM366DeprecateAPI is not created in Store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM366DeprecateTestAPI", this.providerNameApi);
        subscriptionRequest.setApplicationName("APIM366DeprecateAPI");
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM366DeprecateTestAPI has not been subscribed");
        JSONObject jsonObjectCopy = new JSONObject(this.apiPublisher.copyAPI(this.providerNameApi, "APIM366DeprecateTestAPI", "1.0.0", "1.0.1", defaultVersion).getData());
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)"APIM366DeprecateTestAPI is not copied");
        APILifeCycleStateRequest lifeCycleStateRequest = new APILifeCycleStateRequest("APIM366DeprecateTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        lifeCycleStateRequest.setVersion("1.0.1");
        lifeCycleStateRequest.setDeprecateOldVersions("true");
        this.apiPublisher.changeAPILifeCycleStatus(lifeCycleStateRequest);
        HttpResponse originalApiResponse = this.apiPublisher.getAPI("APIM366DeprecateTestAPI", this.providerNameApi, "1.0.0");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("1.0.0"), (String)"Version of the originalAPIM366DeprecateTestAPI has been updated with new version");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("DEPRECATED"), (String)"Status of the API has not been changed as DEPRECATED");
        HttpResponse newApiResponse = this.apiPublisher.getAPI("APIM366DeprecateTestAPI", this.providerNameApi, "1.0.1");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("1.0.1"), (String)"Version of the Copied API has not been updated with the new version");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("PUBLISHED"), (String)"Status of the API has not been changed as PUBLISHED");
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreNewVersion, (List)publishedAPIList), (String)"API with the new Version is not available in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreOldVersion, (List)publishedAPIList), (String)"API with the Old Version is available in store");
        JSONObject subscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs("APIM366DeprecateAPI").getData()).getJSONObject("subscriptions");
        JSONArray jsonArray = subscribedApi.getJSONArray("applications");
        JSONObject jsonObjectDepApi = (JSONObject)jsonArray.get(0);
        JSONArray jsonArrayApiList = jsonObjectDepApi.getJSONArray("subscriptions");
        JSONObject deprecateApi = (JSONObject)jsonArrayApiList.get(0);
        Assert.assertEquals((String)deprecateApi.getString("status"), (String)"DEPRECATED", (String)"Invalid Status of the Deprecated API");
        Assert.assertEquals((String)deprecateApi.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Deprecated API");
        Assert.assertEquals((String)deprecateApi.getString("name"), (String)"APIM366DeprecateTestAPI", (String)"Invalid name of the Deprecated API");
        JSONObject publishApi = (JSONObject)jsonArrayApiList.get(1);
        Assert.assertEquals((String)publishApi.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Published API");
        Assert.assertEquals((String)publishApi.getString("version"), (String)"1.0.1", (String)"Invalid Version of the Published API");
        Assert.assertEquals((String)publishApi.getString("name"), (String)"APIM366DeprecateTestAPI", (String)"Invalid name of the Published API");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator("APIM366DeprecateAPI");
        String response = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(response);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(4000L);
        HttpResponse oldApiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0"), requestHeaders);
        Assert.assertEquals((int)oldApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when old version of the api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains(apiResponse), (String)"Response data mismatched when old version of the api invocation for GET Request");
        Thread.sleep(5000L);
        HttpResponse newVersionApiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1"), requestHeaders);
        Assert.assertEquals((int)newVersionApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when new version of the api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains(apiResponse), (String)"Response data mismatched when new version of the api invocation for GET Request");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM366DeprecateTestAPI", "1.0.0", this.providerNameApi, "APIM366DeprecateAPI");
        this.apiStore.removeAPISubscriptionByName("APIM366DeprecateTestAPI", "1.0.1", this.providerNameApi, "APIM366DeprecateAPI");
        this.apiStore.removeApplication("APIM366DeprecateAPI");
        this.apiPublisher.deleteAPI("APIM366DeprecateTestAPI", "1.0.0", this.providerNameApi);
        this.apiPublisher.deleteAPI("APIM366DeprecateTestAPI", "1.0.1", this.providerNameApi);
        super.cleanUp();
    }
}

