/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM370PublishNewCopyGivenRequireReSubscriptionTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM370ReSubscriptionTestAPI";
    private final String apiVersionOld = "1.0.0";
    private final String apiVersionNew = "1.0.1";
    private final String applicationName = "APIM370ReSubscriptionAPI";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerNameApi;
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierStoreOldVersion;
    private APIIdentifier apiIdentifierStoreNewVersion;

    @Factory(dataProvider="userModeDataProvider")
    public APIM370PublishNewCopyGivenRequireReSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiEndpointPostfixUrl;
        this.providerNameApi = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierStoreOldVersion = new APIIdentifier(this.providerNameApi, "APIM370ReSubscriptionTestAPI", "1.0.0");
        this.apiIdentifierStoreNewVersion = new APIIdentifier(this.providerNameApi, "APIM370ReSubscriptionTestAPI", "1.0.1");
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy with the  given Require Re-Subscription option")
    public void testPublishNewCopyGivenRequireReSubscription() throws Exception {
        String apiContext = "apim370ReSubscriptionTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag370-1, tag370-2, tag370-3";
        String defaultVersion = "default_version";
        String apiLimit = "5";
        String superUser = "carbon.super";
        String apiInvokeResponse = "<Customer><id>123</id><name>John</name></Customer>";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM370ReSubscriptionTestAPI", apiContext, "1.0.0", this.providerNameApi, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setDefault_version(defaultVersion);
        apiCreationRequestBean.setDefaultVersionChecked(defaultVersion);
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject jsonObjectCreation = new JSONObject(apiCreationResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCreation.getBoolean("error"), (String)"APIM370ReSubscriptionTestAPIis not created");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM370ReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"APIM370ReSubscriptionTestAPI has not been created in publisher");
        HttpResponse appResponse = this.apiStore.addApplication("APIM370ReSubscriptionAPI", "Gold", "", "");
        JSONObject appJsonObject = new JSONObject(appResponse.getData());
        Assert.assertFalse((boolean)appJsonObject.getBoolean("error"), (String)"APIM370ReSubscriptionAPI is not created in Store");
        Assert.assertEquals((String)appJsonObject.getString("status"), (String)"APPROVED", (String)"APIM370ReSubscriptionAPI is not created in Store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM370ReSubscriptionTestAPI", this.providerNameApi);
        subscriptionRequest.setApplicationName("APIM370ReSubscriptionAPI");
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM370ReSubscriptionTestAPIAPI has not been subscribed");
        HttpResponse copyApiResponse = this.apiPublisher.copyAPI(this.providerNameApi, "APIM370ReSubscriptionTestAPI", "1.0.0", "1.0.1", defaultVersion);
        JSONObject jsonObjectCopy = new JSONObject(copyApiResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)"APIM370ReSubscriptionTestAPI is not copied");
        APILifeCycleStateRequest lifeCycleStateRequest = new APILifeCycleStateRequest("APIM370ReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        lifeCycleStateRequest.setVersion("1.0.1");
        lifeCycleStateRequest.setRequireResubscription("true");
        HttpResponse statusResponse = this.apiPublisher.changeAPILifeCycleStatus(lifeCycleStateRequest);
        Assert.assertTrue((boolean)statusResponse.getData().contains("PUBLISHED"), (String)"New Copy of the APIM370ReSubscriptionTestAPI is not published");
        Thread.sleep(12000L);
        List recentlyAddedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getRecentlyAddedAPIs(superUser, apiLimit));
        Thread.sleep(4000L);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreNewVersion, (List)recentlyAddedAPIList), (String)"New Copy of the APIM370ReSubscriptionTestAPI is not available under Recently added API in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreOldVersion, (List)recentlyAddedAPIList), (String)"OriginalAPIM370ReSubscriptionTestAPI is available under Recently Added Api in store");
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreNewVersion, (List)publishedAPIList), (String)"New Copy of the APIM370ReSubscriptionTestAPI is not available in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreOldVersion, (List)publishedAPIList), (String)"OriginalAPIM370ReSubscriptionTestAPI is available in store");
        JSONObject subscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs("APIM370ReSubscriptionAPI").getData()).getJSONObject("subscriptions");
        JSONArray jsonArray = subscribedApi.getJSONArray("applications");
        JSONObject jsonObjectDepApi = (JSONObject)jsonArray.get(0);
        JSONArray jsonArrayApiList = jsonObjectDepApi.getJSONArray("subscriptions");
        JSONObject jsonObjectNewCopyApi = (JSONObject)jsonArrayApiList.get(0);
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Original APIM370ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Original APIM370ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("name"), (String)"APIM370ReSubscriptionTestAPI", (String)"Invalid name of the Original APIM370ReSubscriptionTestAPI");
        Assert.assertFalse((boolean)jsonObjectNewCopyApi.getString("version").contains("1.0.1"), (String)"New Copy of the APIM370ReSubscriptionTestAPI is visible under Subscribed API");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator("APIM370ReSubscriptionAPI");
        String response = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(response);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(3000L);
        HttpResponse oldApiResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + "1.0.0"), requestHeaders);
        Assert.assertEquals((int)oldApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains(apiInvokeResponse), (String)"Response data mismatched when api invocation for GET Request");
        Thread.sleep(4000L);
        HttpResponse newApiResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + "1.0.1"), requestHeaders);
        Assert.assertEquals((int)newApiResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when invalid api invocation");
        SubscriptionRequest ReSubscriptionRequest = new SubscriptionRequest("APIM370ReSubscriptionTestAPI", this.providerNameApi);
        ReSubscriptionRequest.setApplicationName("APIM370ReSubscriptionAPI");
        ReSubscriptionRequest.setVersion("1.0.1");
        this.apiStore.subscribe(ReSubscriptionRequest);
        JSONObject ReSubscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs("APIM370ReSubscriptionAPI").getData()).getJSONObject("subscriptions");
        JSONArray jsonArraySub = ReSubscribedApi.getJSONArray("applications");
        JSONObject jsonObjectReSub = (JSONObject)jsonArraySub.get(0);
        JSONArray jsonArrayReSub = jsonObjectReSub.getJSONArray("subscriptions");
        JSONObject jsonObjectReSubCopy = (JSONObject)jsonArrayReSub.get(1);
        Assert.assertEquals((String)jsonObjectReSubCopy.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Original API APIM370ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectReSubCopy.getString("version"), (String)"1.0.1", (String)"Invalid Version of the Original API");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("name"), (String)"APIM370ReSubscriptionTestAPI", (String)"Invalid name of the Original APIM370ReSubscriptionTestAPI");
        JSONObject jsonObjectReSubOldCopy = (JSONObject)jsonArrayReSub.get(0);
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Original APIM370ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Original APIM370ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("name"), (String)"APIM370ReSubscriptionTestAPI", (String)"Invalid name of the Original APIM370ReSubscriptionTestAPI");
        HttpResponse newVersionApiResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + "1.0.1"), requestHeaders);
        Assert.assertEquals((int)newVersionApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)newVersionApiResponse.getData().contains(apiInvokeResponse), (String)"Response data mismatched when api invocation for GET Request");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM370ReSubscriptionTestAPI", "1.0.0", this.providerNameApi, "APIM370ReSubscriptionAPI");
        this.apiStore.removeAPISubscriptionByName("APIM370ReSubscriptionTestAPI", "1.0.1", this.providerNameApi, "APIM370ReSubscriptionAPI");
        this.apiStore.removeApplication("APIM370ReSubscriptionAPI");
        this.apiPublisher.deleteAPI("APIM370ReSubscriptionTestAPI", "1.0.0", this.providerNameApi);
        this.apiPublisher.deleteAPI("APIM370ReSubscriptionTestAPI", "1.0.1", this.providerNameApi);
        super.cleanUp();
    }
}

