/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM371PublishNewCopyGivenDeprecateOldVersionAndRequireReSubscriptionTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM371DeprecateReSubscriptionTestAPI";
    private final String apiVersionOld = "1.0.0";
    private final String apiVersionNew = "1.0.1";
    private final String applicationName = "APIM371DeprecateReSubscriptionAPI";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerNameApi;
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierStoreOldVersion;
    private APIIdentifier apiIdentifierStoreNewVersion;

    @Factory(dataProvider="userModeDataProvider")
    public APIM371PublishNewCopyGivenDeprecateOldVersionAndRequireReSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiEndpointPostfixUrl;
        this.providerNameApi = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierStoreOldVersion = new APIIdentifier(this.providerNameApi, "APIM371DeprecateReSubscriptionTestAPI", "1.0.0");
        this.apiIdentifierStoreNewVersion = new APIIdentifier(this.providerNameApi, "APIM371DeprecateReSubscriptionTestAPI", "1.0.1");
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy for the  given Deprecate Old Version And Require Re-Subscription option")
    public void testPublishNewCopyGivenDeprecateAndRequireReSubscription() throws Exception {
        String apiContext = "apim371DeprecateReSubscriptionTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag371-1, tag371-2, tag371-3";
        String defaultVersion = "default_version";
        String apiLimit = "5";
        String superUser = "carbon.super";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM371DeprecateReSubscriptionTestAPI", apiContext, "1.0.0", this.providerNameApi, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setDefault_version(defaultVersion);
        apiCreationRequestBean.setDefaultVersionChecked(defaultVersion);
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject jsonObjectCreation = new JSONObject(apiCreationResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCreation.getBoolean("error"), (String)"APIM371DeprecateReSubscriptionTestAPIis not created");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"APIM371DeprecateReSubscriptionTestAPI has not been created in publisher");
        HttpResponse appResponse = this.apiStore.addApplication("APIM371DeprecateReSubscriptionAPI", "Gold", "", "");
        JSONObject appJsonObject = new JSONObject(appResponse.getData());
        Assert.assertFalse((boolean)appJsonObject.getBoolean("error"), (String)"APIM371DeprecateReSubscriptionAPI is not created in Store");
        Assert.assertEquals((String)appJsonObject.getString("status"), (String)"APPROVED", (String)"APIM371DeprecateReSubscriptionAPI is not created in Store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi);
        subscriptionRequest.setApplicationName("APIM371DeprecateReSubscriptionAPI");
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM371DeprecateReSubscriptionTestAPI has not been subscribed");
        HttpResponse copyApiResponse = this.apiPublisher.copyAPI(this.providerNameApi, "APIM371DeprecateReSubscriptionTestAPI", "1.0.0", "1.0.1", defaultVersion);
        JSONObject jsonObjectCopy = new JSONObject(copyApiResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)"APIM371DeprecateReSubscriptionTestAPI is not copied");
        APILifeCycleStateRequest lifeCycleStateRequest = new APILifeCycleStateRequest("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        lifeCycleStateRequest.setVersion("1.0.1");
        lifeCycleStateRequest.setDeprecateOldVersions("true");
        lifeCycleStateRequest.setRequireResubscription("true");
        this.apiPublisher.changeAPILifeCycleStatus(lifeCycleStateRequest);
        HttpResponse originalApiResponse = this.apiPublisher.getAPI("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi, "1.0.0");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("1.0.0"), (String)"Version of the original APIM371DeprecateReSubscriptionTestAPI has been updated with new version");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("DEPRECATED"), (String)"Status of the original  APIM371DeprecateReSubscriptionTestAPI has not been changed as DEPRECATED");
        HttpResponse newApiResponse = this.apiPublisher.getAPI("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi, "1.0.1");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("1.0.1"), (String)"Version of the Copied APIM371DeprecateReSubscriptionTestAPI has not been updated with the new version");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("PUBLISHED"), (String)"Status of the copied APIM371DeprecateReSubscriptionTestAPI has not been changed as PUBLISHED");
        Thread.sleep(14000L);
        List recentlyAddedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getRecentlyAddedAPIs(superUser, apiLimit));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreNewVersion, (List)recentlyAddedAPIList), (String)"New Copy of the APIM371DeprecateReSubscriptionTestAPI is not available as a Recently added API in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreOldVersion, (List)recentlyAddedAPIList), (String)"Original APIM371DeprecateReSubscriptionTestAPI is available as a Recently Added Api in store");
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreNewVersion, (List)publishedAPIList), (String)"New Copy of the APIM371DeprecateReSubscriptionTestAPI is not available under API in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierStoreOldVersion, (List)publishedAPIList), (String)"Original APIM371DeprecateReSubscriptionTestAPI is available under API in store");
        JSONObject subscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs("APIM371DeprecateReSubscriptionAPI").getData()).getJSONObject("subscriptions");
        JSONArray jsonArray = subscribedApi.getJSONArray("applications");
        JSONObject jsonObjectDepApi = (JSONObject)jsonArray.get(0);
        JSONArray jsonArrayApiList = jsonObjectDepApi.getJSONArray("subscriptions");
        JSONObject deprecateApi = (JSONObject)jsonArrayApiList.get(0);
        Assert.assertEquals((String)deprecateApi.getString("status"), (String)"DEPRECATED", (String)"Invalid Status of the Deprecated APIM371DeprecateReSubscriptionTestAPI");
        Assert.assertEquals((String)deprecateApi.getString("version"), (String)"1.0.0", (String)"Invalid Version of the DeprecatedAPIM371DeprecateReSubscriptionTestAPI");
        Assert.assertEquals((String)deprecateApi.getString("name"), (String)"APIM371DeprecateReSubscriptionTestAPI", (String)"Invalid name of the Deprecated APIM371DeprecateReSubscriptionTestAPI");
        Assert.assertFalse((boolean)deprecateApi.getString("version").contains("1.0.1"), (String)"New Copy of theAPIM371DeprecateReSubscriptionTestAPI is visible under Subscribed API");
        SubscriptionRequest ReSubscriptionRequest = new SubscriptionRequest("APIM371DeprecateReSubscriptionTestAPI", this.providerNameApi);
        ReSubscriptionRequest.setApplicationName("APIM371DeprecateReSubscriptionAPI");
        ReSubscriptionRequest.setVersion("1.0.1");
        HttpResponse ReSubscriptionResponse = this.apiStore.subscribe(ReSubscriptionRequest);
        Assert.assertEquals((int)ReSubscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"ReSubscription API has not been subscribed");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator("APIM371DeprecateReSubscriptionAPI");
        String response = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(response);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(3000L);
        HttpResponse oldApiResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + "1.0.0"), requestHeaders);
        Assert.assertEquals((int)oldApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains("<Customer><id>123</id><name>John</name></Customer>"), (String)"Response data mismatched when api invocation for GET Request");
        Thread.sleep(3000L);
        HttpResponse newVersionApiResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + "1.0.1"), requestHeaders);
        Assert.assertEquals((int)newVersionApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains("<Customer><id>123</id><name>John</name></Customer>"), (String)"Response data mismatched when api invocation for GET Request");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM371DeprecateReSubscriptionTestAPI", "1.0.0", this.providerNameApi, "APIM371DeprecateReSubscriptionAPI");
        this.apiStore.removeAPISubscriptionByName("APIM371DeprecateReSubscriptionTestAPI", "1.0.1", this.providerNameApi, "APIM371DeprecateReSubscriptionAPI");
        this.apiStore.removeApplication("APIM371DeprecateReSubscriptionAPI");
        this.apiPublisher.deleteAPI("APIM371DeprecateReSubscriptionTestAPI", "1.0.0", this.providerNameApi);
        this.apiPublisher.deleteAPI("APIM371DeprecateReSubscriptionTestAPI", "1.0.1", this.providerNameApi);
        super.cleanUp();
    }
}

