/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM373PublishNewCopyGivenRequireReSubscriptionTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM373ReSubscriptionTestAPI";
    private final String apiVersionOld = "1.0.0";
    private final String apiVersionNew = "1.0.1";
    private String applicationName = "APIM373ReSubscriptionAPI";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerNameApi;
    private String apiProductionEndPointUrl;
    private String apiSandBoxEndPointUrl;
    private APIIdentifier apiIdentifierOldVersion;
    private APIIdentifier apiIdentifierNewVersion;
    private HashMap<String, String> requestHeadersGet;
    private HashMap<String, String> requestHeadersPost;
    private HashMap<String, String> requestHeadersPut;
    private HashMap<String, String> requestHeadersDelete;

    @Factory(dataProvider="userModeDataProvider")
    public APIM373PublishNewCopyGivenRequireReSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String sessionId = this.createSession(this.gatewayContextWrk);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/";
        String apiSandBoxEndpointPostfixUrl = "name-check1/";
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiSandBoxEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiSandBoxEndpointPostfixUrl;
        this.providerNameApi = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierOldVersion = new APIIdentifier(this.providerNameApi, "APIM373ReSubscriptionTestAPI", "1.0.0");
        this.apiIdentifierNewVersion = new APIIdentifier(this.providerNameApi, "APIM373ReSubscriptionTestAPI", "1.0.1");
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.requestHeadersPost = new HashMap();
        this.requestHeadersPost.put("accept", "text/xml");
        this.requestHeadersPost.put("Content-Type", "text/xml");
        this.requestHeadersPut = new HashMap();
        this.requestHeadersPut.put("accept", "text/xml");
        this.requestHeadersPut.put("Content-Type", "text/xml");
        this.requestHeadersDelete = new HashMap();
        this.requestHeadersDelete.put("accept", "text/xml");
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy for the  given Require Re-Subscription option")
    public void testPublishNewCopyGivenRequireReSubscription() throws Exception {
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        String apiContext = "apim373ReSubscriptionTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag373-1, tag373-2, tag373-3";
        String defaultVersion = "default_version";
        String apiLimit = "5";
        String superUser = "carbon.super";
        String apiResponse = "<Customer><id>123</id><name>John</name></Customer>";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM373ReSubscriptionTestAPI", apiContext, "1.0.0", this.providerNameApi, new URL(this.apiProductionEndPointUrl), new URL(this.apiSandBoxEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setDefault_version(defaultVersion);
        apiCreationRequestBean.setDefaultVersionChecked(defaultVersion);
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("PUT", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("DELETE", "Application & Application User", "Unlimited", "/*"));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject jsonObjectCreation = new JSONObject(apiCreationResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCreation.getBoolean("error"), (String)"APIM373ReSubscriptionTestAPIis not created");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM373ReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"API has not been created in publisher");
        HttpResponse appResponse = this.apiStore.addApplication(this.applicationName, "Gold", "", "");
        JSONObject appJsonObject = new JSONObject(appResponse.getData());
        Assert.assertFalse((boolean)appJsonObject.getBoolean("error"), (String)(this.applicationName + " is not created in Store"));
        Assert.assertEquals((String)appJsonObject.getString("status"), (String)"APPROVED", (String)(this.applicationName + " is not created in Store"));
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM373ReSubscriptionTestAPI", this.providerNameApi);
        subscriptionRequest.setApplicationName(this.applicationName);
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM373ReSubscriptionTestAPI has not been subscribed");
        HttpResponse copyApiResponse = this.apiPublisher.copyAPI(this.providerNameApi, "APIM373ReSubscriptionTestAPI", "1.0.0", "1.0.1", defaultVersion);
        JSONObject jsonObjectCopy = new JSONObject(copyApiResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)"APIM373ReSubscriptionTestAPI is not copied");
        APILifeCycleStateRequest lifeCycleStateRequest = new APILifeCycleStateRequest("APIM373ReSubscriptionTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        lifeCycleStateRequest.setVersion("1.0.1");
        lifeCycleStateRequest.setRequireResubscription("true");
        HttpResponse statusResponse = this.apiPublisher.changeAPILifeCycleStatus(lifeCycleStateRequest);
        Assert.assertTrue((boolean)statusResponse.getData().contains("PUBLISHED"), (String)"New Copy of the APIM373ReSubscriptionTestAPI is not published");
        Thread.sleep(15000L);
        List recentlyAddedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getRecentlyAddedAPIs(superUser, apiLimit));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierNewVersion, (List)recentlyAddedAPIList), (String)"New Copy of the APIM373ReSubscriptionTestAPI is not available under Recently added API in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierOldVersion, (List)recentlyAddedAPIList), (String)"Original version of the APIM373ReSubscriptionTestAPI is available under Recently Added Api in store");
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierNewVersion, (List)publishedAPIList), (String)"New Copy of theAPIM373ReSubscriptionTestAPIis not available in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierOldVersion, (List)publishedAPIList), (String)"OriginalAPIM373ReSubscriptionTestAPI is available in store");
        JSONObject subscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs(this.applicationName).getData()).getJSONObject("subscriptions");
        JSONArray jsonArray = subscribedApi.getJSONArray("applications");
        JSONObject jsonObjectDepApi = (JSONObject)jsonArray.get(0);
        JSONArray jsonArrayApiList = jsonObjectDepApi.getJSONArray("subscriptions");
        JSONObject jsonObjectNewCopyApi = (JSONObject)jsonArrayApiList.get(0);
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Original APIM373ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Original APIM373ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("name"), (String)"APIM373ReSubscriptionTestAPI", (String)"Invalid name of the Original APIM373ReSubscriptionTestAPI");
        Assert.assertFalse((boolean)jsonObjectNewCopyApi.getString("version").contains("1.0.1"), (String)"New Copy of the APIM373ReSubscriptionTestAPI is visible under Subscribed API");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator(this.applicationName);
        String response = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(response);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap requestHeaders = new HashMap();
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPost.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPut.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersDelete.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldApiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)oldApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponse.getData().contains(apiResponse), (String)"Response data mismatched when api invocation for GET Request");
        HttpResponse newApiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1"), requestHeaders);
        Assert.assertEquals((int)newApiResponse.getResponseCode(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Response code mismatched when invalid api invocation");
        SubscriptionRequest ReSubscriptionRequest = new SubscriptionRequest("APIM373ReSubscriptionTestAPI", this.providerNameApi);
        ReSubscriptionRequest.setApplicationName(this.applicationName);
        ReSubscriptionRequest.setVersion("1.0.1");
        this.apiStore.subscribe(ReSubscriptionRequest);
        JSONObject ReSubscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs(this.applicationName).getData()).getJSONObject("subscriptions");
        JSONArray jsonArraySub = ReSubscribedApi.getJSONArray("applications");
        JSONObject jsonObjectReSub = (JSONObject)jsonArraySub.get(0);
        JSONArray jsonArrayReSub = jsonObjectReSub.getJSONArray("subscriptions");
        JSONObject jsonObjectReSubCopy = (JSONObject)jsonArrayReSub.get(1);
        Assert.assertEquals((String)jsonObjectReSubCopy.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the OriginalAPIM373ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectReSubCopy.getString("version"), (String)"1.0.1", (String)"Invalid Version of the OriginalAPIM373ReSubscriptionTestAPI");
        Assert.assertEquals((String)jsonObjectNewCopyApi.getString("name"), (String)"APIM373ReSubscriptionTestAPI", (String)"Invalid name of the Original APIM373ReSubscriptionTestAPI");
        JSONObject jsonObjectReSubOldCopy = (JSONObject)jsonArrayReSub.get(0);
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Original API API");
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Original API");
        Assert.assertEquals((String)jsonObjectReSubOldCopy.getString("name"), (String)"APIM373ReSubscriptionTestAPI", (String)"Invalid name of the Original API");
        HttpResponse newApiResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGet.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGet.getData().contains(apiResponse), (String)"Response data mismatched when New version api invocation for GET Request");
        HttpResponse newApiResponsePost = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/"), (String)"<Customer><name>Evin</name></Customer>", this.requestHeadersPost);
        Assert.assertEquals((int)newApiResponsePost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version api invocation for POST Request");
        Assert.assertTrue((boolean)newApiResponsePost.getData().contains("<Customer><id>124</id><name>Evin</name></Customer>"), (String)"New Customer Record is not added as expected for the POST Request");
        HttpResponse newApiResponseGetPost = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/124"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetPost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGetPost.getData().contains("<Customer><id>124</id><name>Evin</name></Customer>"), (String)"Response data mismatched when New version of the api invocation for GET Request");
        HttpResponse newApiResponsePut = HttpRequestUtil.doPut((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/"), (String)"<Customer><id>124</id><name>James</name></Customer>", this.requestHeadersPut);
        Assert.assertEquals((int)newApiResponsePut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for PUT Request");
        HttpResponse newApiResponseGetPut = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/124"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetPut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGetPut.getData().contains("<Customer><id>124</id><name>James</name></Customer>"), (String)"Response data mismatched when New version of the api invocation for GET Request");
        int newApiResponseDelete = HttpRequestUtil.doDelete((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/124"), this.requestHeadersDelete);
        Assert.assertEquals((int)newApiResponseDelete, (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when new version of the api invocation for DELETE Request");
        HttpResponse newApiResponseGetDelete = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/124"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetDelete.getResponseCode(), (int)Response.Status.NO_CONTENT.getStatusCode(), (String)"Response code mismatched when new version of the api invocation for GET request after delete the requested data");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM373ReSubscriptionTestAPI", "1.0.0", this.providerNameApi, this.applicationName);
        this.apiStore.removeAPISubscriptionByName("APIM373ReSubscriptionTestAPI", "1.0.1", this.providerNameApi, this.applicationName);
        this.apiStore.removeApplication(this.applicationName);
        this.apiPublisher.deleteAPI("APIM373ReSubscriptionTestAPI", "1.0.0", this.providerNameApi);
        this.apiPublisher.deleteAPI("APIM373ReSubscriptionTestAPI", "1.0.1", this.providerNameApi);
        super.cleanUp();
    }
}

