/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDefaultVersionURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class DefaultVersionAPITestCase
extends APIManagerLifecycleBaseTest {
    private String applicationID;
    private String apiId;
    private String newApiId;
    String accessToken;
    String newAPIVersion;

    @Factory(dataProvider="userModeDataProvider")
    public DefaultVersionAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("DefaultVersionAPP", "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationID = applicationResponse.getData();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Create New API without Selecting Default Version")
    public void testDefaultVersionAPI() throws Exception {
        String apiName = "DefaultVersionAPI";
        String apiVersion = "1.0.0";
        String apiContext = "defaultversion";
        String endpointUrl = this.getGatewayURLNhttp() + "version1";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
        apiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        APIDTO storeAPI = this.restAPIStore.getAPI(this.apiId);
        List endpointURLs = storeAPI.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        Assert.assertNull((Object)defaultVersionURLs.getWs());
        Assert.assertNull((Object)defaultVersionURLs.getWss());
        String versionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext, apiVersion);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse directResponse = this.invokeWithGet(endpointUrl, new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.accessToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.invokeWithGet(versionAPIInvocationUrl, headers);
        Assert.assertEquals((String)httpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((int)defaultHttpResponse.getResponseCode(), (int)404);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiv1 = this.restAPIPublisher.getAPIByID(this.apiId);
        apiv1.setIsDefaultVersion(Boolean.valueOf(true));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = this.restAPIPublisher.updateAPI(apiv1);
        Assert.assertNotNull((Object)apidto);
        Assert.assertTrue((boolean)apidto.isIsDefaultVersion());
        APIDTO storeAPIAfterUpdate = this.restAPIStore.getAPI(this.apiId);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse1 = this.invokeDefaultAPIWithWait(defaultVersionAPIInvocationUrl, headers, 200);
        Assert.assertEquals((String)defaultHttpResponse1.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse1.getHeaders().get("Version")), (String)"v1");
    }

    @Test(groups={"wso2.am"}, description="Create new version of API with default Version enable in created stage and verify", dependsOnMethods={"testDefaultVersionAPI"})
    public void createNewVersionWithDefaultVersionOptionAndVerifyDefaultAPIBreaking() throws Exception {
        String apiVersion = "2.0.0";
        String apiContext = "defaultversion";
        String endpointUrl = this.getGatewayURLNhttp() + "version2";
        this.newAPIVersion = this.restAPIPublisher.createNewAPIVersion(apiVersion, this.apiId, true);
        APIDTO storeAPI = this.restAPIStore.getAPI(this.apiId);
        List endpointURLs = storeAPI.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse directResponse = this.invokeWithGet(endpointUrl, new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.accessToken);
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.newAPIVersion, false);
        defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO newVersionAPI = this.restAPIPublisher.getAPIByID(this.newAPIVersion);
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)newVersionAPI.getEndpointConfig());
        Map productionEndpoint = (Map)endpointConfigJson.get((Object)"production_endpoints");
        productionEndpoint.replace("url", endpointUrl);
        newVersionAPI.setEndpointConfig((Object)endpointConfigJson);
        this.restAPIPublisher.updateAPI(newVersionAPI);
        APIRevisionDTO apiRevisionDTO = this.restAPIPublisher.addAPIRevision(this.newAPIVersion);
        APIRevisionDeployUndeployRequest apiRevisionDeployUndeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployUndeployRequest.setName("Default");
        apiRevisionDeployUndeployRequest.setVhost("localhost");
        apiRevisionDeployUndeployRequest.setDisplayOnDevportal(true);
        this.restAPIPublisher.deployAPIRevision(this.newAPIVersion, apiRevisionDTO.getId(), apiRevisionDeployUndeployRequest, "API");
        APIDTO storeAPIAfterUpdate = this.restAPIStore.getAPI(this.apiId);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        APIDTO newVersionFromStore = this.restAPIStore.getAPI(this.newAPIVersion);
        endpointURLs = newVersionFromStore.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        this.waitForAPIDeploymentSync(newVersionFromStore.getProvider(), newVersionFromStore.getName(), newVersionFromStore.getVersion(), "\"isApiExists\":true");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse1 = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse1.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse1.getHeaders().get("Version")), (String)"v2");
    }

    @Test(groups={"wso2.am"}, description="change default Version back to v1", dependsOnMethods={"testDefaultVersionAPI", "createNewVersionWithDefaultVersionOptionAndVerifyDefaultAPIBreaking"})
    public void changeNewVersionBacktoV1AndVerify() throws Exception {
        String apiContext = "defaultversion";
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO oldAPI = this.restAPIPublisher.getAPIByID(this.apiId);
        oldAPI.setIsDefaultVersion(Boolean.valueOf(true));
        this.restAPIPublisher.updateAPI(oldAPI);
        APIDTO storeAPI = this.restAPIStore.getAPI(this.apiId);
        List endpointURLs = storeAPI.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.accessToken);
        this.waitForAPIDeployment();
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        APIDTO storeAPIAfterUpdate = this.restAPIStore.getAPI(this.newAPIVersion);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        oldAPI = this.restAPIPublisher.getAPIByID(this.apiId);
        oldAPI.setIsDefaultVersion(Boolean.valueOf(false));
        this.restAPIPublisher.updateAPI(oldAPI);
        defaultHttpResponse = this.invokeDefaultAPIWithWait(defaultVersionAPIInvocationUrl, headers, 404);
        Assert.assertEquals((int)defaultHttpResponse.getResponseCode(), (int)404);
        storeAPIAfterUpdate = this.restAPIStore.getAPI(this.apiId);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
    }

    @Test(groups={"wso2.am"}, dependsOnMethods={"testDefaultVersionAPI"}, description="Check default API invocation when context is similar to the version")
    public void testDefaultVersionAPIWithContextAndVersionSimilar() throws Exception {
        String newApiName = "DefaultNewVersionAPI";
        String newApiContext = "general/v1";
        String newVersion = "v1";
        String endpointUrl = this.getGatewayURLNhttp() + "response";
        String provider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APIRequest apiRequest = new APIRequest(newApiName, newApiContext, new URL(endpointUrl));
        apiRequest.setProvider(provider);
        apiRequest.setDefault_version("default_version");
        apiRequest.setDefault_version_checked("true");
        apiRequest.setVersion(newVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        this.newApiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.waitForAPIDeploymentSync(provider, newApiName, newVersion, "\"isApiExists\":true");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.accessToken);
        String newApiInvocationUrl = this.getAPIInvocationURLHttp(newApiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.invokeDefaultAPIWithWait(newApiInvocationUrl, headers, 200);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Cannot invoke default version of APIs with similar context and versions");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newAPIVersion);
        this.restAPIPublisher.deleteAPI(this.newApiId);
        super.cleanUp();
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeDefaultAPIWithWait(String invocationUrl, Map<String, String> headers, int statusCode) throws IOException, InterruptedException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.invokeWithGet(invocationUrl, headers);
        int count = 0;
        if (response.getResponseCode() == statusCode) {
            return response;
        }
        do {
            Thread.sleep(10000L);
            response = this.invokeWithGet(invocationUrl, headers);
            if (response.getResponseCode() != 200) continue;
            return response;
        } while (++count > 6);
        return response;
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeWithGet(String url, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        headers.forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        InputStream stream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)stream);
        HashMap<String, String> outputHeaders = new HashMap<String, String>();
        for (Header header : response.getAllHeaders()) {
            outputHeaders.put(header.getName(), header.getValue());
        }
        return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(content, response.getStatusLine().getStatusCode(), outputHeaders);
    }
}

