/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class DefaultVersionWithScopesTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(DefaultVersionWithScopesTestCase.class);
    private static final String API_NAME = "DefaultVersionScopeAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "DefVersionScopeApp";
    private static final String USER_SAM = "sam";
    private static final String USER_MIKE = "mike";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private String apiId;
    private String applicationID;

    @Factory(dataProvider="userModeDataProvider")
    public DefaultVersionWithScopesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Check functionality of the default version API with scopes")
    public void testDefaultVersionAPIWithScopes() throws XPathExpressionException, APIManagerIntegrationTestException {
        String user_mike_password = "mike123";
        String user_sam_password = "sam123";
        String apiContext = "defaultversionscope";
        String user_scope = "user_scope";
        String endpointUrl = this.getGatewayURLNhttp() + "response";
        try {
            this.userManagementClient.addRole(SUBSCRIBER_ROLE, new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient.addUser(USER_MIKE, user_mike_password, new String[0], USER_MIKE);
            this.userManagementClient.addUser(USER_SAM, user_sam_password, new String[]{SUBSCRIBER_ROLE}, USER_SAM);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while creating UserManagementClient " + axisFault.getMessage()));
            Assert.fail((String)axisFault.getMessage());
        }
        catch (RemoteException | UserAdminUserAdminException e) {
            log.error((Object)("Error while adding roles or users" + e.getMessage()));
            Assert.fail((String)e.getMessage());
        }
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        apiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
        apiRequest.setDefault_version("default_version");
        apiRequest.setDefault_version_checked("true");
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        try {
            HttpResponse applicationResponse = this.restAPIStore.createApplication(APP_NAME, "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
            this.applicationID = applicationResponse.getData();
            this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
            String resourcePath = "oas" + File.separator + "v3" + File.separator + "defaultVersionScopes.json";
            String modifiedResource = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath), (Charset)StandardCharsets.UTF_8);
            this.restAPIPublisher.updateSwagger(this.apiId, modifiedResource);
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("client_credentials");
            grantTypes.add("password");
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
            String consumerKey = applicationKeyDTO.getConsumerKey();
            String consumerSecret = applicationKeyDTO.getConsumerSecret();
            String requestBody = "grant_type=password&username=sam@" + this.storeContext.getContextTenant().getDomain() + "&password=" + user_sam_password + "&scope=" + user_scope;
            URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
            JSONObject accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
            String userAccessToken = accessTokenGenerationResponse.getString("access_token");
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Authorization", "Bearer " + userAccessToken);
            String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
            HttpResponse response = HttpRequestUtil.doGet((String)apiInvocationUrl, requestHeaders);
            Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("sam cannot access the GET Method. Response = " + response.getData()));
            requestBody = "grant_type=password&username=mike@" + this.storeContext.getContextTenant().getDomain() + "&password=" + user_mike_password + "&scope=" + user_scope;
            accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
            userAccessToken = accessTokenGenerationResponse.getString("access_token");
            requestHeaders = new HashMap();
            requestHeaders.put("Authorization", "Bearer " + userAccessToken);
            response = HttpRequestUtil.doGet((String)apiInvocationUrl, requestHeaders);
            Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)("mike should receive an HTTP 403 when trying to access the GET resource. But the response code was " + response.getResponseCode()));
        }
        catch (Exception e) {
            log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationID);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO);
        }
        this.restAPIStore.deleteApplication(this.applicationID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        if (this.userManagementClient != null) {
            this.userManagementClient.deleteUser(USER_SAM);
            this.userManagementClient.deleteUser(USER_MIKE);
            this.userManagementClient.deleteRole(SUBSCRIBER_ROLE);
        }
        super.cleanUp();
    }
}

