/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.websocket;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER5869WSGayewatURLTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIMANAGER5869WSGayewatURLTestCase.class);
    private final String API_NAME = "WSGayewatURLAPIName";
    private final String API_CONTEXT = "WSGayewatURLContext";
    private final String WS_API_NAME = "WSGayewatURLWSAPIName";
    private final String WS_API_CONTEXT = "WSGayewatURLWSContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String TIER_COLLECTION = "Unlimited";
    private String publisherURLHttps;
    private String storeURLHttp;
    private APIRequest apiCreationRequestBean;
    private List<APIOperationsDTO> resList;
    private String endpointUrl;
    private ServerConfigurationManager serverConfigurationManager;
    private String websocketAPIID;
    private String restAPIId;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5869WSGayewatURLTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        this.apiCreationRequestBean = new APIRequest("WSGayewatURLAPIName", "WSGayewatURLContext", new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection("Unlimited");
        this.apiCreationRequestBean.setVersion("1.0.0");
        this.apiCreationRequestBean.setProvider(this.user.getUserName());
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/add");
        apiOperationsDTO.setThrottlingPolicy("20KPerMin");
        this.resList = new ArrayList<APIOperationsDTO>();
        this.resList.add(apiOperationsDTO);
        this.apiCreationRequestBean.setOperationsDTOS(this.resList);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(this.apiCreationRequestBean);
        this.restAPIId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.restAPIId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WSGayewatURLAPIName", "1.0.0", "\"isApiExists\":true");
    }

    @Test(description="Publish WebSocket API", dependsOnMethods={"testAPICreation"})
    public void publishWebSocketAPI() throws Exception {
        String provider = this.user.getUserName();
        URI endpointUri = new URI("ws://echo.websocket.org");
        APIRequest apiRequest = new APIRequest("WSGayewatURLWSAPIName", "WSGayewatURLWSContext", endpointUri, endpointUri);
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setProvider(provider);
        apiRequest.setType("WS");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.websocketAPIID = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.websocketAPIID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.websocketAPIID, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WSGayewatURLWSAPIName", "1.0.0", "\"isApiExists\":true");
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(provider, "WSGayewatURLWSAPIName", "1.0.0");
        String apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL("WSGayewatURLWSContext", "1.0.0") : this.getWebSocketTenantAPIInvocationURL("WSGayewatURLWSContext", "1.0.0", this.user.getUserDomain());
        this.log.info((Object)("API Endpoint URL" + apiEndPoint));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifierWebSocket, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(groups={"wso2.am"}, description="Test API gateway urls", dependsOnMethods={"publishWebSocketAPI"})
    public void testApiGatewayUrlsTest() throws Exception {
        APIDTO restAPIStoreAPI = this.restAPIStore.getAPI(this.restAPIId);
        Assert.assertNotNull((Object)restAPIStoreAPI);
        Assert.assertNotNull((Object)restAPIStoreAPI.getEndpointURLs());
        for (APIEndpointURLsDTO endpointURL : restAPIStoreAPI.getEndpointURLs()) {
            Assert.assertNotNull((Object)endpointURL.getUrLs());
            Assert.assertNotNull((Object)endpointURL.getUrLs().getHttp());
            Assert.assertNotNull((Object)endpointURL.getUrLs().getHttps());
            if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
                Assert.assertTrue((boolean)endpointURL.getUrLs().getHttp().matches("http://(.)+:[0-9]+/WSGayewatURLContext/1.0.0"));
                Assert.assertTrue((boolean)endpointURL.getUrLs().getHttps().matches("https://(.)+:[0-9]+/WSGayewatURLContext/1.0.0"));
                continue;
            }
            Assert.assertTrue((boolean)endpointURL.getUrLs().getHttp().matches("http://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0"));
            Assert.assertTrue((boolean)endpointURL.getUrLs().getHttps().matches("https://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0"));
        }
        APIDTO wsApidto = this.restAPIStore.getAPI(this.websocketAPIID);
        Assert.assertNotNull((Object)wsApidto);
        Assert.assertNotNull((Object)wsApidto.getEndpointURLs());
        Assert.assertTrue((!wsApidto.getEndpointURLs().isEmpty() ? 1 : 0) != 0);
        for (APIEndpointURLsDTO endpointURL : wsApidto.getEndpointURLs()) {
            Assert.assertNotNull((Object)endpointURL.getUrLs());
            Assert.assertNotNull((Object)endpointURL.getUrLs().getWs());
            this.log.info((Object)("API Endpoint URL = " + endpointURL.getUrLs().getWs()));
            if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
                Assert.assertTrue((boolean)endpointURL.getUrLs().getWs().matches("ws://(.)+:[0-9]+/WSGayewatURLWSContext/1.0.0"), (String)("websocketAPI gateway url = " + endpointURL.getUrLs().getWs()));
                continue;
            }
            Assert.assertTrue((boolean)endpointURL.getUrLs().getWs().matches("ws://(.)+:[0-9]+/t/wso2.com/WSGayewatURLWSContext/1.0.0"), (String)("websocketAPI gateway url = " + endpointURL.getUrLs().getWs()));
        }
    }

    @Test(groups={"wso2.am"}, description="Test WS API gateway urls", dependsOnMethods={"testApiGatewayUrlsTest"}, enabled=false)
    public void testApiGatewayUrlsAfterConfigChangeTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator + "deployment.toml"));
        }
        APIDTO restAPIStoreAPI = this.restAPIStore.getAPI(this.restAPIId);
        Assert.assertNotNull((Object)restAPIStoreAPI);
        Assert.assertNotNull((Object)restAPIStoreAPI.getEndpointURLs());
        Assert.assertTrue((!restAPIStoreAPI.getEndpointURLs().isEmpty() ? 1 : 0) != 0);
        for (APIEndpointURLsDTO endpointURL : restAPIStoreAPI.getEndpointURLs()) {
            Assert.assertNotNull((Object)endpointURL.getUrLs());
            Assert.assertNull((Object)endpointURL.getUrLs().getHttp());
            Assert.assertNotNull((Object)endpointURL.getUrLs().getHttps());
            if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
                Assert.assertTrue((boolean)endpointURL.getUrLs().getHttps().contains("https://serverhost:9898/WSGayewatURLContext/1.0.0"));
                Assert.assertFalse((boolean)endpointURL.getUrLs().getHttp().matches("http://(.)+:[0-9]+/WSGayewatURLContext/1.0.0"));
                continue;
            }
            Assert.assertTrue((boolean)endpointURL.getUrLs().getHttps().contains("https://serverhost:9898/t/wso2.com/WSGayewatURLContext/1.0.0"));
            Assert.assertFalse((boolean)endpointURL.getUrLs().getHttp().matches("http://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0"));
        }
        APIDTO wsAPIDto = this.restAPIStore.getAPI(this.websocketAPIID);
        Assert.assertNotNull((Object)wsAPIDto);
        Assert.assertNotNull((Object)wsAPIDto.getEndpointURLs());
        for (APIEndpointURLsDTO endpointURL : wsAPIDto.getEndpointURLs()) {
            Assert.assertNotNull((Object)endpointURL.getUrLs());
            Assert.assertNotNull((Object)endpointURL.getUrLs().getWs());
            if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
                Assert.assertTrue((boolean)endpointURL.getUrLs().getWs().contains("ws://localhost:9099/WSGayewatURLWSContext/1.0.0"));
                continue;
            }
            Assert.assertTrue((boolean)endpointURL.getUrLs().getWs().contains("ws://localhost:9099/t/wso2.com/WSGayewatURLWSContext/1.0.0"));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

