/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.websocket;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.websocket.client.WebSocketClientImpl;
import org.wso2.am.integration.tests.websocket.server.WebSocketServerImpl;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.utils.xml.StringUtils;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class WebSocketAPICorsValidationTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSocketAPICorsValidationTestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final String apiName = "WebSocketAPICorsValidation";
    private final String applicationName = "WebSocketApplicationCorsValidation";
    private final String applicationJWTName = "WebSocketJWTTypeApplicationCorsValidation";
    private final String testMessage = "Web Socket Test Message";
    private String apiEndPoint;
    private String provider;
    private String consumerKey;
    private String consumerSecret;
    private APIRequest apiRequest;
    private int webSocketServerPort;
    private String webSocketServerHost;
    private ServerConfigurationManager serverConfigurationManager;
    private String wsEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator;
    private String wsEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private String wsRequestEventPublisherSource = "WS_Req_Logger.xml";
    private String wsThrottleOutEventPublisherSource = "WS_Throttle_Out_Logger.xml";
    private String websocketAPIID;
    private final String originHeaderName = "http://global.config1.com";
    String appId;
    String appJWTId;
    ApplicationKeyDTO applicationKeyDTO;
    long throttleMarkTime = 0L;

    @Factory(dataProvider="userModeDataProvider")
    public WebSocketAPICorsValidationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsRequestEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsThrottleOutEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsThrottleOutEventPublisherSource), false);
        this.webSocketServerHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 9950;
        int upperPortLimit = 9999;
        this.webSocketServerPort = this.getAvailablePort(lowerPortLimit, upperPortLimit);
        if (this.webSocketServerPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.webSocketServerPort + " to start backend server"));
        this.startWebSocketServer(this.webSocketServerPort);
    }

    @Test(description="Publish WebSocket API")
    public void publishWebSocketAPI() throws Exception {
        this.provider = this.user.getUserName();
        String apiContext = "echo";
        String apiVersion = "1.0.0";
        URI endpointUri = new URI("ws://" + this.webSocketServerHost + ":" + this.webSocketServerPort);
        this.apiRequest = new APIRequest("WebSocketAPICorsValidation", apiContext, endpointUri, endpointUri);
        this.apiRequest.setVersion(apiVersion);
        this.apiRequest.setTiersCollection("AsyncUnlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WS");
        this.apiRequest.setApiTier("Unlimited");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.websocketAPIID = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.websocketAPIID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.websocketAPIID, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WebSocketAPICorsValidation", apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(this.provider, "WebSocketAPICorsValidation", apiVersion);
        this.apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL(apiContext, apiVersion) : this.getWebSocketTenantAPIInvocationURL(apiContext, apiVersion, this.user.getUserDomain());
        this.log.info((Object)("API Endpoint URL" + this.apiEndPoint));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifierWebSocket, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create JWT Type Application and subscribe", dependsOnMethods={"publishWebSocketAPI"})
    public void testWebSocketAPIJWTApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("WebSocketJWTTypeApplicationCorsValidation", "", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.appJWTId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.websocketAPIID, this.appJWTId, "AsyncUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Test CORS origin header validation for Websocket API invocations", dependsOnMethods={"testWebSocketAPIJWTApplicationSubscription"})
    public void testWebsocketAPICORSValidation() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appJWTId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client = new WebSocketClient();
        DefaultHttpHeaders headers1 = new DefaultHttpHeaders();
        headers1.add((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://global.config1.com");
        while (System.currentTimeMillis() < this.throttleMarkTime + 60000L) {
            Thread.sleep(5000L);
        }
        try {
            this.invokeAPI(client, accessToken, AUTH_IN.HEADER, (HttpHeaders)headers1);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
        DefaultHttpHeaders headers2 = new DefaultHttpHeaders();
        try {
            this.invokeAPI(client, accessToken, AUTH_IN.HEADER, (HttpHeaders)headers2);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    private void waitForReply(WebSocketClientImpl clientSocket) {
        long currentTime = System.currentTimeMillis();
        long WAIT_TIME = 30000L;
        long waitTime = currentTime + WAIT_TIME;
        while (StringUtils.isEmpty((String)clientSocket.getResponseMessage()) && waitTime > System.currentTimeMillis()) {
            try {
                this.log.info((Object)"Waiting for reply from server:");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.info((Object)("Client received :" + clientSocket.getResponseMessage()));
    }

    private void startWebSocketServer(final int serverPort) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketHandler wsHandler = new WebSocketHandler(){

                    public void configure(WebSocketServletFactory factory) {
                        factory.register(WebSocketServerImpl.class);
                    }
                };
                Server server = new Server(serverPort);
                server.setHandler((Handler)wsHandler);
                try {
                    server.start();
                    WebSocketAPICorsValidationTestCase.this.log.info((Object)("WebSocket backend server started at port: " + serverPort));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    WebSocketAPICorsValidationTestCase.this.log.error((Object)("Error while starting backend server at port: " + serverPort), (Throwable)e);
                    Assert.fail((String)"Cannot start WebSocket server");
                }
            }
        });
    }

    private void invokeAPI(WebSocketClient client, String accessToken, AUTH_IN in, HttpHeaders optionalRequestHeaders) throws Exception {
        WebSocketClientImpl socket = new WebSocketClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = null;
        if (AUTH_IN.HEADER == in) {
            request.setHeader("Authorization", "Bearer " + accessToken);
            echoUri = new URI(this.apiEndPoint);
        } else if (AUTH_IN.QUERY == in) {
            echoUri = new URI(this.apiEndPoint + "?access_token=" + accessToken);
        }
        if (optionalRequestHeaders != null) {
            for (Map.Entry headerEntry : optionalRequestHeaders.entries()) {
                request.setHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
            }
        }
        client.connect((Object)socket, echoUri, request);
        if (socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            socket.sendMessage("Web Socket Test Message");
            this.waitForReply(socket);
            if (StringUtils.isEmpty((String)socket.getResponseMessage())) {
                throw new APIManagerIntegrationTestException("Unable to create client connection");
            }
        } else {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        Assert.assertEquals((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (boolean)false, (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"Web Socket Test Message".toUpperCase(), (String)"Received response in not matching");
        socket.setResponseMessage(null);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.executorService.shutdownNow();
        super.cleanUp();
    }

    static enum AUTH_IN {
        HEADER,
        QUERY;

    }
}

