/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.websocket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.websocket.client.WebSocketClientImpl;
import org.wso2.am.integration.tests.websocket.server.WebSocketServerImpl;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class WebSocketAPITestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSocketAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final String apiName = "WebSocketAPI";
    private final String applicationName = "WebSocketApplication";
    private final String applicationJWTName = "WebSocketJWTTypeApplication";
    private final String testMessage = "Web Socket Test Message";
    private String apiEndPoint;
    private APIPublisherRestClient apiPublisher;
    private String provider;
    private String consumerKey;
    private String consumerSecret;
    private APIRequest apiRequest;
    private int webSocketServerPort;
    private String webSocketServerHost;
    private ServerConfigurationManager serverConfigurationManager;
    private String wsEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator;
    private String wsEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private String wsRequestEventPublisherSource = "WS_Req_Logger.xml";
    private String wsThrottleOutEventPublisherSource = "WS_Throttle_Out_Logger.xml";
    private String websocketAPIID;
    private final String originHeaderName = "http://global.config1.com";
    String appId;
    String appJWTId;
    ApplicationKeyDTO applicationKeyDTO;
    long throttleMarkTime = 0L;
    String apiVersion2 = "2.0.0";
    String endPointApplication = "EndPointApplication";

    @Factory(dataProvider="userModeDataProvider")
    public WebSocketAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsRequestEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsThrottleOutEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsThrottleOutEventPublisherSource), false);
        this.webSocketServerHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 9950;
        int upperPortLimit = 9999;
        this.webSocketServerPort = this.getAvailablePort(lowerPortLimit, upperPortLimit);
        if (this.webSocketServerPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.webSocketServerPort + " to start backend server"));
        this.startWebSocketServer(this.webSocketServerPort);
    }

    @Test(description="Publish WebSocket API")
    public void publishWebSocketAPI() throws Exception {
        this.provider = this.user.getUserName();
        String apiContext = "echo";
        String apiVersion = "1.0.0";
        URI endpointUri = new URI("ws://" + this.webSocketServerHost + ":" + this.webSocketServerPort);
        this.apiRequest = new APIRequest("WebSocketAPI", apiContext, endpointUri, endpointUri);
        this.apiRequest.setVersion(apiVersion);
        this.apiRequest.setTiersCollection("AsyncUnlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WS");
        this.apiRequest.setApiTier("Unlimited");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.websocketAPIID = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.websocketAPIID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.websocketAPIID, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WebSocketAPI", apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(this.provider, "WebSocketAPI", apiVersion);
        this.apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL(apiContext, apiVersion) : this.getWebSocketTenantAPIInvocationURL(apiContext, apiVersion, this.user.getUserDomain());
        this.log.info((Object)("API Endpoint URL" + this.apiEndPoint));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifierWebSocket, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"publishWebSocketAPI"})
    public void testWebSocketAPIApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("WebSocketApplication", "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.websocketAPIID, this.appId, "AsyncUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Invoke API using token", dependsOnMethods={"testWebSocketAPIApplicationSubscription"})
    public void testWebSocketAPIInvocation() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        this.applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        this.consumerKey = this.applicationKeyDTO.getConsumerKey();
        this.consumerSecret = this.applicationKeyDTO.getConsumerSecret();
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeAPI(client, tokenJti, AUTH_IN.HEADER, null, this.apiEndPoint);
            this.invokeAPI(client, tokenJti, AUTH_IN.QUERY, null, this.apiEndPoint);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    @Test(description="Create JWT Type Application and subscribe", dependsOnMethods={"publishWebSocketAPI"})
    public void testWebSocketAPIJWTApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("WebSocketJWTTypeApplication", "", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.appJWTId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.websocketAPIID, this.appJWTId, "AsyncUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Invoke API using token", dependsOnMethods={"testWebSocketAPIJWTApplicationSubscription"})
    public void testWebSocketAPIInvocationWithJWTToken() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeAPI(client, accessToken, AUTH_IN.HEADER, null, this.apiEndPoint);
            this.invokeAPI(client, accessToken, AUTH_IN.QUERY, null, this.apiEndPoint);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Invoke API with only sandbox endpoint configured", dependsOnMethods={"testWebSocketAPIInvocationWithJWTToken"})
    public void testWebSocketAPIRemoveEndpoint() throws Exception {
        HttpResponse response = this.restAPIPublisher.copyAPI(this.apiVersion2, this.websocketAPIID, Boolean.valueOf(false));
        String websocketAPIID = response.getData();
        this.createAPIRevisionAndDeployUsingRest(websocketAPIID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(websocketAPIID, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WebSocketAPI", this.apiVersion2, "\"isApiExists\":true");
        Gson g = new Gson();
        HttpResponse getApiResponse = this.restAPIPublisher.getAPI(websocketAPIID);
        APIDTO apidto = (APIDTO)g.fromJson(getApiResponse.getData(), APIDTO.class);
        URI endpointUri = new URI("ws://" + this.webSocketServerHost + ":" + this.webSocketServerPort);
        String endPointString = "{\n  \"sandbox_endpoints\": {\n    \"url\": \"" + endpointUri + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\"\n}";
        JSONParser parser = new JSONParser();
        JSONObject endpoint = (JSONObject)parser.parse(endPointString);
        apidto.setEndpointConfig((Object)endpoint);
        this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(websocketAPIID, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiVersion2, "\"isApiExists\":true");
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.endPointApplication, "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String appId = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(websocketAPIID, appId, "AsyncUnlimited");
        String apiEndPoint = null;
        apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL(this.apiRequest.getContext(), this.apiVersion2) : this.getWebSocketTenantAPIInvocationURL(this.apiRequest.getContext(), this.apiVersion2, this.user.getUserDomain());
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO sandboxApplicationKeyDTO = this.restAPIStore.generateKeys(appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String sandboxAccessToken = sandboxApplicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client0 = new WebSocketClient();
        try {
            this.invokeAPI(client0, sandboxAccessToken, AUTH_IN.HEADER, null, apiEndPoint);
            this.invokeAPI(client0, sandboxAccessToken, AUTH_IN.QUERY, null, apiEndPoint);
            Assert.assertTrue((boolean)true, (String)"Client can connect to the sandbox endpoint");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client0.stop();
        }
        ApplicationKeyDTO prodApplicationKeyDTO = this.restAPIStore.generateKeys(appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String prodAccessToken = prodApplicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client1 = new WebSocketClient();
        try {
            this.invokeAPI(client1, prodAccessToken, AUTH_IN.QUERY, null, apiEndPoint);
            Assert.fail((String)"Client can connect to the production endpoint when production endpoint is not configured");
        }
        catch (Exception e) {
            this.log.debug((Object)"Exception in connecting to server", (Throwable)e);
        }
        finally {
            client1.stop();
        }
        this.undeployAndDeleteAPIRevisionsUsingRest(websocketAPIID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiVersion2, "\"isApiExists\":false");
    }

    @Test(description="Test Throttling for WebSocket API", dependsOnMethods={"testWebSocketAPIInvocation"})
    public void testWebSocketAPIThrottling() throws Exception {
        FileInputStream inputStream = new FileInputStream(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator + "policy.json");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonMap = mapper.readTree((InputStream)inputStream);
        String policyName = jsonMap.get("policyName").textValue();
        String policyDescription = jsonMap.get("policyDescription").textValue();
        JsonNode defaultLimitJson = jsonMap.get("defaultLimit");
        JsonNode requestCountJson = defaultLimitJson.get("requestCount");
        Long requestCountLimit = Long.valueOf(String.valueOf(requestCountJson.get("requestCount")));
        String timeUnit = requestCountJson.get("timeUnit").textValue();
        Integer unitTime = Integer.valueOf(String.valueOf(requestCountJson.get("unitTime")));
        RequestCountLimitDTO requestCountLimitDTO = DtoFactory.createRequestCountLimitDTO((String)timeUnit, (Integer)unitTime, (Long)requestCountLimit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimitDTO, null);
        AdvancedThrottlePolicyDTO bandwidthAdvancedPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)"", (String)policyDescription, (boolean)false, (ThrottleLimitDTO)defaultLimit, new ArrayList());
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(bandwidthAdvancedPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedAdvancedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String apiPolicyId = addedAdvancedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)apiPolicyId, (String)"The policy ID cannot be null or empty");
        HttpResponse response = this.restAPIPublisher.getAPI(this.websocketAPIID);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy("WebSocketTestThrottlingPolicy");
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(updatedAPI.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)"WebSocketTestThrottlingPolicy");
        URL tokenEndpointURL = new URL(this.getKeyManagerURLHttps() + "/oauth2/token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        org.json.JSONObject subsAccessTokenGenerationResponse = new org.json.JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        String subsRefreshToken = subsAccessTokenGenerationResponse.getString("refresh_token");
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)subsRefreshToken), (String)"Refresh token of access token generated by subscriber is empty");
        String requestBody = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        org.json.JSONObject accessTokenGenerationResponse = new org.json.JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        String getAccessTokenFromRefreshTokenRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
        accessTokenGenerationResponse = new org.json.JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, getAccessTokenFromRefreshTokenRequestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        Assert.assertNotNull((Object)("Access Token not found " + accessTokenGenerationResponse), (String)userAccessToken);
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        this.testThrottling(tokenJti);
        this.throttleMarkTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Invoke API using invalid token", dependsOnMethods={"testWebSocketAPIThrottling"})
    public void testWebSocketAPIInvalidTokenInvocation() throws Exception {
        while (System.currentTimeMillis() < this.throttleMarkTime + 60000L) {
            Thread.sleep(5000L);
        }
        WebSocketClient client = new WebSocketClient();
        boolean apiInvocationFailed = false;
        try {
            this.invokeAPI(client, "00000000-0000-0000-0000-000000000000", AUTH_IN.HEADER, null, this.apiEndPoint);
        }
        catch (APIManagerIntegrationTestException e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            apiInvocationFailed = true;
            Assert.assertTrue((boolean)true, (String)"Client cannot connect to server");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            if (!apiInvocationFailed) {
                Assert.fail((String)"WS API was invoked with invalid token");
            }
            client.stop();
        }
    }

    private void waitForReply(WebSocketClientImpl clientSocket) {
        long currentTime = System.currentTimeMillis();
        long WAIT_TIME = 30000L;
        long waitTime = currentTime + WAIT_TIME;
        while (org.wso2.carbon.utils.xml.StringUtils.isEmpty((String)clientSocket.getResponseMessage()) && waitTime > System.currentTimeMillis()) {
            try {
                this.log.info((Object)"Waiting for reply from server:");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.info((Object)("Client received :" + clientSocket.getResponseMessage()));
    }

    private void startWebSocketServer(final int serverPort) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketHandler wsHandler = new WebSocketHandler(){

                    public void configure(WebSocketServletFactory factory) {
                        factory.register(WebSocketServerImpl.class);
                    }
                };
                Server server = new Server(serverPort);
                server.setHandler((Handler)wsHandler);
                try {
                    server.start();
                    WebSocketAPITestCase.this.log.info((Object)("WebSocket backend server started at port: " + serverPort));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    WebSocketAPITestCase.this.log.error((Object)("Error while starting backend server at port: " + serverPort), (Throwable)e);
                    Assert.fail((String)"Cannot start WebSocket server");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testThrottling(String accessToken) throws Exception {
        WebSocketAPITestCase.waitUntilClockHour();
        int startingDistinctUnitTime = LocalDateTime.now().getMinute();
        int limit = 2;
        WebSocketClient client = new WebSocketClient();
        WebSocketClientImpl socket = new WebSocketClientImpl();
        client.start();
        URI echoUri = new URI(this.apiEndPoint);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Authorization", "Bearer " + accessToken);
        client.connect((Object)socket, echoUri, request);
        socket.getLatch().await(3L, TimeUnit.SECONDS);
        try {
            for (int count = 1; count <= limit + 1; ++count) {
                if (count > limit) {
                    Thread.sleep(5000L);
                }
                socket.sendMessage("Web Socket Test Message");
                this.waitForReply(socket);
                this.log.info((Object)("Count :" + count + " Message :" + socket.getResponseMessage()));
                if (count > limit) {
                    if (LocalDateTime.now().getMinute() != startingDistinctUnitTime) {
                        this.log.info((Object)"Repeating the test as throttling testing time duration is dispersed into two separate units of time");
                        this.testThrottling(accessToken);
                    }
                    Assert.assertEquals((String)socket.getResponseMessage(), (String)"Error code: 4003 reason: Websocket frame throttled out", (String)"Received response is not matching");
                }
                socket.setResponseMessage(null);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error occurred while calling API.", (Throwable)ex);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    private void invokeAPI(WebSocketClient client, String accessToken, AUTH_IN in, HttpHeaders optionalRequestHeaders, String apiEndPoint) throws Exception {
        WebSocketClientImpl socket = new WebSocketClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = null;
        if (AUTH_IN.HEADER == in) {
            request.setHeader("Authorization", "Bearer " + accessToken);
            echoUri = new URI(apiEndPoint);
        } else if (AUTH_IN.QUERY == in) {
            echoUri = new URI(apiEndPoint + "?access_token=" + accessToken);
        }
        if (optionalRequestHeaders != null) {
            for (Map.Entry headerEntry : optionalRequestHeaders.entries()) {
                request.setHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
            }
        }
        client.connect((Object)socket, echoUri, request);
        if (socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            socket.sendMessage("Web Socket Test Message");
            this.waitForReply(socket);
            if (org.wso2.carbon.utils.xml.StringUtils.isEmpty((String)socket.getResponseMessage())) {
                throw new APIManagerIntegrationTestException("Unable to create client connection");
            }
        } else {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        Assert.assertEquals((boolean)org.wso2.carbon.utils.xml.StringUtils.isEmpty((String)socket.getResponseMessage()), (boolean)false, (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"Web Socket Test Message".toUpperCase(), (String)"Received response in not matching");
        socket.setResponseMessage(null);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.executorService.shutdownNow();
        super.cleanUp();
    }

    static enum AUTH_IN {
        HEADER,
        QUERY;

    }
}

