/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.workflow;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.HttpResponse;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.WorkflowStatus;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class WorkflowApprovalExecutorTest
extends APIManagerLifecycleBaseTest {
    private UserManagementClient userManagementClient = null;
    private String originalWFExtentionsXML;
    private String newWFExtentionsXML;
    private String USER_SMITH = "smith";
    private String ADMIN_ROLE = "admin";
    private String USER_ADMIN = "jackson";
    private String userName;
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private final String ALLOWED_ROLE = "admin";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private final String[] ADMIN_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage", "/permission/admin/configure", "/permission/admin/monitor"};
    private final String[] NEW_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "admin"};
    private final String APIM_CONFIG_XML = "api-manager.xml";
    private final String DEFAULT_WF_EXTENTIONS_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/workflow-extensions.xml";
    private RestAPIAdminImpl restAPIAdminUser;
    private static final Log log = LogFactory.getLog(WorkflowApprovalExecutorTest.class);
    private APIIdentifier apiIdentifier;
    private AdminDashboardRestClient adminDashboardRestClient;
    private String apiId;
    private String applicationID;
    private String subscriptionId;
    private ApiProductTestHelper apiProductTestHelper;
    private ApiTestHelper apiTestHelper;
    private RestAPIStoreImpl APIStoreClient;
    private String apiName = "WorkflowTestAPI";
    private String applicationName = "AppCreationWorkflowTestAPP";
    private ArrayList<APIDTO> apisToBeUsed;
    private APIProductDTO apiProductDTO;
    private String apiProductId;

    @Factory(dataProvider="userModeDataProvider")
    public WorkflowApprovalExecutorTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.userManagementClient.addUser(this.USER_SMITH, "john123", new String[]{"Internal/subscriber"}, this.USER_SMITH);
        this.userManagementClient.addUser(this.USER_ADMIN, "admin", new String[]{"admin"}, this.ADMIN_ROLE);
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.originalWFExtentionsXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml");
        this.newWFExtentionsXML = this.readFile(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "approveWorkflow" + File.separator + "workflow-extensions.xml");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.newWFExtentionsXML);
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.keyManagerHTTPSURL, this.user);
    }

    @Test(groups={"wso2.am"}, description="Api workflow process check")
    public void testAPIWorkflowProcess() throws Exception {
        String apiVersion = "1.0.0";
        String apiContext = "workflowCheck";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(this.apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.USER_SMITH);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifeCycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        org.testng.Assert.assertEquals((int)apiResponse.getResponseCode(), (int)201, (String)"API creation test failed in Approval Workflow Executor");
        org.testng.Assert.assertEquals((int)lifeCycleChangeResponse.getResponseCode(), (int)200, (String)"Status code mismatch when request is make for change API state");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        JSONObject apiObj = new JSONObject(api.getData());
        String apiStatus = (String)apiObj.get("workflowStatus");
        org.testng.Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.CREATED.toString(), (String)"Lifecycle state should remain without changing till approval. ");
        String workflowType = "AM_API_STATE";
        this.restAPIAdminUser = new RestAPIAdminImpl(this.USER_SMITH, "john123", "carbon.super", this.adminURLHttps);
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests can only be viewed for the admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("apiName") || !this.apiName.equals(properties.get("apiName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request by external workflow reference failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow request update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String status = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)status, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiNew = this.restAPIPublisher.getAPI(this.apiId);
        JSONObject apiObject = new JSONObject(apiNew.getData());
        String apiNewStatus = (String)apiObject.get("lifeCycleStatus");
        org.testng.Assert.assertEquals((String)apiNewStatus, (String)APILifeCycleState.PUBLISHED.toString(), (String)"Lifecycle state should change after approval. ");
    }

    @Test(groups={"wso2.am"}, description="API Product workflow process check")
    public void testAPIProductWorkflowProcess() throws Exception {
        this.createAndDeployAPIProduct();
        WorkflowResponseDTO workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Publish", null);
        org.testng.Assert.assertEquals((String)"CREATED", (String)workflowResponseDTO.getWorkflowStatus().getValue());
        APIProductDTO returnedAPIProductDTO = this.restAPIPublisher.getApiProduct(this.apiProductId);
        org.testng.Assert.assertEquals((String)"CREATED", (String)returnedAPIProductDTO.getState());
        org.testng.Assert.assertEquals((String)returnedAPIProductDTO.getWorkflowStatus(), (String)APILifeCycleState.CREATED.toString(), (String)"Lifecycle state should remain without changing till approval. ");
        String workflowType = "AM_API_PRODUCT_STATE";
        WorkflowListDTO workflowListDTO = this.restAPIAdmin.getWorkflowsByWorkflowType(workflowType);
        Assert.assertNotNull((Object)workflowListDTO);
        Assert.assertNotNull((Object)workflowListDTO.getList());
        String workflowReferenceID = null;
        for (WorkflowInfoDTO workflow : workflowListDTO.getList()) {
            LinkedTreeMap workflowProperties = (LinkedTreeMap)workflow.getProperties();
            assert (workflowProperties != null);
            if (!workflowProperties.containsKey((Object)"apiName") || !this.apiProductDTO.getName().equals(workflowProperties.get((Object)"apiName"))) continue;
            workflowReferenceID = workflow.getReferenceId();
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", workflowReferenceID);
        HttpResponse response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(workflowReferenceID);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request by external workflow reference failed for User Admin");
        response = this.restAPIAdmin.updateWorkflowStatus(workflowReferenceID);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow request update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String status = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)status, (String)WorkflowStatus.APPROVED.toString());
        returnedAPIProductDTO = this.restAPIPublisher.getApiProduct(this.apiProductId);
        org.testng.Assert.assertEquals((String)returnedAPIProductDTO.getState().toUpperCase(), (String)APILifeCycleState.PUBLISHED.toString().toUpperCase(), (String)"Lifecycle state should change after approval");
    }

    private void createAndDeployAPIProduct() throws Exception {
        this.apisToBeUsed = new ArrayList();
        APIDTO apiOne = this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        APIDTO apiTwo = this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        this.apisToBeUsed.add(apiOne);
        this.apisToBeUsed.add(apiTwo);
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        this.apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(this.USER_SMITH, name, context, this.apisToBeUsed, policies);
        this.apiProductId = this.apiProductDTO.getId();
        assert (this.apiProductDTO.getState() != null);
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(this.apiProductDTO.getState()));
        this.waitForAPIDeployment();
        this.createAPIProductRevisionAndDeployUsingRest(this.apiProductId, this.restAPIPublisher);
        this.apiProductTestHelper.verfiyApiProductInPublisher(this.apiProductDTO);
    }

    @Test(groups={"wso2.am"}, description="Application workflow process check", dependsOnMethods={"testAPIWorkflowProcess"}, enabled=true)
    public void testApplicationWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.applicationID = applicationResponse.getData();
        org.testng.Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Application Creation test failed in Approval Workflow Executor");
        ApplicationDTO appResponse = this.restAPIStore.getApplicationById(this.applicationID);
        String status1 = appResponse.getStatus();
        org.testng.Assert.assertEquals((String)status1, (String)"CREATED", (String)"Application state should remain without changing till approval. ");
        String workflowType = "AM_APPLICATION_CREATION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests an only view by Admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !this.applicationName.equals(properties.get("applicationName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow state update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        ApplicationDTO appFinalResponse = this.restAPIStore.getApplicationById(this.applicationID);
        String status = appFinalResponse.getStatus();
        org.testng.Assert.assertEquals((String)status, (String)"APPROVED", (String)"Application state should change after  approval. ");
    }

    @Test(groups={"wso2.am"}, description="Application workflow process check", dependsOnMethods={"testAPIWorkflowProcess"}, enabled=true)
    public void testApplicationDeletionWorkflowProcess() throws Exception {
        String deletingAppName = "AppDeletionWorkflowTestAPP";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("AppDeletionWorkflowTestAPP", "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String deletingAppID = applicationResponse.getData();
        org.testng.Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Application Creation test failed in Approval Workflow Executor");
        ApplicationDTO appResponse = this.restAPIStore.getApplicationById(deletingAppID);
        String status1 = appResponse.getStatus();
        org.testng.Assert.assertEquals((String)status1, (String)"CREATED", (String)"Application state should remain without changing till approval.");
        String workflowType = "AM_APPLICATION_CREATION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests an only view by Admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !"AppDeletionWorkflowTestAPP".equals(properties.get("applicationName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow state update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        ApplicationDTO appFinalResponse = this.restAPIStore.getApplicationById(deletingAppID);
        String status = appFinalResponse.getStatus();
        org.testng.Assert.assertEquals((String)status, (String)"APPROVED", (String)"Application state should change after  approval. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse delResponse = this.restAPIStore.deleteApplicationWithHttpResponse(deletingAppID);
        org.testng.Assert.assertEquals((int)delResponse.getResponseCode(), (int)201, (String)"Application deletion approval workflow failure");
        ApplicationDTO deletePendingAppDTO = this.restAPIStore.getApplicationById(deletingAppID);
        Assert.assertNotNull((String)"Application deleted without approval process", (Object)deletePendingAppDTO);
        String deletePendingAppStatus = deletePendingAppDTO.getStatus();
        org.testng.Assert.assertEquals((String)deletePendingAppStatus, (String)"DELETE_PENDING", (String)"Application state should remain as DELETE_PENDING till approval. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse delRetryResponse = this.restAPIStore.deleteApplicationWithHttpResponse(deletingAppID);
        org.testng.Assert.assertEquals((int)delRetryResponse.getResponseCode(), (int)400, (String)"Delete pending application should not be able to be deleted by deletion request");
        this.removeDeletePendingApplication("AppDeletionWorkflowTestAPP");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse appRetrieveAfterDelResponse = this.restAPIStore.getApplicationByIdWithHttpResponse(deletingAppID);
        int responseCode = appRetrieveAfterDelResponse.getResponseCode();
        org.testng.Assert.assertEquals((int)responseCode, (int)404, (String)"Application deletion failed for approval flow");
    }

    private void removeDeletePendingApplication(String applicationName) throws ApiException, JSONException {
        String appDeletionWorkflowType = "AM_APPLICATION_DELETION";
        HttpResponse delWorkflowsResponse = this.restAPIAdmin.getWorkflows("AM_APPLICATION_DELETION");
        org.testng.Assert.assertEquals((int)delWorkflowsResponse.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        JSONObject delWorkflowsObject = new JSONObject(delWorkflowsResponse.getData());
        String delExternalWorkflowRef = null;
        JSONArray wfArray = (JSONArray)delWorkflowsObject.get("list");
        for (int i = 0; i < wfArray.length(); ++i) {
            JSONObject listItem = (JSONObject)wfArray.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !applicationName.equals(properties.get("applicationName"))) continue;
            delExternalWorkflowRef = (String)listItem.get("referenceId");
            break;
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", delExternalWorkflowRef);
        delWorkflowsResponse = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(delExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)delWorkflowsResponse.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        HttpResponse updateWorkflowResponse = this.restAPIAdmin.updateWorkflowStatus(delExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)updateWorkflowResponse.getResponseCode(), (int)200, (String)"Workflow state update failed for user admin");
    }

    @Test(groups={"wso2.am"}, description="Subscription workflow process check", dependsOnMethods={"testApplicationWorkflowProcess", "testAPIWorkflowProcess"})
    public void testSubscriptionWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse SubscribeResponse = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
        this.subscriptionId = SubscribeResponse.getData();
        org.testng.Assert.assertEquals((int)SubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of API is not successful");
        SubscriptionListDTO subscriptionListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionList = new ArrayList();
        subscriptionList = subscriptionListDTO.getList();
        SubscriptionDTO.SubscriptionStatusEnum SubscriptionStatus = SubscriptionDTO.SubscriptionStatusEnum.BLOCKED;
        for (SubscriptionDTO subscriptioninfo : subscriptionList) {
            if (!this.applicationID.equals(subscriptioninfo.getApplicationInfo().getApplicationId())) continue;
            SubscriptionStatus = subscriptioninfo.getSubscriptionStatus();
            log.info((Object)"Found valid subscription for the application");
            break;
        }
        org.testng.Assert.assertEquals((Object)SubscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.ON_HOLD, (String)"Subscription state should remain without changing till approval. ");
        String workflowType = "AM_SUBSCRIPTION_CREATION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow Pending requests can only viewed for User Admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !this.applicationName.equals(properties.get("applicationName")) || !properties.has("apiName") || !this.apiName.equals(properties.get("apiName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Updated workflow state is failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        SubscriptionListDTO subscriptionFinalListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionFinalList = new ArrayList();
        subscriptionFinalList = subscriptionFinalListDTO.getList();
        for (SubscriptionDTO subscriptioninfo : subscriptionFinalList) {
            if (!this.applicationID.equals(subscriptioninfo.getApplicationInfo().getApplicationId())) continue;
            SubscriptionStatus = subscriptioninfo.getSubscriptionStatus();
            log.info((Object)"Found valid subscription for the application");
            break;
        }
        org.testng.Assert.assertEquals((Object)SubscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.UNBLOCKED, (String)"Subscription state should change after approval. ");
    }

    @Test(groups={"wso2.am"}, description="Subscription workflow process check", dependsOnMethods={"testApplicationWorkflowProcess", "testAPIWorkflowProcess", "testSubscriptionWorkflowProcess"})
    public void testSubscriptionDeletionWorkflowProcess() throws Exception {
        String subDelTestAppName = "SubDelTestApp";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("SubDelTestApp", "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String subDelTestAppID = applicationResponse.getData();
        String workflowTypeAppCreation = "AM_APPLICATION_CREATION";
        HttpResponse response = this.restAPIAdmin.getWorkflows("AM_APPLICATION_CREATION");
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !"SubDelTestApp".equals(properties.get("applicationName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Updated workflow state is failed for user admin");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse subCreationResponse = this.restAPIStore.createSubscription(this.apiId, subDelTestAppID, "Unlimited");
        String subscriptionId = subCreationResponse.getData();
        org.testng.Assert.assertEquals((int)subCreationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of API is not successful");
        String workflowTypeSubCreation = "AM_SUBSCRIPTION_CREATION";
        HttpResponse subWorkflowResponse = this.restAPIAdmin.getWorkflows("AM_SUBSCRIPTION_CREATION");
        org.testng.Assert.assertEquals((int)subWorkflowResponse.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        JSONObject subCreationWorkflowRespObj = new JSONObject(subWorkflowResponse.getData());
        String subCreationExternalWorkflowRef = null;
        JSONArray subCreationWFArray = (JSONArray)subCreationWorkflowRespObj.get("list");
        for (int i = 0; i < subCreationWFArray.length(); ++i) {
            JSONObject listItem = (JSONObject)subCreationWFArray.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !"SubDelTestApp".equals(properties.get("applicationName")) || !properties.has("apiName") || !this.apiName.equals(properties.get("apiName"))) continue;
            subCreationExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", subCreationExternalWorkflowRef);
        subWorkflowResponse = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(subCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)subWorkflowResponse.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        subWorkflowResponse = this.restAPIAdmin.updateWorkflowStatus(subCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)subWorkflowResponse.getResponseCode(), (int)200, (String)"Updated workflow state is failed for user admin");
        String jsonUpdateResponse = subWorkflowResponse.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        SubscriptionListDTO subscriptionFinalListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionFinalList = subscriptionFinalListDTO.getList();
        Assert.assertNotNull((Object)subscriptionFinalList);
        SubscriptionDTO.SubscriptionStatusEnum subscriptionStatus = SubscriptionDTO.SubscriptionStatusEnum.BLOCKED;
        for (SubscriptionDTO subscriptionInfo : subscriptionFinalList) {
            if (!subDelTestAppID.equals(subscriptionInfo.getApplicationInfo().getApplicationId())) continue;
            subscriptionStatus = subscriptionInfo.getSubscriptionStatus();
            log.info((Object)"Found valid subscription for the application");
            break;
        }
        org.testng.Assert.assertEquals((Object)subscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.UNBLOCKED, (String)"Subscription state should change after approval. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse subDeletionResponse = this.restAPIStore.removeSubscriptionWithHttpInfo(subscriptionId);
        org.testng.Assert.assertEquals((int)subDeletionResponse.getResponseCode(), (int)201, (String)"Subscription deletion approval workflow failure");
        SubscriptionListDTO subscriptionListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionList = subscriptionListDTO.getList();
        Assert.assertNotNull((Object)subscriptionList);
        subscriptionStatus = SubscriptionDTO.SubscriptionStatusEnum.BLOCKED;
        for (SubscriptionDTO subscriptionInfo : subscriptionList) {
            if (!subDelTestAppID.equals(subscriptionInfo.getApplicationInfo().getApplicationId())) continue;
            subscriptionStatus = subscriptionInfo.getSubscriptionStatus();
            log.info((Object)"Found valid subscription for the application");
            break;
        }
        org.testng.Assert.assertEquals((Object)subscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.DELETE_PENDING, (String)"Subscription state should be DELETE_PENDING in the subscription deletion approval process");
        String workflowTypeSubDeletion = "AM_SUBSCRIPTION_DELETION";
        HttpResponse subDelWorkflowResponse = this.restAPIAdmin.getWorkflows("AM_SUBSCRIPTION_DELETION");
        org.testng.Assert.assertEquals((int)subWorkflowResponse.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        JSONObject subDelWorkflowRespObj = new JSONObject(subDelWorkflowResponse.getData());
        String subDelExternalWorkflowRef = null;
        JSONArray subDelWFArray = (JSONArray)subDelWorkflowRespObj.get("list");
        for (int i = 0; i < subDelWFArray.length(); ++i) {
            JSONObject listItem = (JSONObject)subDelWFArray.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !"SubDelTestApp".equals(properties.get("applicationName")) || !properties.has("apiName") || !this.apiName.equals(properties.get("apiName"))) continue;
            subDelExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", subDelExternalWorkflowRef);
        subWorkflowResponse = this.restAPIAdmin.updateWorkflowStatus(subDelExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)subWorkflowResponse.getResponseCode(), (int)200, (String)"Updated workflow state is failed for user admin");
        SubscriptionListDTO subscriptionsAfterDelDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionsAfterDel = subscriptionsAfterDelDTO.getList();
        Assert.assertNotNull((Object)subscriptionsAfterDel);
        SubscriptionDTO deletedSubscription = subscriptionsAfterDel.stream().filter(subscriptionDTO -> subscriptionDTO.getApplicationInfo() != null && subDelTestAppID.equals(subscriptionDTO.getApplicationInfo().getApplicationId())).findAny().orElse(null);
        org.testng.Assert.assertNull((Object)deletedSubscription, (String)"Subscription deletion failed for approval flow");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse delResponse = this.restAPIStore.deleteApplicationWithHttpResponse(subDelTestAppID);
        org.testng.Assert.assertEquals((int)delResponse.getResponseCode(), (int)201, (String)"Application deletion approval workflow failure");
        this.removeDeletePendingApplication("SubDelTestApp");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse appRetrieveAfterDelResponse = this.restAPIStore.getApplicationByIdWithHttpResponse(subDelTestAppID);
        int responseCode = appRetrieveAfterDelResponse.getResponseCode();
        org.testng.Assert.assertEquals((int)responseCode, (int)404, (String)"Application deletion failed for approval flow");
    }

    @Test(groups={"wso2.am"}, description="Registration workflow process check", dependsOnMethods={"testSubscriptionWorkflowProcess"})
    public void testRegistrationWorkflowProcess() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String keyState = applicationKeyDTO.getKeyState();
        org.testng.Assert.assertEquals((String)keyState, (String)"CREATED", (String)"Application key generation should not change until approval");
        String workflowType = "AM_APPLICATION_REGISTRATION_PRODUCTION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow pending requests can only view by admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !this.applicationName.equals(properties.get("applicationName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated for the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"failed to update the workflow request for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        ApiResponse apiresponse = this.restAPIStore.getApplicationKeysByKeyType(this.applicationID, "PRODUCTION");
        ApplicationKeyDTO applicationKeyData = (ApplicationKeyDTO)apiresponse.getData();
        org.testng.Assert.assertEquals((String)applicationKeyData.getKeyState(), (String)"COMPLETED", (String)"Application key generation stat should change after approval");
    }

    @Test(groups={"wso2.am"}, description="User Sign Up workflow process check", dependsOnMethods={"testRegistrationWorkflowProcess"})
    public void testUserSignUpWorkflowProcess() throws Exception {
        String giveName = "Jane";
        String username = "JaneDoe";
        String password = "admin";
        String organization = "wso2";
        String email = "janedoe@gmail.com";
        String store = this.storeURLHttps;
        UserManagementUtils.signupUser((String)username, (String)password, (String)giveName, (String)organization, (String)email);
        String workflowType = "AM_USER_SIGNUP";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests can only viewed by admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        JSONObject workflowRespObj = new JSONObject(response.getData());
        String externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            JSONObject properties = (JSONObject)listItem.get("properties");
            if (!properties.has("tenantAwareUserName") || !username.equals(properties.get("tenantAwareUserName"))) continue;
            externalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", externalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Failed to update Workflow request for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        org.testng.Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse loginResponse = this.apiStore.login(username, password);
        org.testng.Assert.assertEquals((int)loginResponse.getResponseCode(), (int)302, (String)"Failed to login to developer portal");
    }

    @Test(groups={"wso2.am"}, description="clean up workflow process check", dependsOnMethods={"testUserSignUpWorkflowProcess"})
    public void testCleanUpWorkflowProcess() throws Exception {
        JSONObject properties;
        String applicationName = "MyApp";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, "Testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String applicationIDNew = applicationResponse.getData();
        String apiName = "WorkflowCheckingAPINew";
        String apiVersion = "1.0.0";
        String apiContext = "workflowChecking";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.USER_SMITH);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiIdNew = apiResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(apiIdNew, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifeCycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(apiIdNew, APILifeCycleAction.PUBLISH.getAction(), null);
        String workflowType = "AM_API_STATE";
        HttpResponse response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonAPIStateChangeGetResponse = response.getData();
        String apiStateChangeExternalWorkflowRef = null;
        JSONObject workflowRespObj = new JSONObject(response.getData());
        Object externalWorkflowRef = null;
        JSONArray arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("apiName") || !apiName.equals(properties.get("apiName"))) continue;
            apiStateChangeExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", apiStateChangeExternalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(apiStateChangeExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        workflowType = "AM_APPLICATION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonApplicationCreationGetResponse = response.getData();
        String applicationCreationExternalWorkflowRef = null;
        workflowRespObj = new JSONObject(response.getData());
        arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !applicationName.equals(properties.get("applicationName"))) continue;
            applicationCreationExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", applicationCreationExternalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(applicationCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        this.undeployAndDeleteAPIRevisionsUsingRest(apiIdNew, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(apiIdNew);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse delResponse = this.restAPIStore.deleteApplicationWithHttpResponse(applicationIDNew);
        org.testng.Assert.assertEquals((int)delResponse.getResponseCode(), (int)201, (String)"Application deletion approval workflow failure");
        this.removeDeletePendingApplication(applicationName);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(applicationCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Application creation");
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(apiStateChangeExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for API state change");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponseNew = this.restAPIStore.createApplication(applicationName, "Testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String applicationIDSecond = applicationResponseNew.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponseNew = this.restAPIPublisher.addAPI(apiRequest);
        String apiIdSecond = apiResponseNew.getData();
        this.createAPIRevisionAndDeployUsingRest(apiIdSecond, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(apiIdSecond, APILifeCycleAction.PUBLISH.getAction(), null);
        workflowType = "AM_API_STATE";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonAPIStateGetResponse = response.getData();
        String apiStateChangeNewExternalWorkflowRef = null;
        workflowRespObj = new JSONObject(response.getData());
        arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("apiName") || !apiName.equals(properties.get("apiName"))) continue;
            apiStateChangeNewExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Workflow reference is not available ", apiStateChangeNewExternalWorkflowRef);
        response = this.restAPIAdmin.updateWorkflowStatus(apiStateChangeNewExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Update workflow pending process is failed for user admin");
        workflowType = "AM_APPLICATION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonApplicationCreation = response.getData();
        String applicationCreationNewExternalWorkflowRef = null;
        workflowRespObj = new JSONObject(response.getData());
        arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !applicationName.equals(properties.get("applicationName"))) continue;
            applicationCreationNewExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Application workflow reference is not available ", applicationCreationNewExternalWorkflowRef);
        response = this.restAPIAdmin.updateWorkflowStatus(applicationCreationNewExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Update workflow pending process is failed for user admin");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse SubscribeResponse = this.restAPIStore.createSubscription(apiIdSecond, applicationIDSecond, "Unlimited");
        this.subscriptionId = SubscribeResponse.getData();
        org.testng.Assert.assertEquals((int)SubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of  API  request not successful");
        workflowType = "AM_SUBSCRIPTION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonSubscriptionCreationGet = response.getData();
        String subscriptionCreationExternalWorkflowRef = null;
        workflowRespObj = new JSONObject(response.getData());
        arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !applicationName.equals(properties.get("applicationName")) || !properties.has("apiName") || !apiName.equals(properties.get("apiName"))) continue;
            subscriptionCreationExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"Subscription workflow reference is not available ", subscriptionCreationExternalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(subscriptionCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationIDSecond, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        workflowType = "AM_APPLICATION_REGISTRATION_PRODUCTION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonKeyGenerationGetResponse = response.getData();
        String keyGenerationExternalWorkflowRef = null;
        workflowRespObj = new JSONObject(response.getData());
        arr = (JSONArray)workflowRespObj.get("list");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject listItem = (JSONObject)arr.get(i);
            properties = (JSONObject)listItem.get("properties");
            if (!properties.has("applicationName") || !applicationName.equals(properties.get("applicationName"))) continue;
            keyGenerationExternalWorkflowRef = (String)listItem.get("referenceId");
        }
        Assert.assertNotNull((String)"application key workflow reference is not available ", keyGenerationExternalWorkflowRef);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(keyGenerationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        this.restAPIStore.deleteApplication(applicationIDSecond);
        this.removeDeletePendingApplication(applicationName);
        this.undeployAndDeleteAPIRevisionsUsingRest(apiIdSecond, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(apiIdSecond);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(subscriptionCreationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Subscription Creation");
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(keyGenerationExternalWorkflowRef);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Application Key generation");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.removeDeletePendingApplication(this.applicationName);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.userManagementClient.deleteUser(this.USER_SMITH);
        this.userManagementClient.deleteUser(this.USER_ADMIN);
        this.userManagementClient.deleteUser("JaneDoe");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.originalWFExtentionsXML);
        super.cleanUp();
    }
}

