/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;

public class APILoggingServerRestartTest
extends APIManagerLifecycleBaseTest {
    private String apiLoggingApplicationId;

    @BeforeClass(alwaysRun=true)
    public void initialize(ITestContext ctx) throws Exception {
        super.init();
        this.apiLoggingApplicationId = (String)ctx.getAttribute("apiLoggingApplicationId");
    }

    @Test(groups={"wso2.am"}, description="Sending http request to per API logging enabled API: ")
    public void testAPIPerAPILoggingTestcase() throws Exception {
        String logLine;
        String API_NAME = "APILoggingTestAPI";
        String API_CONTEXT = "apiloggingtest";
        String API_VERSION = "1.0.0";
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APILoggingTestAPI", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.apiLoggingApplicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION));
        request.setHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        String apiLogFilePath = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "logs" + File.separator + "api.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((boolean)logLine.contains("INFO {API_LOG} " + API_NAME));
        }
    }
}

