/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIThrottlingServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIThrottlingServerRestartTestCase.class);
    private String apiThrottleAccessToken;

    @BeforeClass
    public void initialize(ITestContext ctx) throws Exception {
        super.init();
        this.apiThrottleAccessToken = (String)ctx.getAttribute("apiThrottleAccessToken");
    }

    @Test(groups={"throttling"}, description="API Throttling Test")
    public void testAPIThrottling_1() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIThrottleAPI", "1.0.0", "\"isApiExists\":true");
        String invokeURL = this.getAPIInvocationURLHttps("api_throttle");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)this.apiThrottleAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        log.info((Object)("=============================== Headers : " + requestHeaders));
        log.info((Object)("=============================== invokeURL : " + invokeURL));
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.checkThrottling(invokeURL, requestHeaders);
    }

    private void checkThrottling(String invokeURL, Map<String, String> requestHeaders) {
        int limit = 4;
        int numberOfIterations = 4;
        for (int count = 0; count < numberOfIterations; ++count) {
            try {
                log.info((Object)(" =================================== Number of time API Invoked : " + count));
                if (count == limit) {
                    Thread.sleep(10000L);
                }
                HttpResponse serviceResponse = this.callAPI(invokeURL, requestHeaders);
                if (count == limit) {
                    Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)429, (String)"Response code is not as expected");
                    continue;
                }
                Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Error occurred while calling API : " + ex));
                break;
            }
        }
    }

    private HttpResponse callAPI(String invokeURL, Map<String, String> requestHeaders) throws Exception {
        return HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
    }
}

