/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfBlockAPIServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_CONTEXT = "BlockAPI";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private Map<String, String> requestHeaders;
    private String accessibilityOfBlockApiId;
    private String accessibilityOfBlockApplicationId;

    @BeforeClass(alwaysRun=true)
    public void initialize(ITestContext ctx) throws APIManagerIntegrationTestException {
        super.init();
        this.accessibilityOfBlockApplicationId = (String)ctx.getAttribute("accessibilityOfBlockApplicationId");
        this.accessibilityOfBlockApiId = (String)ctx.getAttribute("accessibilityOfBlockApiId");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before block")
    public void testInvokeAPIBeforeChangeAPILifecycleToBlock() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BlockAPITest", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> accessibilityOfBlockGrantTypes = new ArrayList<String>();
        accessibilityOfBlockGrantTypes.add("client_credentials");
        ApplicationKeyDTO accessibilityOfBlockApplicationKeyDTO = this.restAPIStore.generateKeys(this.accessibilityOfBlockApplicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, accessibilityOfBlockGrantTypes);
        Assert.assertNotNull((Object)accessibilityOfBlockApplicationKeyDTO.getToken());
        String accessibilityOfBlockAccessToken = accessibilityOfBlockApplicationKeyDTO.getToken().getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessibilityOfBlockAccessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before block");
        String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke  API  before block Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to block", dependsOnMethods={"testInvokeAPIBeforeChangeAPILifecycleToBlock"})
    public void testChangeAPILifecycleToBlock() throws Exception {
        HttpResponse response = this.restAPIPublisher.changeAPILifeCycleStatus(this.accessibilityOfBlockApiId, APILifeCycleAction.BLOCK.getAction(), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.accessibilityOfBlockApiId));
    }

    @Test(groups={"wso2.am"}, description="Invocation og the APi after block", dependsOnMethods={"testChangeAPILifecycleToBlock"})
    public void testInvokeAPIAfterChangeAPILifecycleToBlock() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE, (String)"Response code mismatched when invoke api after block");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("{\"code\":\"700700\",\"type\":\"API blocked\",\"description\":\"This API has been blocked temporarily. Please try again later or contact the system administrators.\"}"), (String)("Response data mismatched when invoke  API  after block Response Data:" + oldVersionInvokeResponse.getData()));
    }
}

