/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class BurstControlServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private String burstControlApiId;
    private ApplicationDTO burstControlApplicationDTO;
    private final Log log = LogFactory.getLog(BurstControlServerRestartTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment(ITestContext ctx) throws Exception {
        super.init();
        this.burstControlApiId = (String)ctx.getAttribute("burstControlApiId");
        this.burstControlApplicationDTO = (ApplicationDTO)ctx.getAttribute("burstControlApplicationDTO");
    }

    @Test(groups={"wso2.am"}, description="Test changing the burst limit of an API subscription by subscribing to a different subscription policy with different burst limit")
    public void testBurstLimitChange() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIThrottleBurstAPI", "1.0.0", "\"isApiExists\":true");
        String subscriptionTier5RPMburst = "SubscriptionTier5RPMburst";
        SubscriptionDTO subscriptionDTO1 = this.restAPIStore.subscribeToAPI(this.burstControlApiId, this.burstControlApplicationDTO.getApplicationId(), subscriptionTier5RPMburst);
        Assert.assertEquals((String)subscriptionTier5RPMburst, (String)subscriptionDTO1.getThrottlingPolicy(), (String)("Error occurred while subscribing to the api. Subscribed policy is not as expected as " + subscriptionTier5RPMburst));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.burstControlApplicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        String APIVersion = "1.0.0";
        String APIContext = "api_burst";
        String apiInvocationUrl = this.getAPIInvocationURLHttps(APIContext + "/" + APIVersion + "/");
        int burstLimit1 = 5;
        this.checkThrottling(apiInvocationUrl, requestHeaders, burstLimit1);
        this.log.info((Object)("Old subscription id:" + subscriptionDTO1.getSubscriptionId()));
        HttpResponse httpResponse = this.restAPIStore.removeSubscription(subscriptionDTO1);
        this.log.info((Object)("httpResponse of removeSubscription ====== : " + httpResponse));
        this.log.info((Object)("AAA= " + subscriptionDTO1));
        Thread.sleep(5000L);
        String subscriptionTier25RPMburst = "SubscriptionTier25RPMburst";
        SubscriptionDTO subscriptionDTO2 = this.restAPIStore.subscribeToAPI(this.burstControlApiId, this.burstControlApplicationDTO.getApplicationId(), subscriptionTier25RPMburst);
        Assert.assertEquals((String)subscriptionTier25RPMburst, (String)subscriptionDTO2.getThrottlingPolicy(), (String)("Error occurred while subscribing to the api. Subscribed policy is not as expected as " + subscriptionTier25RPMburst));
        Thread.sleep(60000L);
        int burstLimit2 = 25;
        this.checkThrottling(apiInvocationUrl, requestHeaders, burstLimit2);
    }

    private void checkThrottling(String invokeURL, Map<String, String> requestHeaders, int limit) throws IOException, InterruptedException {
        for (int count = 1; count < limit + 2; ++count) {
            HttpResponse apiCallResponse;
            String payload = "{\"payload\" : \"test\"}";
            if (count > limit) {
                boolean isThrottled = false;
                while (count < limit + 10) {
                    apiCallResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)payload);
                    if (apiCallResponse.getResponseCode() == 429) {
                        isThrottled = true;
                        break;
                    }
                    Thread.sleep(500L);
                    ++count;
                }
                Assert.assertTrue((boolean)isThrottled, (String)"Throttling has't happened at the expected count");
                continue;
            }
            apiCallResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)payload);
            if (apiCallResponse.getResponseCode() == 429) {
                Assert.fail((String)("Throttling has happened at the count : " + count + ". But expected to throttle after the request count " + limit));
                continue;
            }
            Assert.assertEquals((int)apiCallResponse.getResponseCode(), (int)200, (String)"API invocation Response code is not as expected");
        }
    }
}

