/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.util.UUID;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class CustomThrottlingPolicyServerRestartTestCase
extends APIMIntegrationBaseTest {
    private String customThrottlingPolicyId;
    private CustomRuleDTO customThrottlingRuleDTO;
    private AdminApiTestHelper customThrottlingAdminApiTestHelper;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment(ITestContext ctx) throws Exception {
        super.init();
        this.customThrottlingPolicyId = (String)ctx.getAttribute("customThrottlingPolicyId");
        this.customThrottlingRuleDTO = (CustomRuleDTO)ctx.getAttribute("customThrottlingRuleDTO");
        this.customThrottlingAdminApiTestHelper = (AdminApiTestHelper)ctx.getAttribute("customThrottlingAdminApiTestHelper");
    }

    @Test(groups={"wso2.am"}, description="Test get custom throttling policy")
    public void testGetPolicy() throws ApiException {
        if (this.userMode == TestUserMode.TENANT_ADMIN) {
            this.customThrottlingPolicyId = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        }
        ApiResponse retrievedPolicy = this.restAPIAdmin.getCustomThrottlingPolicy(this.customThrottlingPolicyId);
        CustomRuleDTO retrievedPolicyDTO = (CustomRuleDTO)retrievedPolicy.getData();
        Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
        this.customThrottlingAdminApiTestHelper.verifyCustomThrottlePolicyDTO(this.customThrottlingRuleDTO, retrievedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test update custom throttling policy", dependsOnMethods={"testGetPolicy"})
    public void testUpdatePolicy() throws ApiException {
        String updatedDescription = "This is a updated test custom throttle policy";
        this.customThrottlingRuleDTO.setDescription(updatedDescription);
        ApiResponse updatedPolicy = this.restAPIAdmin.updateCustomThrottlingPolicy(this.customThrottlingPolicyId, this.customThrottlingRuleDTO);
        CustomRuleDTO updatedPolicyDTO = (CustomRuleDTO)updatedPolicy.getData();
        Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
        this.customThrottlingAdminApiTestHelper.verifyCustomThrottlePolicyDTO(this.customThrottlingRuleDTO, updatedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add custom throttling policy with existing policy name", dependsOnMethods={"testUpdatePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addCustomThrottlingPolicy(this.customThrottlingRuleDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete custom throttling policy", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicy() throws ApiException {
        ApiResponse apiResponse = this.restAPIAdmin.deleteCustomThrottlingPolicy(this.customThrottlingPolicyId);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test delete custom throttling policy with non existing policy ID", dependsOnMethods={"testDeletePolicy"})
    public void testDeletePolicyWithNonExistentPolicyId() {
        try {
            this.restAPIAdmin.deleteCustomThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }
}

