/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDefaultVersionURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;

public class DefaultVersionAPIServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private String defaultVersionApiId;
    String defaultVersionAccessToken;
    String newAPIVersion;

    @BeforeClass
    public void initialize(ITestContext ctx) throws Exception {
        super.init();
        this.defaultVersionApiId = (String)ctx.getAttribute("defaultVersionApiId");
        this.defaultVersionAccessToken = (String)ctx.getAttribute("defaultVersionAccessToken");
    }

    @Test(groups={"wso2.am"}, description="Create new version of API with default Version enable in created stage and verify")
    public void createNewVersionWithDefaultVersionOptionAndVerifyDefaultAPIBreaking() throws Exception {
        this.waitForAPIDeploymentSync(this.publisherContext.getContextTenant().getContextUser().getUserName(), "DefaultVersionAPI", "1.0.0", "\"isApiExists\":true");
        String apiVersion = "2.0.0";
        String apiContext = "defaultversion";
        String endpointUrl = this.getGatewayURLNhttp() + "version2";
        this.newAPIVersion = this.restAPIPublisher.createNewAPIVersion(apiVersion, this.defaultVersionApiId, true);
        APIDTO storeAPI = this.restAPIStore.getAPI(this.defaultVersionApiId);
        List endpointURLs = storeAPI.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse directResponse = this.invokeWithGet(endpointUrl, new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.defaultVersionAccessToken);
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.newAPIVersion, false);
        defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO newVersionAPI = this.restAPIPublisher.getAPIByID(this.newAPIVersion);
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)newVersionAPI.getEndpointConfig());
        Map productionEndpoint = (Map)endpointConfigJson.get((Object)"production_endpoints");
        productionEndpoint.replace("url", endpointUrl);
        newVersionAPI.setEndpointConfig((Object)endpointConfigJson);
        this.restAPIPublisher.updateAPI(newVersionAPI);
        APIRevisionDTO apiRevisionDTO = this.restAPIPublisher.addAPIRevision(this.newAPIVersion);
        APIRevisionDeployUndeployRequest apiRevisionDeployUndeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployUndeployRequest.setName("Default");
        apiRevisionDeployUndeployRequest.setVhost("localhost");
        apiRevisionDeployUndeployRequest.setDisplayOnDevportal(true);
        this.restAPIPublisher.deployAPIRevision(this.newAPIVersion, apiRevisionDTO.getId(), apiRevisionDeployUndeployRequest, "API");
        APIDTO storeAPIAfterUpdate = this.restAPIStore.getAPI(this.defaultVersionApiId);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        APIDTO newVersionFromStore = this.restAPIStore.getAPI(this.newAPIVersion);
        endpointURLs = newVersionFromStore.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        this.waitForAPIDeploymentSync(newVersionFromStore.getProvider(), newVersionFromStore.getName(), newVersionFromStore.getVersion(), "\"isApiExists\":true");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse1 = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)defaultHttpResponse1.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
        Assert.assertEquals((String)((String)defaultHttpResponse1.getHeaders().get("Version")), (String)"v2");
    }

    @Test(groups={"wso2.am"}, description="change default Version back to v1", dependsOnMethods={"createNewVersionWithDefaultVersionOptionAndVerifyDefaultAPIBreaking"})
    public void changeNewVersionBacktoV1AndVerify() throws Exception {
        String apiContext = "defaultversion";
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO oldAPI = this.restAPIPublisher.getAPIByID(this.defaultVersionApiId);
        oldAPI.setIsDefaultVersion(Boolean.valueOf(true));
        this.restAPIPublisher.updateAPI(oldAPI);
        APIDTO storeAPI = this.restAPIStore.getAPI(this.defaultVersionApiId);
        List endpointURLs = storeAPI.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.defaultVersionAccessToken);
        this.waitForAPIDeployment();
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, headers);
        Assert.assertEquals((String)((String)defaultHttpResponse.getHeaders().get("Version")), (String)"v1");
        APIDTO storeAPIAfterUpdate = this.restAPIStore.getAPI(this.newAPIVersion);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        oldAPI = this.restAPIPublisher.getAPIByID(this.defaultVersionApiId);
        oldAPI.setIsDefaultVersion(Boolean.valueOf(false));
        this.restAPIPublisher.updateAPI(oldAPI);
        defaultHttpResponse = this.invokeDefaultAPIWithWait(defaultVersionAPIInvocationUrl, headers, 404);
        Assert.assertEquals((int)defaultHttpResponse.getResponseCode(), (int)404);
        storeAPIAfterUpdate = this.restAPIStore.getAPI(this.defaultVersionApiId);
        endpointURLs = storeAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)endpointURLs);
        Assert.assertEquals((int)endpointURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)endpointURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeDefaultAPIWithWait(String invocationUrl, Map<String, String> headers, int statusCode) throws IOException, InterruptedException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.invokeWithGet(invocationUrl, headers);
        int count = 0;
        if (response.getResponseCode() != statusCode) {
            do {
                Thread.sleep(10000L);
                response = this.invokeWithGet(invocationUrl, headers);
                if (response.getResponseCode() != 200) continue;
                return response;
            } while (++count > 6);
        }
        return response;
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeWithGet(String url, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        headers.forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        InputStream stream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)stream);
        HashMap<String, String> outputHeaders = new HashMap<String, String>();
        for (Header header : response.getAllHeaders()) {
            outputHeaders.put(header.getName(), header.getValue());
        }
        return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(content, response.getStatusLine().getStatusCode(), outputHeaders);
    }
}

