/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTBandwidthThrottlingServerRestartTestCase
extends APIMIntegrationBaseTest {
    private String jwtBandwidthApiId;
    private String jwtBandwidthGatewayUrl;
    String app1Id;
    String app2Id;
    String app3Id;
    private final String body = "{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}";
    private static final Log log = LogFactory.getLog(JWTBandwidthThrottlingServerRestartTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment(ITestContext ctx) throws Exception {
        super.init();
        this.jwtBandwidthApiId = (String)ctx.getAttribute("jwtBandwidthApiId");
        this.jwtBandwidthGatewayUrl = (String)ctx.getAttribute("jwtBandwidthGatewayUrl");
    }

    @Test(groups={"wso2.am"})
    public void testApplicationLevelThrottling() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BandwidthTestAPI", "1.0.0", "\"isApiExists\":true");
        String appPolicyName = "AppPolicyWithBandwidth";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("ApplicationBandwidthtestapp", appPolicyName, "", "this-is-test");
        this.app1Id = applicationDTO.getApplicationId();
        Assert.assertEquals((String)appPolicyName, (String)applicationDTO.getThrottlingPolicy());
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.jwtBandwidthApiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.jwtBandwidthGatewayUrl, requestHeaders, (String)"{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}");
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
    }

    @Test(groups={"wso2.am"})
    public void testSubscriptionLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("SubscriptionBandwidthtestapp", "Unlimited", "", "this-is-test");
        this.app2Id = applicationDTO.getApplicationId();
        String subPolicyName = "SubPolicyWithBandwidth";
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.jwtBandwidthApiId, applicationDTO.getApplicationId(), subPolicyName);
        Assert.assertEquals((String)subPolicyName, (String)subscriptionDTO.getThrottlingPolicy());
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.jwtBandwidthGatewayUrl, requestHeaders, (String)"{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}");
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
    }

    @Test(groups={"wso2.am"}, dependsOnMethods={"testSubscriptionLevelThrottling", "testApplicationLevelThrottling"})
    public void testAPILevelThrottling() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.jwtBandwidthApiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        String apiPolicyName = "APIPolicyWithBandwidth";
        apidto.setApiThrottlingPolicy(apiPolicyName);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.jwtBandwidthApiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)apiPolicyName, (String)"API tier not updated.");
        this.createAPIRevisionAndDeployUsingRest(this.jwtBandwidthApiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("NormalAPP", "Unlimited", "", "this-is-test");
        this.app3Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.jwtBandwidthApiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.jwtBandwidthGatewayUrl, requestHeaders, (String)"{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}");
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.app1Id);
        this.restAPIStore.deleteApplication(this.app2Id);
        this.restAPIStore.deleteApplication(this.app3Id);
    }
}

