/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTRevocationServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private String consumerKey;
    private String consumerSecret;
    private Map<String, String> requestHeaders;
    private String apiInvocationUrl;
    private String accessToken;
    private String jwtRevocationAppId;

    @BeforeClass
    public void initialize(ITestContext ctx) throws Exception {
        super.init();
        this.jwtRevocationAppId = (String)ctx.getAttribute("jwtRevocationAppId");
        ArrayList<String> jwtRevocationGrantTypes = new ArrayList<String>();
        jwtRevocationGrantTypes.add("client_credentials");
        ApplicationKeyDTO jwtRevocationApplicationKeyDTO = this.restAPIStore.generateKeys(this.jwtRevocationAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, jwtRevocationGrantTypes);
        org.testng.Assert.assertNotNull((Object)jwtRevocationApplicationKeyDTO.getToken());
        this.accessToken = jwtRevocationApplicationKeyDTO.getToken().getAccessToken();
        this.consumerKey = jwtRevocationApplicationKeyDTO.getConsumerKey();
        this.consumerSecret = jwtRevocationApplicationKeyDTO.getConsumerSecret();
        this.apiInvocationUrl = this.getAPIInvocationURLHttp("jwtTokenTestAPI/1.0.0/customers/123");
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + this.accessToken);
    }

    @Test(groups={"wso2.am"}, description="testing jwt token revocation")
    public void testJWTTokenRevocation() throws Exception {
        HttpResponse invocationResponseAfterRevoked;
        boolean isTokenValid;
        this.waitForAPIDeploymentSync(this.user.getUserName(), "JWTTokenTestAPI", "1.0.0", "\"isApiExists\":true");
        HttpResponse invocationResponse = HttpRequestUtil.doGet((String)this.apiInvocationUrl, this.requestHeaders);
        org.testng.Assert.assertEquals((int)invocationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before Retire");
        org.testng.Assert.assertTrue((boolean)invocationResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke  API  before Retire Response Data:" + invocationResponse.getData()));
        HashMap<String, String> revokeRequestHeaders = new HashMap<String, String>();
        String basicAuthHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])basicAuthHeader.getBytes(StandardCharsets.UTF_8));
        revokeRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, StandardCharsets.UTF_8));
        String input = "token=" + this.accessToken;
        URL revokeEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/revoke");
        try {
            HttpResponse revokeResponse = HTTPSClientUtils.doPost((URL)revokeEndpointURL, (String)input, revokeRequestHeaders);
            org.testng.Assert.assertEquals((int)revokeResponse.getResponseCode(), (int)200);
            org.testng.Assert.assertEquals((String)((String)revokeResponse.getHeaders().get("RevokedAccessToken")), (String)this.accessToken, (String)"Access token is not revoked correctly");
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw any exceptions" + e));
        }
        int counter = 1;
        do {
            Thread.sleep(1000L);
            invocationResponseAfterRevoked = HttpRequestUtil.doGet((String)this.apiInvocationUrl, this.requestHeaders);
            int invocationResponseCodeAfterRevoked = invocationResponseAfterRevoked.getResponseCode();
            if (invocationResponseCodeAfterRevoked == HTTP_RESPONSE_CODE_UNAUTHORIZED) {
                isTokenValid = false;
                continue;
            }
            if (invocationResponseCodeAfterRevoked == HTTP_RESPONSE_CODE_OK) {
                isTokenValid = true;
                continue;
            }
            throw new APIManagerIntegrationTestException("Unexpected response received when invoking the API. Response received :" + invocationResponseAfterRevoked.getData() + ":" + invocationResponseAfterRevoked.getResponseMessage());
        } while (isTokenValid && ++counter < 20);
        org.testng.Assert.assertFalse((boolean)isTokenValid, (String)("Access token revocation failed. API invocation response code is expected to be : " + HTTP_RESPONSE_CODE_UNAUTHORIZED + ", but got " + invocationResponseAfterRevoked.getResponseCode()));
    }
}

