/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.restart;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.plexus.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDefaultVersionURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class ServerRestartTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ServerRestartTestCase.class);
    private String apiThrottleApplicationId;
    private String apiThrottleApiId;
    private String defaultVersionApplicationID;
    private String defaultVersionApiId;
    private String jwtRevocationAppId;
    private String jwtRevocationApiId;
    private String apiRevisionApiId;
    private String accessibilityOfBlockApiId;
    private String accessibilityOfBlockApplicationId;
    private String jwtBandwidthApiId;
    private String jwtBandwidthApiPolicyId;
    private String jwtBandwidthAppPolicyId;
    private String jwtBandwidthSubPolicyId;
    private ApplicationDTO burstControlApplicationDTO;
    private String burstControlApiId;
    private SubscriptionThrottlePolicyDTO burstControlSubscriptionThrottlePolicyDTO1;
    private SubscriptionThrottlePolicyDTO burstControlSubscriptionThrottlePolicyDTO2;
    private String graphQLAPIId;
    private String apiLoggingApiId;
    private String apiLoggingApplicationId;
    private static final String BASIC_AUTH_HEADER = "admin:admin";

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public ServerRestartTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeSuite(alwaysRun=true)
    public void setEnvironment(ITestContext ctx) throws Exception {
        super.init(this.userMode);
        String API_VERSION_1_0_0 = "1.0.0";
        String apiThrottleBackendURL = this.getSuperTenantAPIInvocationURLHttp("api_throttle_backend", "1.0");
        ArrayList<APIOperationsDTO> apiThrottleApiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiThrottleApiOperationsDTO = new APIOperationsDTO();
        apiThrottleApiOperationsDTO.setVerb("GET");
        apiThrottleApiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType());
        apiThrottleApiOperationsDTO.setThrottlingPolicy("20KPerMin");
        apiThrottleApiOperationsDTO.setTarget("/test");
        apiThrottleApiOperationsDTOS.add(apiThrottleApiOperationsDTO);
        APIRequest apiThrottleApiRequest = new APIRequest("APIThrottleAPI", "api_throttle", new URL(apiThrottleBackendURL));
        apiThrottleApiRequest.setVersion("1.0.0");
        apiThrottleApiRequest.setProvider(this.user.getUserName());
        apiThrottleApiRequest.setTiersCollection("Unlimited");
        apiThrottleApiRequest.setTier("Unlimited");
        apiThrottleApiRequest.setOperationsDTOS(apiThrottleApiOperationsDTOS);
        apiThrottleApiRequest.setTags("token, throttling");
        apiThrottleApiRequest.setDescription("This is test API created by API manager integration test");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiThrottleApplicationResponse = this.restAPIStore.createApplication("APIThrottle-application", "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)apiThrottleApplicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.apiThrottleApplicationId = apiThrottleApplicationResponse.getData();
        Assert.assertNotNull((Object)this.apiThrottleApplicationId);
        this.apiThrottleApiId = this.createPublishAndSubscribeToAPIUsingRest(apiThrottleApiRequest, this.restAPIPublisher, this.restAPIStore, this.apiThrottleApplicationId, "Unlimited");
        Assert.assertNotNull((Object)this.apiThrottleApiId);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIThrottleAPI", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> apiThrottleGrantTypes = new ArrayList<String>();
        apiThrottleGrantTypes.add("client_credentials");
        ApplicationKeyDTO apiThrottleApplicationKeyDTO = this.restAPIStore.generateKeys(this.apiThrottleApplicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, apiThrottleGrantTypes);
        Assert.assertNotNull((Object)apiThrottleApplicationKeyDTO.getToken());
        String apiThrottleAccessToken = apiThrottleApplicationKeyDTO.getToken().getAccessToken();
        ctx.setAttribute("apiThrottleAccessToken", (Object)apiThrottleAccessToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultVersionApplicationResponse = this.restAPIStore.createApplication("DefaultVersionAPP", "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.defaultVersionApplicationID = defaultVersionApplicationResponse.getData();
        ArrayList<String> defaultVersionGrantTypes = new ArrayList<String>();
        defaultVersionGrantTypes.add("client_credentials");
        ApplicationKeyDTO defaultVersionApplicationKeyDTO = this.restAPIStore.generateKeys(this.defaultVersionApplicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, defaultVersionGrantTypes);
        Assert.assertNotNull((Object)defaultVersionApplicationKeyDTO.getToken());
        String defaultVersionAccessToken = defaultVersionApplicationKeyDTO.getToken().getAccessToken();
        String defaultVersionBackendUrl = this.getGatewayURLNhttp() + "version1";
        APIRequest defaultVersionApiRequest = new APIRequest("DefaultVersionAPI", "defaultversion", new URL(defaultVersionBackendUrl));
        defaultVersionApiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
        defaultVersionApiRequest.setVersion("1.0.0");
        defaultVersionApiRequest.setTiersCollection("Unlimited");
        defaultVersionApiRequest.setTier("Unlimited");
        this.defaultVersionApiId = this.createPublishAndSubscribeToAPIUsingRest(defaultVersionApiRequest, this.restAPIPublisher, this.restAPIStore, this.defaultVersionApplicationID, "Unlimited");
        this.waitForAPIDeploymentSync(defaultVersionApiRequest.getProvider(), defaultVersionApiRequest.getName(), defaultVersionApiRequest.getVersion(), "\"isApiExists\":true");
        APIDTO defaultVersionStoreAPI = this.restAPIStore.getAPI(this.defaultVersionApiId);
        List defaultVersionBackendURLs = defaultVersionStoreAPI.getEndpointURLs();
        Assert.assertNotNull((Object)defaultVersionBackendURLs);
        Assert.assertEquals((int)defaultVersionBackendURLs.size(), (int)1);
        APIDefaultVersionURLsDTO defaultVersionURLs = ((APIEndpointURLsDTO)defaultVersionBackendURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNull((Object)defaultVersionURLs.getHttps());
        Assert.assertNull((Object)defaultVersionURLs.getWs());
        Assert.assertNull((Object)defaultVersionURLs.getWss());
        String versionAPIInvocationUrl = this.getAPIInvocationURLHttp("defaultversion", "1.0.0");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultVersionDirectResponse = this.invokeWithGet(defaultVersionBackendUrl, new HashMap<String, String>());
        HashMap<String, String> defaultVersionRequestHeaders = new HashMap<String, String>();
        defaultVersionRequestHeaders.put("Authorization", "Bearer " + defaultVersionAccessToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultVersionHttpResponse = this.invokeWithGet(versionAPIInvocationUrl, defaultVersionRequestHeaders);
        Assert.assertEquals((String)defaultVersionHttpResponse.getData(), (String)defaultVersionDirectResponse.getData(), (String)"Default version API test failed while invoking the API.");
        String defaultVersionAPIInvocationUrl = this.getAPIInvocationURLHttp("defaultversion");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultHttpResponse = this.invokeWithGet(defaultVersionAPIInvocationUrl, defaultVersionRequestHeaders);
        Assert.assertEquals((int)defaultHttpResponse.getResponseCode(), (int)404);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO defaultVersionApiv1 = this.restAPIPublisher.getAPIByID(this.defaultVersionApiId);
        defaultVersionApiv1.setIsDefaultVersion(Boolean.valueOf(true));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO defaultVersionApidto = this.restAPIPublisher.updateAPI(defaultVersionApiv1);
        Assert.assertNotNull((Object)defaultVersionApidto);
        Assert.assertTrue((boolean)defaultVersionApidto.isIsDefaultVersion());
        APIDTO defaultVersionStoreAPIAfterUpdate = this.restAPIStore.getAPI(this.defaultVersionApiId);
        defaultVersionBackendURLs = defaultVersionStoreAPIAfterUpdate.getEndpointURLs();
        Assert.assertNotNull((Object)defaultVersionBackendURLs);
        Assert.assertEquals((int)defaultVersionBackendURLs.size(), (int)1);
        defaultVersionURLs = ((APIEndpointURLsDTO)defaultVersionBackendURLs.get(0)).getDefaultVersionURLs();
        Assert.assertNotNull((Object)defaultVersionURLs);
        Assert.assertNotNull((Object)defaultVersionURLs.getHttp());
        Assert.assertNotNull((Object)defaultVersionURLs.getHttps());
        this.waitForAPIDeploymentSync(defaultVersionApiRequest.getProvider(), defaultVersionApiRequest.getName(), defaultVersionApiRequest.getVersion(), "\"isApiExists\":true");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse defaultVersionHttpResponse1 = this.invokeDefaultAPIWithWait(defaultVersionAPIInvocationUrl, defaultVersionRequestHeaders, 200);
        Assert.assertEquals((String)defaultVersionHttpResponse1.getData(), (String)defaultVersionDirectResponse.getData(), (String)"Default version API test failed while invoking the API.");
        log.info((Object)("version : " + (String)defaultVersionHttpResponse1.getHeaders().get("Version")));
        Assert.assertEquals((String)((String)defaultVersionHttpResponse1.getHeaders().get("Version")), (String)"v1");
        ctx.setAttribute("defaultVersionApiId", (Object)this.defaultVersionApiId);
        ctx.setAttribute("defaultVersionAccessToken", (Object)defaultVersionAccessToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse jwtRevocationApplicationResponse = this.restAPIStore.createApplication("JWTTokenRevocationTest-Application", "This is a test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtRevocationAppId = jwtRevocationApplicationResponse.getData();
        String jwtRevocationBackendUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest jwtRevocationApiRequest = new APIRequest("JWTTokenTestAPI", "jwtTokenTestAPI", new URL(jwtRevocationBackendUrl));
        jwtRevocationApiRequest.setVersion("1.0.0");
        jwtRevocationApiRequest.setTiersCollection("Unlimited");
        jwtRevocationApiRequest.setTier("Unlimited");
        this.jwtRevocationApiId = this.createPublishAndSubscribeToAPIUsingRest(jwtRevocationApiRequest, this.restAPIPublisher, this.restAPIStore, this.jwtRevocationAppId, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "JWTTokenTestAPI", API_VERSION_1_0_0, "\"isApiExists\":true");
        ctx.setAttribute("jwtRevocationAppId", (Object)this.jwtRevocationAppId);
        ctx.setAttribute("jwtRevocationApiId", (Object)this.jwtRevocationApiId);
        String apiRevisionBackendUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRevisionApiRequest = new APIRequest("RevisionTestAPI", "revisiontestapi", new URL(apiRevisionBackendUrl));
        apiRevisionApiRequest.setVersion(API_VERSION_1_0_0);
        apiRevisionApiRequest.setTiersCollection("Unlimited");
        apiRevisionApiRequest.setTier("Unlimited");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionApiResponse = this.restAPIPublisher.addAPI(apiRevisionApiRequest);
        this.apiRevisionApiId = apiRevisionApiResponse.getData();
        Assert.assertEquals((int)apiRevisionApiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + this.apiRevisionApiId));
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiRevisionApiDto = this.restAPIPublisher.getAPI(apiRevisionApiResponse.getData());
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiRevisionApiDto.getData()), (String)("Added Api is not available in APi Publisher. API ID " + this.apiRevisionApiId));
        ctx.setAttribute("apiRevisionApiId", (Object)this.apiRevisionApiId);
        String accessibilityOfBlockApiBackendUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse accessibilityOfBlockApplicationResponse = this.restAPIStore.createApplication("AccessibilityOfBlockAPITestCase", "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.accessibilityOfBlockApplicationId = accessibilityOfBlockApplicationResponse.getData();
        APIRequest accessibilityOfBlockApiRequest = new APIRequest("BlockAPITest", "BlockAPI", new URL(accessibilityOfBlockApiBackendUrl));
        accessibilityOfBlockApiRequest.setVersion(API_VERSION_1_0_0);
        accessibilityOfBlockApiRequest.setTiersCollection("Unlimited");
        accessibilityOfBlockApiRequest.setTier("Unlimited");
        accessibilityOfBlockApiRequest.setProvider(this.user.getUserName());
        this.accessibilityOfBlockApiId = this.createPublishAndSubscribeToAPIUsingRest(accessibilityOfBlockApiRequest, this.restAPIPublisher, this.restAPIStore, this.accessibilityOfBlockApplicationId, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BlockAPITest", API_VERSION_1_0_0, "\"isApiExists\":true");
        ctx.setAttribute("accessibilityOfBlockApplicationId", (Object)this.accessibilityOfBlockApplicationId);
        ctx.setAttribute("accessibilityOfBlockApiId", (Object)this.accessibilityOfBlockApiId);
        ArrayList<String> jwtBandwidthRoleList = new ArrayList<String>();
        BandwidthLimitDTO jwtBandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)"min", (Integer)1, (Long)1L, (String)"KB");
        ThrottleLimitDTO jwtBandwidthDefaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)jwtBandwidthLimit);
        jwtBandwidthRoleList.add("Internal/everyone");
        SubscriptionThrottlePolicyPermissionDTO jwtBandwidthPermissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, jwtBandwidthRoleList);
        ApplicationThrottlePolicyDTO jwtBandwidthApplicationPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)"AppPolicyWithBandwidth", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)jwtBandwidthDefaultLimit);
        ApiResponse jwtBandwidthAddedApplicationPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(jwtBandwidthApplicationPolicyDTO);
        Assert.assertEquals((int)jwtBandwidthAddedApplicationPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO jwtBandwidthAddedApplicationPolicyDTO = (ApplicationThrottlePolicyDTO)jwtBandwidthAddedApplicationPolicy.getData();
        this.jwtBandwidthAppPolicyId = jwtBandwidthAddedApplicationPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.jwtBandwidthAppPolicyId, (String)"The policy ID cannot be null or empty");
        SubscriptionThrottlePolicyDTO jwtBandwidthSubscriptionPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)"SubPolicyWithBandwidth", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)jwtBandwidthDefaultLimit, (int)-1, (int)-1, (int)100, (String)"min", new ArrayList(), (boolean)true, (String)"", (int)0, (SubscriptionThrottlePolicyPermissionDTO)jwtBandwidthPermissions);
        ApiResponse jwtBandwidthAddedSubscriptionPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(jwtBandwidthSubscriptionPolicyDTO);
        Assert.assertEquals((int)jwtBandwidthAddedSubscriptionPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO jwtBandwidthAddedSubscriptionPolicyDTO = (SubscriptionThrottlePolicyDTO)jwtBandwidthAddedSubscriptionPolicy.getData();
        this.jwtBandwidthSubPolicyId = jwtBandwidthAddedSubscriptionPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.jwtBandwidthSubPolicyId, (String)"The policy ID cannot be null or empty");
        AdvancedThrottlePolicyDTO jwtBandwidthAdvancedPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)"APIPolicyWithBandwidth", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)jwtBandwidthDefaultLimit, new ArrayList());
        ApiResponse jwtBandwidthAddedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(jwtBandwidthAdvancedPolicyDTO);
        Assert.assertEquals((int)jwtBandwidthAddedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO jwtBandwidthAddedAdvancedPolicyDTO = (AdvancedThrottlePolicyDTO)jwtBandwidthAddedPolicy.getData();
        this.jwtBandwidthApiPolicyId = jwtBandwidthAddedAdvancedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.jwtBandwidthApiPolicyId, (String)"The policy ID cannot be null or empty");
        String jwtBandwidthBackendUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        APIRequest jwtBandwidthApiRequest = new APIRequest("BandwidthTestAPI", "bandwithtestapi", new URL(jwtBandwidthBackendUrl), new URL(jwtBandwidthBackendUrl));
        jwtBandwidthApiRequest.setTags("youtube, token, media");
        jwtBandwidthApiRequest.setDescription("This is test API create by API manager integration test");
        jwtBandwidthApiRequest.setVersion("1.0.0");
        jwtBandwidthApiRequest.setSandbox(jwtBandwidthBackendUrl);
        jwtBandwidthApiRequest.setProvider(this.user.getUserName());
        jwtBandwidthApiRequest.setTiersCollection("Unlimited,SubPolicyWithBandwidth");
        ArrayList<APIOperationsDTO> jwtBandwidthOperations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO jwtBandwidthApiOperationsDTO = new APIOperationsDTO();
        jwtBandwidthApiOperationsDTO.setVerb("POST");
        jwtBandwidthApiOperationsDTO.setTarget("/*");
        jwtBandwidthApiOperationsDTO.setAuthType("Application & Application User");
        jwtBandwidthApiOperationsDTO.setThrottlingPolicy("Unlimited");
        jwtBandwidthOperations.add(jwtBandwidthApiOperationsDTO);
        jwtBandwidthApiRequest.setOperationsDTOS(jwtBandwidthOperations);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse jwtBandwidthServiceResponse = this.restAPIPublisher.addAPI(jwtBandwidthApiRequest);
        this.jwtBandwidthApiId = jwtBandwidthServiceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.jwtBandwidthApiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.jwtBandwidthApiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BandwidthTestAPI", "1.0.0", "\"isApiExists\":true");
        String jwtBandwidthGatewayUrl = this.getAPIInvocationURLHttps("bandwithtestapi/1.0.0/");
        HashMap jwtBandwidthRequestHeaders = new HashMap();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse jwtBandwidthResponse = HttpRequestUtil.doGet((String)jwtBandwidthBackendUrl, jwtBandwidthRequestHeaders);
        Assert.assertEquals((int)jwtBandwidthResponse.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
        ctx.setAttribute("jwtBandwidthApiId", (Object)this.jwtBandwidthApiId);
        ctx.setAttribute("jwtBandwidthGatewayUrl", (Object)jwtBandwidthGatewayUrl);
        ArrayList<String> burstControlRoleList = new ArrayList<String>();
        RequestCountLimitDTO burstControlRequestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)1, (Long)1000L);
        ThrottleLimitDTO burstControlDefaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)burstControlRequestCountLimit, null);
        burstControlRoleList.add("Internal/everyone");
        SubscriptionThrottlePolicyPermissionDTO burstControlPermissions = DtoFactory.createSubscriptionThrottlePolicyPermissionDTO((SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum)SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW, burstControlRoleList);
        this.burstControlSubscriptionThrottlePolicyDTO1 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)"SubscriptionTier5RPMburst", (String)"subscriptionTier5RPMburst", (String)"1000 request per min with burst of 5 requests per minute", (boolean)false, (ThrottleLimitDTO)burstControlDefaultLimit, (int)0, (int)0, (int)5, (String)"min", null, (boolean)true, (String)"COMMERCIAL", (int)0, (SubscriptionThrottlePolicyPermissionDTO)burstControlPermissions);
        ApiResponse burstControlApiResponse = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.burstControlSubscriptionThrottlePolicyDTO1);
        Assert.assertEquals((int)burstControlApiResponse.getStatusCode(), (int)201);
        this.burstControlSubscriptionThrottlePolicyDTO1 = (SubscriptionThrottlePolicyDTO)burstControlApiResponse.getData();
        this.burstControlSubscriptionThrottlePolicyDTO2 = DtoFactory.createSubscriptionThrottlePolicyDTO((String)"SubscriptionTier25RPMburst", (String)"subscriptionTier25RPMburst", (String)"1000 request per min with burst of 25 requests per minute", (boolean)false, (ThrottleLimitDTO)burstControlDefaultLimit, (int)0, (int)0, (int)25, (String)"min", null, (boolean)true, (String)"COMMERCIAL", (int)0, (SubscriptionThrottlePolicyPermissionDTO)burstControlPermissions);
        burstControlApiResponse = this.restAPIAdmin.addSubscriptionThrottlingPolicy(this.burstControlSubscriptionThrottlePolicyDTO2);
        Assert.assertEquals((int)burstControlApiResponse.getStatusCode(), (int)201);
        this.burstControlSubscriptionThrottlePolicyDTO2 = (SubscriptionThrottlePolicyDTO)burstControlApiResponse.getData();
        String burstControlBackendUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        APIRequest burstControlApiRequest = new APIRequest("APIThrottleBurstAPI", "api_burst", new URL(burstControlBackendUrl), new URL(burstControlBackendUrl));
        burstControlApiRequest.setVersion("1.0.0");
        burstControlApiRequest.setSandbox(burstControlBackendUrl);
        burstControlApiRequest.setProvider(this.user.getUserName());
        burstControlApiRequest.setTiersCollection("Unlimited,SubscriptionTier5RPMburst,SubscriptionTier25RPMburst");
        ArrayList<APIOperationsDTO> burstControlOperations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO burstControlApiOperationsDTO = new APIOperationsDTO();
        burstControlApiOperationsDTO.setVerb("POST");
        burstControlApiOperationsDTO.setTarget("/*");
        burstControlApiOperationsDTO.setAuthType("Application & Application User");
        burstControlApiOperationsDTO.setThrottlingPolicy("Unlimited");
        burstControlOperations.add(burstControlApiOperationsDTO);
        burstControlApiRequest.setOperationsDTOS(burstControlOperations);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse burstControlServiceResponse = this.restAPIPublisher.addAPI(burstControlApiRequest);
        this.burstControlApiId = burstControlServiceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.burstControlApiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.burstControlApiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIThrottleBurstAPI", "1.0.0", "\"isApiExists\":true");
        HashMap burstControlRequestHeaders = new HashMap();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse burstControlResponse = HttpRequestUtil.doGet((String)burstControlBackendUrl, burstControlRequestHeaders);
        Assert.assertEquals((int)burstControlResponse.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
        this.burstControlApplicationDTO = this.restAPIStore.addApplication("APIThrottleBurst-application", "Unlimited", "", "this-is-test");
        ctx.setAttribute("burstControlApplicationDTO", (Object)this.burstControlApplicationDTO);
        ctx.setAttribute("burstControlApiId", (Object)this.burstControlApiId);
        this.userManagementClient.addUser("graphqluser", "graphqlUser", new String[0], null);
        this.userManagementClient.addRole("graphqlrole", new String[]{"graphqluser"}, new String[0]);
        String graphQLSchemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "schema.graphql"), (Charset)StandardCharsets.UTF_8);
        File graphQLFile = this.getTempFileWithContent(graphQLSchemaDefinition);
        GraphQLValidationResponseDTO graphQLResponseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(graphQLFile);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = graphQLResponseApiDto.getGraphQLInfo();
        Assert.assertNotNull((Object)graphQLInfo);
        String graphQLArrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        JSONArray graphQLOperations = new JSONArray(graphQLArrayToJson);
        ArrayList<String> graphQLEnvironment = new ArrayList<String>();
        graphQLEnvironment.add("Default");
        ArrayList<String> graphQLPolicies = new ArrayList<String>();
        graphQLPolicies.add("Unlimited");
        JSONObject graphQLAdditionalPropertiesObj = new JSONObject();
        graphQLAdditionalPropertiesObj.put("name", (Object)"CountriesGraphqlAPI");
        graphQLAdditionalPropertiesObj.put("context", (Object)"info");
        graphQLAdditionalPropertiesObj.put("version", (Object)API_VERSION_1_0_0);
        JSONObject graphQLUrl = new JSONObject();
        graphQLUrl.put("url", (Object)"https://localhost:9943/am-graphQL-sample/api/graphql/");
        JSONObject graphQLEndpointConfig = new JSONObject();
        graphQLEndpointConfig.put("endpoint_type", (Object)"http");
        graphQLEndpointConfig.put("sandbox_endpoints", (Object)graphQLUrl);
        graphQLEndpointConfig.put("production_endpoints", (Object)graphQLUrl);
        graphQLAdditionalPropertiesObj.put("endpointConfig", (Object)graphQLEndpointConfig);
        graphQLAdditionalPropertiesObj.put("policies", graphQLPolicies);
        graphQLAdditionalPropertiesObj.put("operations", (Object)graphQLOperations);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO graphQLApidto = this.restAPIPublisher.importGraphqlSchemaDefinition(graphQLFile, graphQLAdditionalPropertiesObj.toString());
        this.graphQLAPIId = graphQLApidto.getId();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse graphQLCreatedApiResponse = this.restAPIPublisher.getAPI(this.graphQLAPIId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)graphQLCreatedApiResponse.getResponseCode(), (String)"CountriesGraphqlAPI API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.graphQLAPIId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.graphQLAPIId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CountriesGraphqlAPI", API_VERSION_1_0_0, "\"isApiExists\":true");
        ctx.setAttribute("graphQLSchemaDefinition", (Object)graphQLSchemaDefinition);
        ctx.setAttribute("graphQLAPIId", (Object)this.graphQLAPIId);
        AdminApiTestHelper customThrottlingAdminApiTestHelper = new AdminApiTestHelper();
        String customThrottlingPolicyName = "TestPolicy";
        String customThrottlingDescription = "This is a test custom throttle policy";
        String customThrottlingSiddhiQuery = "FROM RequestStream\nSELECT userId, ( userId == 'admin@carbon.super' ) AS isEligible, str:concat('admin@carbon.super','') as throttleKey\nINSERT INTO EligibilityStream; \n\nFROM EligibilityStream[isEligible==true]#throttler:timeBatch(1 min) \nSELECT throttleKey, (count(userId) >= 10) as isThrottled, expiryTimeStamp group by throttleKey \nINSERT ALL EVENTS into ResultStream;";
        String customThrottlingKeyTemplate = "$userId";
        CustomRuleDTO customThrottlingRuleDTO = DtoFactory.createCustomThrottlePolicyDTO((String)customThrottlingPolicyName, (String)customThrottlingDescription, (boolean)false, (String)customThrottlingSiddhiQuery, (String)customThrottlingKeyTemplate);
        ApiResponse customThrottlingAddedPolicy = this.restAPIAdmin.addCustomThrottlingPolicy(customThrottlingRuleDTO);
        Assert.assertEquals((int)customThrottlingAddedPolicy.getStatusCode(), (int)201);
        CustomRuleDTO customThrottlingAddedPolicyDTO = (CustomRuleDTO)customThrottlingAddedPolicy.getData();
        String customThrottlingPolicyId = customThrottlingAddedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)customThrottlingPolicyId, (String)"The policy ID cannot be null or empty");
        customThrottlingRuleDTO.setPolicyId(customThrottlingPolicyId);
        customThrottlingRuleDTO.setIsDeployed(Boolean.valueOf(true));
        customThrottlingAdminApiTestHelper.verifyCustomThrottlePolicyDTO(customThrottlingRuleDTO, customThrottlingAddedPolicyDTO);
        ctx.setAttribute("customThrottlingPolicyId", (Object)customThrottlingPolicyId);
        ctx.setAttribute("customThrottlingRuleDTO", (Object)customThrottlingRuleDTO);
        ctx.setAttribute("customThrottlingAdminApiTestHelper", (Object)customThrottlingAdminApiTestHelper);
        HashMap<String, String> apiLoggingHeader = new HashMap<String, String>();
        byte[] apiLoggingEncodedBytes = Base64.encodeBase64((byte[])BASIC_AUTH_HEADER.getBytes(StandardCharsets.UTF_8));
        apiLoggingHeader.put("Authorization", "Basic " + new String(apiLoggingEncodedBytes, StandardCharsets.UTF_8));
        apiLoggingHeader.put("Content-Type", "application/json");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiLoggingApplicationResponse = this.restAPIStore.createApplication("APILoggingTestApp", "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.apiLoggingApplicationId = apiLoggingApplicationResponse.getData();
        String apiLoggingBackendUrl = this.getAPIInvocationURLHttp("xmlapi", "1.0.0");
        APIRequest apiLoggingApiRequest = new APIRequest("APILoggingTestAPI", "apiloggingtest", new URL(apiLoggingBackendUrl));
        apiLoggingApiRequest.setVersion("1.0.0");
        apiLoggingApiRequest.setTiersCollection("Unlimited");
        apiLoggingApiRequest.setTier("Unlimited");
        apiLoggingApiRequest.setTags("testTag1, testTag2, testTag3");
        apiLoggingApiRequest.setProvider(this.user.getUserName());
        this.apiLoggingApiId = this.createPublishAndSubscribeToAPIUsingRest(apiLoggingApiRequest, this.restAPIPublisher, this.restAPIStore, this.apiLoggingApplicationId, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APILoggingTestAPI", "1.0.0", "\"isApiExists\":true");
        String addNewLoggerPayload = "{ \"logLevel\": \"FULL\" }";
        HTTPSClientUtils.doPut((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis/" + this.apiLoggingApiId), apiLoggingHeader, (String)addNewLoggerPayload);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiLoggingLoggingResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis?log-level=full"), apiLoggingHeader);
        Assert.assertEquals((String)apiLoggingLoggingResponse.getData(), (String)("{\"apis\":[{\"context\":\"/apiloggingtest/1.0.0\",\"logLevel\":\"FULL\",\"apiId\":\"" + this.apiLoggingApiId + "\"}]}"));
        ctx.setAttribute("apiLoggingApplicationId", (Object)this.apiLoggingApplicationId);
        Thread.sleep(5000L);
        this.restartServer();
        Thread.sleep(5000L);
        this.restartServer();
    }

    private void restartServer() throws Exception {
        AutomationContext superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        ServerConfigurationManager serverConfigurationManager = new ServerConfigurationManager(superTenantKeyManagerContext);
        serverConfigurationManager.restartGracefully();
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeDefaultAPIWithWait(String invocationUrl, Map<String, String> headers, int statusCode) throws IOException, InterruptedException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.invokeWithGet(invocationUrl, headers);
        int count = 0;
        if (response.getResponseCode() != statusCode) {
            do {
                Thread.sleep(10000L);
                response = this.invokeWithGet(invocationUrl, headers);
                if (response.getResponseCode() != 200) continue;
                return response;
            } while (++count > 6);
        }
        return response;
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeWithGet(String url, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        headers.forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        InputStream stream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)stream);
        HashMap<String, String> outputHeaders = new HashMap<String, String>();
        for (Header header : response.getAllHeaders()) {
            outputHeaders.put(header.getName(), header.getValue());
        }
        return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(content, response.getStatusLine().getStatusCode(), outputHeaders);
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @AfterSuite(alwaysRun=true)
    void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.apiThrottleApplicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiThrottleApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiThrottleApiId);
        this.restAPIStore.deleteApplication(this.defaultVersionApplicationID);
        this.restAPIPublisher.deleteAPI(this.defaultVersionApiId);
        this.restAPIStore.deleteApplication(this.jwtRevocationAppId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.jwtRevocationApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.jwtRevocationApiId);
        this.restAPIPublisher.deleteAPI(this.apiRevisionApiId);
        this.restAPIStore.deleteApplication(this.accessibilityOfBlockApplicationId);
        this.restAPIPublisher.deleteAPI(this.accessibilityOfBlockApiId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.jwtBandwidthApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.jwtBandwidthApiId);
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.jwtBandwidthApiPolicyId);
        this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.jwtBandwidthAppPolicyId);
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.jwtBandwidthSubPolicyId);
        this.restAPIStore.deleteApplication(this.burstControlApplicationDTO.getApplicationId());
        this.restAPIPublisher.deleteAPI(this.burstControlApiId);
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.burstControlSubscriptionThrottlePolicyDTO1.getPolicyId());
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.burstControlSubscriptionThrottlePolicyDTO2.getPolicyId());
        this.undeployAndDeleteAPIRevisionsUsingRest(this.graphQLAPIId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.graphQLAPIId);
        this.restAPIStore.deleteApplication(this.apiLoggingApplicationId);
        this.restAPIPublisher.deleteAPI(this.apiLoggingApiId);
        super.cleanUp();
    }
}

