/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.SubscriptionThrottlePolicy;

public class SubscriptionPolicyIndividualApi {
    private ApiClient apiClient;

    public SubscriptionPolicyIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionPolicyIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call throttlingPoliciesSubscriptionPolicyIdDeleteCall(String policyId, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling/policies/subscription/{policyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesSubscriptionPolicyIdDeleteValidateBeforeCall(String policyId, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling throttlingPoliciesSubscriptionPolicyIdDelete(Async)");
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdDeleteCall(policyId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void throttlingPoliciesSubscriptionPolicyIdDelete(String policyId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.throttlingPoliciesSubscriptionPolicyIdDeleteWithHttpInfo(policyId, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> throttlingPoliciesSubscriptionPolicyIdDeleteWithHttpInfo(String policyId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesSubscriptionPolicyIdDeleteValidateBeforeCall(policyId, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call throttlingPoliciesSubscriptionPolicyIdDeleteAsync(String policyId, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdDeleteValidateBeforeCall(policyId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call throttlingPoliciesSubscriptionPolicyIdGetCall(String policyId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling/policies/subscription/{policyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesSubscriptionPolicyIdGetValidateBeforeCall(String policyId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling throttlingPoliciesSubscriptionPolicyIdGet(Async)");
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdGetCall(policyId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionThrottlePolicy throttlingPoliciesSubscriptionPolicyIdGet(String policyId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<SubscriptionThrottlePolicy> resp = this.throttlingPoliciesSubscriptionPolicyIdGetWithHttpInfo(policyId, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<SubscriptionThrottlePolicy> throttlingPoliciesSubscriptionPolicyIdGetWithHttpInfo(String policyId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesSubscriptionPolicyIdGetValidateBeforeCall(policyId, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionThrottlePolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesSubscriptionPolicyIdGetAsync(String policyId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<SubscriptionThrottlePolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdGetValidateBeforeCall(policyId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionThrottlePolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call throttlingPoliciesSubscriptionPolicyIdPutCall(String policyId, SubscriptionThrottlePolicy body, String contentType, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubscriptionThrottlePolicy localVarPostBody = body;
        String localVarPath = "/throttling/policies/subscription/{policyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesSubscriptionPolicyIdPutValidateBeforeCall(String policyId, SubscriptionThrottlePolicy body, String contentType, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling throttlingPoliciesSubscriptionPolicyIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling throttlingPoliciesSubscriptionPolicyIdPut(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling throttlingPoliciesSubscriptionPolicyIdPut(Async)");
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdPutCall(policyId, body, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionThrottlePolicy throttlingPoliciesSubscriptionPolicyIdPut(String policyId, SubscriptionThrottlePolicy body, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<SubscriptionThrottlePolicy> resp = this.throttlingPoliciesSubscriptionPolicyIdPutWithHttpInfo(policyId, body, contentType, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<SubscriptionThrottlePolicy> throttlingPoliciesSubscriptionPolicyIdPutWithHttpInfo(String policyId, SubscriptionThrottlePolicy body, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesSubscriptionPolicyIdPutValidateBeforeCall(policyId, body, contentType, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionThrottlePolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesSubscriptionPolicyIdPutAsync(String policyId, SubscriptionThrottlePolicy body, String contentType, String ifMatch, String ifUnmodifiedSince, final ApiCallback<SubscriptionThrottlePolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesSubscriptionPolicyIdPutValidateBeforeCall(policyId, body, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionThrottlePolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

