/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.CustomAttribute;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleLimit;

public class SubscriptionThrottlePolicy {
    @SerializedName(value="policyId")
    private String policyId = null;
    @SerializedName(value="policyName")
    private String policyName = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="isDeployed")
    private Boolean isDeployed = false;
    @SerializedName(value="defaultLimit")
    private ThrottleLimit defaultLimit = null;
    @SerializedName(value="rateLimitCount")
    private Integer rateLimitCount = null;
    @SerializedName(value="rateLimitTimeUnit")
    private String rateLimitTimeUnit = null;
    @SerializedName(value="customAttributes")
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @SerializedName(value="stopOnQuotaReach")
    private Boolean stopOnQuotaReach = false;
    @SerializedName(value="billingPlan")
    private String billingPlan = null;

    public SubscriptionThrottlePolicy policyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    @ApiModelProperty(example="0c6439fd-9b16-3c2e-be6e-1086e0b9aa93", value="Id of policy")
    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public SubscriptionThrottlePolicy policyName(String policyName) {
        this.policyName = policyName;
        return this;
    }

    @ApiModelProperty(example="Policy1", required=true, value="Name of policy")
    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public SubscriptionThrottlePolicy displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="Display name of the policy")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SubscriptionThrottlePolicy description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the policy")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubscriptionThrottlePolicy isDeployed(Boolean isDeployed) {
        this.isDeployed = isDeployed;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the policy is deployed successfully or not.")
    public Boolean getIsDeployed() {
        return this.isDeployed;
    }

    public void setIsDeployed(Boolean isDeployed) {
        this.isDeployed = isDeployed;
    }

    public SubscriptionThrottlePolicy defaultLimit(ThrottleLimit defaultLimit) {
        this.defaultLimit = defaultLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ThrottleLimit getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(ThrottleLimit defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public SubscriptionThrottlePolicy rateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
        return this;
    }

    @ApiModelProperty(example="10", value="Burst control request count")
    public Integer getRateLimitCount() {
        return this.rateLimitCount;
    }

    public void setRateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
    }

    public SubscriptionThrottlePolicy rateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
        return this;
    }

    @ApiModelProperty(example="null", value="Burst control time unit")
    public String getRateLimitTimeUnit() {
        return this.rateLimitTimeUnit;
    }

    public void setRateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
    }

    public SubscriptionThrottlePolicy customAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public SubscriptionThrottlePolicy addCustomAttributesItem(CustomAttribute customAttributesItem) {
        this.customAttributes.add(customAttributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes added to the Subscription Throttling Policy ")
    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public SubscriptionThrottlePolicy stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="null", value="This indicates the action to be taken when a user goes beyond the allocated quota. If checked, the user's requests will be dropped. If unchecked, the requests will be allowed to pass through. ")
    public Boolean getStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public SubscriptionThrottlePolicy billingPlan(String billingPlan) {
        this.billingPlan = billingPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="define whether this is Paid or a Free plan. Allowed values are FREE or COMMERCIAL. ")
    public String getBillingPlan() {
        return this.billingPlan;
    }

    public void setBillingPlan(String billingPlan) {
        this.billingPlan = billingPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionThrottlePolicy subscriptionThrottlePolicy = (SubscriptionThrottlePolicy)o;
        return Objects.equals(this.policyId, subscriptionThrottlePolicy.policyId) && Objects.equals(this.policyName, subscriptionThrottlePolicy.policyName) && Objects.equals(this.displayName, subscriptionThrottlePolicy.displayName) && Objects.equals(this.description, subscriptionThrottlePolicy.description) && Objects.equals(this.isDeployed, subscriptionThrottlePolicy.isDeployed) && Objects.equals(this.defaultLimit, subscriptionThrottlePolicy.defaultLimit) && Objects.equals(this.rateLimitCount, subscriptionThrottlePolicy.rateLimitCount) && Objects.equals(this.rateLimitTimeUnit, subscriptionThrottlePolicy.rateLimitTimeUnit) && Objects.equals(this.customAttributes, subscriptionThrottlePolicy.customAttributes) && Objects.equals(this.stopOnQuotaReach, subscriptionThrottlePolicy.stopOnQuotaReach) && Objects.equals(this.billingPlan, subscriptionThrottlePolicy.billingPlan);
    }

    public int hashCode() {
        return Objects.hash(this.policyId, this.policyName, this.displayName, this.description, this.isDeployed, this.defaultLimit, this.rateLimitCount, this.rateLimitTimeUnit, this.customAttributes, this.stopOnQuotaReach, this.billingPlan);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionThrottlePolicy {\n");
        sb.append("    policyId: ").append(this.toIndentedString(this.policyId)).append("\n");
        sb.append("    policyName: ").append(this.toIndentedString(this.policyName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isDeployed: ").append(this.toIndentedString(this.isDeployed)).append("\n");
        sb.append("    defaultLimit: ").append(this.toIndentedString(this.defaultLimit)).append("\n");
        sb.append("    rateLimitCount: ").append(this.toIndentedString(this.rateLimitCount)).append("\n");
        sb.append("    rateLimitTimeUnit: ").append(this.toIndentedString(this.rateLimitTimeUnit)).append("\n");
        sb.append("    customAttributes: ").append(this.toIndentedString(this.customAttributes)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("    billingPlan: ").append(this.toIndentedString(this.billingPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

