/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.1.66/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.11.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ThrottleLimit
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-01T13:06:20.200+05:30")

public class ThrottleLimit {
  /**
   * Type of the throttling limit. Allowed values are \"RequestCountLimit\" and \"BandwidthLimit\". Please see schemas of each of those throttling limit types in Definitions section. 
   */
  public enum TypeEnum {
    @SerializedName("RequestCountLimit")
    REQUESTCOUNTLIMIT("RequestCountLimit"),
    
    @SerializedName("BandwidthLimit")
    BANDWIDTHLIMIT("BandwidthLimit");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("timeUnit")
  private String timeUnit = null;

  @SerializedName("unitTime")
  private Integer unitTime = null;

  public ThrottleLimit type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Type of the throttling limit. Allowed values are \"RequestCountLimit\" and \"BandwidthLimit\". Please see schemas of each of those throttling limit types in Definitions section. 
   * @return type
  **/
  @ApiModelProperty(example = "RequestCountLimit", required = true, value = "Type of the throttling limit. Allowed values are \"RequestCountLimit\" and \"BandwidthLimit\". Please see schemas of each of those throttling limit types in Definitions section. ")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public ThrottleLimit timeUnit(String timeUnit) {
    this.timeUnit = timeUnit;
    return this;
  }

   /**
   * Unit of the time. Allowed values are \"sec\", \"min\", \"hour\", \"day\"
   * @return timeUnit
  **/
  @ApiModelProperty(example = "min", required = true, value = "Unit of the time. Allowed values are \"sec\", \"min\", \"hour\", \"day\"")
  public String getTimeUnit() {
    return timeUnit;
  }

  public void setTimeUnit(String timeUnit) {
    this.timeUnit = timeUnit;
  }

  public ThrottleLimit unitTime(Integer unitTime) {
    this.unitTime = unitTime;
    return this;
  }

   /**
   * Time limit that the throttling limit applies.
   * @return unitTime
  **/
  @ApiModelProperty(example = "10", required = true, value = "Time limit that the throttling limit applies.")
  public Integer getUnitTime() {
    return unitTime;
  }

  public void setUnitTime(Integer unitTime) {
    this.unitTime = unitTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThrottleLimit throttleLimit = (ThrottleLimit) o;
    return Objects.equals(this.type, throttleLimit.type) &&
        Objects.equals(this.timeUnit, throttleLimit.timeUnit) &&
        Objects.equals(this.unitTime, throttleLimit.unitTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, timeUnit, unitTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThrottleLimit {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    timeUnit: ").append(toIndentedString(timeUnit)).append("\n");
    sb.append("    unitTime: ").append(toIndentedString(unitTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

