/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ApplicationThrottlePolicy;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ApplicationThrottlePolicyList;

public class ApplicationPolicyCollectionApi {
    private ApiClient apiClient;

    public ApplicationPolicyCollectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationPolicyCollectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call throttlingPoliciesApplicationGetCall(String accept, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling/policies/application".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesApplicationGetValidateBeforeCall(String accept, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.throttlingPoliciesApplicationGetCall(accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationThrottlePolicyList throttlingPoliciesApplicationGet(String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<ApplicationThrottlePolicyList> resp = this.throttlingPoliciesApplicationGetWithHttpInfo(accept, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<ApplicationThrottlePolicyList> throttlingPoliciesApplicationGetWithHttpInfo(String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesApplicationGetValidateBeforeCall(accept, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<ApplicationThrottlePolicyList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesApplicationGetAsync(String accept, String ifNoneMatch, String ifModifiedSince, final ApiCallback<ApplicationThrottlePolicyList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesApplicationGetValidateBeforeCall(accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationThrottlePolicyList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call throttlingPoliciesApplicationPostCall(ApplicationThrottlePolicy body, String contentType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationThrottlePolicy localVarPostBody = body;
        String localVarPath = "/throttling/policies/application".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesApplicationPostValidateBeforeCall(ApplicationThrottlePolicy body, String contentType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling throttlingPoliciesApplicationPost(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling throttlingPoliciesApplicationPost(Async)");
        }
        Call call = this.throttlingPoliciesApplicationPostCall(body, contentType, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationThrottlePolicy throttlingPoliciesApplicationPost(ApplicationThrottlePolicy body, String contentType) throws ApiException {
        ApiResponse<ApplicationThrottlePolicy> resp = this.throttlingPoliciesApplicationPostWithHttpInfo(body, contentType);
        return resp.getData();
    }

    public ApiResponse<ApplicationThrottlePolicy> throttlingPoliciesApplicationPostWithHttpInfo(ApplicationThrottlePolicy body, String contentType) throws ApiException {
        Call call = this.throttlingPoliciesApplicationPostValidateBeforeCall(body, contentType, null, null);
        Type localVarReturnType = new TypeToken<ApplicationThrottlePolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesApplicationPostAsync(ApplicationThrottlePolicy body, String contentType, final ApiCallback<ApplicationThrottlePolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesApplicationPostValidateBeforeCall(body, contentType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationThrottlePolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

