/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.Workflow;

public class WorkflowsIndividualApi {
    private ApiClient apiClient;

    public WorkflowsIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call workflowsUpdateWorkflowStatusPostCall(String workflowReferenceId, Workflow body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Workflow localVarPostBody = body;
        String localVarPath = "/workflows/update-workflow-status".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (workflowReferenceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "workflowReferenceId", workflowReferenceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workflowsUpdateWorkflowStatusPostValidateBeforeCall(String workflowReferenceId, Workflow body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (workflowReferenceId == null) {
            throw new ApiException("Missing the required parameter 'workflowReferenceId' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        Call call = this.workflowsUpdateWorkflowStatusPostCall(workflowReferenceId, body, progressListener, progressRequestListener);
        return call;
    }

    public Workflow workflowsUpdateWorkflowStatusPost(String workflowReferenceId, Workflow body) throws ApiException {
        ApiResponse<Workflow> resp = this.workflowsUpdateWorkflowStatusPostWithHttpInfo(workflowReferenceId, body);
        return resp.getData();
    }

    public ApiResponse<Workflow> workflowsUpdateWorkflowStatusPostWithHttpInfo(String workflowReferenceId, Workflow body) throws ApiException {
        Call call = this.workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, null, null);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workflowsUpdateWorkflowStatusPostAsync(String workflowReferenceId, Workflow body, final ApiCallback<Workflow> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

