/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Workflow {
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = new HashMap<String, String>();
    @SerializedName(value="description")
    private String description = null;

    public Workflow status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="APPROVED", required=true, value="This attribute declares whether this workflow task is approved or rejected. ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Workflow attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Workflow putAttributesItem(String key, String attributesItem) {
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes to complete the workflow task ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Workflow description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Approve workflow request.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals((Object)this.status, (Object)workflow.status) && Objects.equals(this.attributes, workflow.attributes) && Objects.equals(this.description, workflow.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.attributes, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workflow {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        APPROVED("APPROVED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

