/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.Tier;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.TierPermission;

public class ThrottlingTierIndividualApi {
    private ApiClient apiClient;

    public ThrottlingTierIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThrottlingTierIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call tiersTierLevelTierNameDeleteCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tiers/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tiersTierLevelTierNameDeleteValidateBeforeCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling tiersTierLevelTierNameDelete(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling tiersTierLevelTierNameDelete(Async)");
        }
        Call call = this.tiersTierLevelTierNameDeleteCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void tiersTierLevelTierNameDelete(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.tiersTierLevelTierNameDeleteWithHttpInfo(tierName, tierLevel, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> tiersTierLevelTierNameDeleteWithHttpInfo(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.tiersTierLevelTierNameDeleteValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call tiersTierLevelTierNameDeleteAsync(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tiersTierLevelTierNameDeleteValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call tiersTierLevelTierNameGetCall(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tiers/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tiersTierLevelTierNameGetValidateBeforeCall(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling tiersTierLevelTierNameGet(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling tiersTierLevelTierNameGet(Async)");
        }
        Call call = this.tiersTierLevelTierNameGetCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Tier tiersTierLevelTierNameGet(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<Tier> resp = this.tiersTierLevelTierNameGetWithHttpInfo(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<Tier> tiersTierLevelTierNameGetWithHttpInfo(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.tiersTierLevelTierNameGetValidateBeforeCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tiersTierLevelTierNameGetAsync(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Tier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tiersTierLevelTierNameGetValidateBeforeCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call tiersTierLevelTierNamePutCall(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Tier localVarPostBody = body;
        String localVarPath = "/tiers/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tiersTierLevelTierNamePutValidateBeforeCall(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling tiersTierLevelTierNamePut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling tiersTierLevelTierNamePut(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling tiersTierLevelTierNamePut(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling tiersTierLevelTierNamePut(Async)");
        }
        Call call = this.tiersTierLevelTierNamePutCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Tier tiersTierLevelTierNamePut(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<Tier> resp = this.tiersTierLevelTierNamePutWithHttpInfo(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<Tier> tiersTierLevelTierNamePutWithHttpInfo(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.tiersTierLevelTierNamePutValidateBeforeCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tiersTierLevelTierNamePutAsync(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Tier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tiersTierLevelTierNamePutValidateBeforeCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call tiersUpdatePermissionPostCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TierPermission localVarPostBody = permissions;
        String localVarPath = "/tiers/update-permission".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (tierName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tierName", tierName));
        }
        if (tierLevel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tierLevel", tierLevel));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tiersUpdatePermissionPostValidateBeforeCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling tiersUpdatePermissionPost(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling tiersUpdatePermissionPost(Async)");
        }
        Call call = this.tiersUpdatePermissionPostCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, progressListener, progressRequestListener);
        return call;
    }

    public List<Tier> tiersUpdatePermissionPost(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions) throws ApiException {
        ApiResponse<List<Tier>> resp = this.tiersUpdatePermissionPostWithHttpInfo(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions);
        return resp.getData();
    }

    public ApiResponse<List<Tier>> tiersUpdatePermissionPostWithHttpInfo(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions) throws ApiException {
        Call call = this.tiersUpdatePermissionPostValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, null, null);
        Type localVarReturnType = new TypeToken<List<Tier>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tiersUpdatePermissionPostAsync(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, final ApiCallback<List<Tier>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tiersUpdatePermissionPostValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Tier>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

