/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.store.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.API;

public class APIIndividualApi {
    private ApiClient apiClient;

    public APIIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public APIIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call apisApiIdGetCall(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{format\\}", "json").replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdGetValidateBeforeCall(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdGet(Async)");
        }
        Call call = this.apisApiIdGetCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public API apisApiIdGet(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant) throws ApiException {
        ApiResponse<API> resp = this.apisApiIdGetWithHttpInfo(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant);
        return resp.getData();
    }

    public ApiResponse<API> apisApiIdGetWithHttpInfo(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant) throws ApiException {
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, null, null);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdGetAsync(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, final ApiCallback<API> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call apisApiIdSwaggerGetCall(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/swagger".replaceAll("\\{format\\}", "json").replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSwaggerGetValidateBeforeCall(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSwaggerGet(Async)");
        }
        Call call = this.apisApiIdSwaggerGetCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdSwaggerGet(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant) throws ApiException {
        this.apisApiIdSwaggerGetWithHttpInfo(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant);
    }

    public ApiResponse<Void> apisApiIdSwaggerGetWithHttpInfo(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant) throws ApiException {
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdSwaggerGetAsync(String apiId, String accept, String ifNoneMatch, String ifModifiedSince, String xWSO2Tenant, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, accept, ifNoneMatch, ifModifiedSince, xWSO2Tenant, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call apisApiIdThumbnailGetCall(String apiId, String xWSO2Tenant, String accept, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/thumbnail".replaceAll("\\{format\\}", "json").replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdThumbnailGetValidateBeforeCall(String apiId, String xWSO2Tenant, String accept, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdThumbnailGet(Async)");
        }
        Call call = this.apisApiIdThumbnailGetCall(apiId, xWSO2Tenant, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdThumbnailGet(String apiId, String xWSO2Tenant, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdThumbnailGetWithHttpInfo(apiId, xWSO2Tenant, accept, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdThumbnailGetWithHttpInfo(String apiId, String xWSO2Tenant, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, xWSO2Tenant, accept, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdThumbnailGetAsync(String apiId, String xWSO2Tenant, String accept, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, xWSO2Tenant, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call apisGenerateSdkPostCall(String apiId, String language, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/generate-sdk/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apiId", apiId));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisGenerateSdkPostValidateBeforeCall(String apiId, String language, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisGenerateSdkPost(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling apisGenerateSdkPost(Async)");
        }
        Call call = this.apisGenerateSdkPostCall(apiId, language, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public void apisGenerateSdkPost(String apiId, String language, String xWSO2Tenant) throws ApiException {
        this.apisGenerateSdkPostWithHttpInfo(apiId, language, xWSO2Tenant);
    }

    public ApiResponse<Void> apisGenerateSdkPostWithHttpInfo(String apiId, String language, String xWSO2Tenant) throws ApiException {
        Call call = this.apisGenerateSdkPostValidateBeforeCall(apiId, language, xWSO2Tenant, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisGenerateSdkPostAsync(String apiId, String language, String xWSO2Tenant, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisGenerateSdkPostValidateBeforeCall(apiId, language, xWSO2Tenant, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

